/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.ElytronMessages;

public final class ServiceLoaderServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final ServiceLoader<HttpServerAuthenticationMechanismFactory> serviceLoader;

    public ServiceLoaderServerMechanismFactory(ServiceLoader<HttpServerAuthenticationMechanismFactory> serviceLoader) {
        this.serviceLoader = (ServiceLoader)Assert.checkNotNullParam((String)"serviceLoader", serviceLoader);
    }

    public ServiceLoaderServerMechanismFactory(ClassLoader classLoader) {
        this(ServiceLoader.load(HttpServerAuthenticationMechanismFactory.class, (ClassLoader)Assert.checkNotNullParam((String)"classLoader", (Object)classLoader)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        LinkedHashSet names = new LinkedHashSet();
        ServiceLoader<HttpServerAuthenticationMechanismFactory> serviceLoader = this.serviceLoader;
        synchronized (serviceLoader) {
            Iterator<HttpServerAuthenticationMechanismFactory> factoryIterator = this.serviceLoader.iterator();
            try {
                while (factoryIterator.hasNext()) {
                    HttpServerAuthenticationMechanismFactory current = factoryIterator.next();
                    Collections.addAll(names, current.getMechanismNames(properties));
                }
            }
            catch (ServiceConfigurationError e) {
                ElytronMessages.log.debug("Unable to read service configuration", e);
            }
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by service loader in %s: %s", (Object)HttpServerAuthenticationMechanismFactory.class.getSimpleName(), (Object)this.getClass().getSimpleName(), (Object)this.serviceLoader.toString());
        }
        return names.toArray(new String[names.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        ServiceLoader<HttpServerAuthenticationMechanismFactory> serviceLoader = this.serviceLoader;
        synchronized (serviceLoader) {
            Iterator<HttpServerAuthenticationMechanismFactory> factoryIterator = this.serviceLoader.iterator();
            try {
                while (factoryIterator.hasNext()) {
                    HttpServerAuthenticationMechanismFactory current = factoryIterator.next();
                    HttpServerAuthenticationMechanism authenticationMechanism = current.createAuthenticationMechanism(mechanismName, properties, callbackHandler);
                    if (authenticationMechanism == null) continue;
                    return authenticationMechanism;
                }
            }
            catch (ServiceConfigurationError e) {
                ElytronMessages.log.debug("Unable to read service configuration", e);
            }
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by service loader in %s: %s", (Object)HttpServerAuthenticationMechanismFactory.class.getSimpleName(), (Object)this.getClass().getSimpleName(), (Object)this.serviceLoader.toString());
        }
        return null;
    }
}

