/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.xmlconfig;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Vetoed;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.server.parsing.ExtensionHandler;
import org.jboss.as.server.parsing.StandaloneXml;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;
import org.wildfly.swarm.container.runtime.xmlconfig.WrappedXMLStreamReader;

@Vetoed
public class StandaloneXMLParser {
    private static final String SERVER = "server";
    private Set<QName> recognizedNames = new HashSet<QName>();
    private final XMLMapper xmlMapper;
    private final StandaloneXml parserDelegate = new StandaloneXml(new ExtensionHandler(){

        public void parseExtensions(XMLExtendedStreamReader reader, ModelNode address, Namespace namespace, List<ModelNode> list) throws XMLStreamException {
            reader.discardRemainder();
        }

        public Set<ProfileParsingCompletionHandler> getProfileParsingCompletionHandlers() {
            return Collections.emptySet();
        }

        public void writeExtensions(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        }
    }, new StandaloneXml.ParsingOption[]{StandaloneXml.ParsingOption.IGNORE_SUBSYSTEM_FAILURES});

    public StandaloneXMLParser() {
        this.xmlMapper = XMLMapper.Factory.create();
        this.addDelegate(new QName(Namespace.CURRENT.getUriString(), SERVER), (XMLElementReader<List<ModelNode>>)this.parserDelegate);
        this.addDelegate(new QName("urn:jboss:domain:4.1", SERVER), (XMLElementReader<List<ModelNode>>)this.parserDelegate);
        this.addDelegate(new QName("urn:jboss:domain:4.0", SERVER), (XMLElementReader<List<ModelNode>>)this.parserDelegate);
    }

    public StandaloneXMLParser addDelegate(QName elementName, XMLElementReader<List<ModelNode>> parser) {
        this.recognizedNames.add(elementName);
        this.xmlMapper.registerRootElement(elementName, parser);
        return this;
    }

    public List<ModelNode> parse(URL xml) throws Exception {
        ArrayList<ModelNode> operationList = new ArrayList<ModelNode>();
        try (InputStream input = xml.openStream();){
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            WrappedXMLStreamReader wrappedReader = new WrappedXMLStreamReader(reader, this.recognizedNames, this.xmlMapper);
            this.xmlMapper.parseDocument(operationList, (XMLStreamReader)wrappedReader);
        }
        return operationList;
    }

    @Vetoed
    private static class NoopXMLElementReader
    implements XMLElementReader<List<ModelNode>> {
        private NoopXMLElementReader() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> modelNode) throws XMLStreamException {
            reader.discardRemainder();
        }
    }
}

