/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.EjbHomeViewDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.iiop.EjbIIOPService;
import org.jboss.as.ejb3.iiop.EjbIIOPTransactionInterceptor;
import org.jboss.as.ejb3.iiop.POARegistry;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.IIOPSettingsService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.metadata.ejb.jboss.IIOPMetaData;
import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NamingContextExt;
import org.omg.PortableServer.POA;
import org.wildfly.iiop.openjdk.deployment.IIOPDeploymentMarker;
import org.wildfly.iiop.openjdk.rmi.AttributeAnalysis;
import org.wildfly.iiop.openjdk.rmi.InterfaceAnalysis;
import org.wildfly.iiop.openjdk.rmi.OperationAnalysis;
import org.wildfly.iiop.openjdk.rmi.RMIIIOPViolationException;
import org.wildfly.iiop.openjdk.rmi.marshal.strategy.SkeletonStrategy;
import org.wildfly.iiop.openjdk.service.CorbaNamingService;
import org.wildfly.iiop.openjdk.service.CorbaORBService;
import org.wildfly.iiop.openjdk.service.CorbaPOAService;
import org.wildfly.iiop.openjdk.service.IORSecConfigMetaDataService;

public class EjbIIOPDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private final IIOPSettingsService settingsService;

    public EjbIIOPDeploymentUnitProcessor(IIOPSettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List iiopMetaDatas;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!IIOPDeploymentMarker.isIIOPDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        if (!EjbDeploymentMarker.isEjbDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        HashMap<String, IIOPMetaData> iiopMetaDataMap = new HashMap<String, IIOPMetaData>();
        EjbJarMetaData ejbMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbMetaData != null && ejbMetaData.getAssemblyDescriptor() != null && (iiopMetaDatas = ejbMetaData.getAssemblyDescriptor().getAny(IIOPMetaData.class)) != null && iiopMetaDatas.size() > 0) {
            for (IIOPMetaData metaData : iiopMetaDatas) {
                iiopMetaDataMap.put(metaData.getEjbName(), metaData);
            }
        }
        DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(Attachments.CLASS_INDEX);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (moduleDescription != null) {
            for (ComponentDescription componentDescription : moduleDescription.getComponentDescriptions()) {
                EJBComponentDescription ejbComponentDescription;
                if (!(componentDescription instanceof EJBComponentDescription) || (ejbComponentDescription = (EJBComponentDescription)componentDescription).getEjbRemoteView() == null || ejbComponentDescription.getEjbHomeView() == null) continue;
                IIOPMetaData iiopMetaData = (IIOPMetaData)iiopMetaDataMap.get(ejbComponentDescription.getEJBName());
                if (iiopMetaData == null) {
                    iiopMetaData = (IIOPMetaData)iiopMetaDataMap.get("*");
                }
                if (iiopMetaData == null && !this.settingsService.isEnabledByDefault()) continue;
                this.processEjb(ejbComponentDescription, classIndex, deploymentReflectionIndex, module, phaseContext.getServiceTarget(), iiopMetaData);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processEjb(EJBComponentDescription componentDescription, DeploymentClassIndex classIndex, DeploymentReflectionIndex deploymentReflectionIndex, Module module, ServiceTarget serviceTarget, IIOPMetaData iiopMetaData) {
        InterfaceAnalysis homeInterfaceAnalysis;
        InterfaceAnalysis remoteInterfaceAnalysis;
        ClassIndex homeClass;
        ClassIndex remoteClass;
        componentDescription.setExposedViaIiop(true);
        EJBViewDescription remoteView = componentDescription.getEjbRemoteView();
        try {
            remoteClass = classIndex.classIndex(remoteView.getViewClassName());
        }
        catch (ClassNotFoundException e) {
            throw EjbLogger.ROOT_LOGGER.failedToLoadViewClassForComponent(e, componentDescription.getEJBClassName());
        }
        EjbHomeViewDescription homeView = componentDescription.getEjbHomeView();
        try {
            homeClass = classIndex.classIndex(homeView.getViewClassName());
        }
        catch (ClassNotFoundException e) {
            throw EjbLogger.ROOT_LOGGER.failedToLoadViewClassForComponent(e, componentDescription.getEJBClassName());
        }
        componentDescription.getEjbHomeView().getConfigurators().add(new IIOPInterceptorViewConfigurator());
        componentDescription.getEjbRemoteView().getConfigurators().add(new IIOPInterceptorViewConfigurator());
        try {
            remoteInterfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis((Class)remoteClass.getModuleClass());
        }
        catch (RMIIIOPViolationException e) {
            throw EjbLogger.ROOT_LOGGER.failedToAnalyzeRemoteInterface((Exception)((Object)e), componentDescription.getComponentName());
        }
        HashMap<String, SkeletonStrategy> beanMethodMap = new HashMap<String, SkeletonStrategy>();
        AttributeAnalysis[] remoteAttrs = remoteInterfaceAnalysis.getAttributes();
        for (int i = 0; i < remoteAttrs.length; ++i) {
            OperationAnalysis op = remoteAttrs[i].getAccessorAnalysis();
            if (op == null) continue;
            EjbLogger.ROOT_LOGGER.debugf("    %s\n                %s", op.getJavaName(), op.getIDLName());
            Method method = this.translateMethod(deploymentReflectionIndex, op);
            beanMethodMap.put(op.getIDLName(), new SkeletonStrategy(method));
            OperationAnalysis setop = remoteAttrs[i].getMutatorAnalysis();
            if (setop == null) continue;
            EjbLogger.ROOT_LOGGER.debugf("    %s\n                %s", setop.getJavaName(), setop.getIDLName());
            Method realSetmethod = this.translateMethod(deploymentReflectionIndex, setop);
            beanMethodMap.put(setop.getIDLName(), new SkeletonStrategy(realSetmethod));
        }
        OperationAnalysis[] ops = remoteInterfaceAnalysis.getOperations();
        for (int i = 0; i < ops.length; ++i) {
            EjbLogger.ROOT_LOGGER.debugf("    %s\n                %s", ops[i].getJavaName(), ops[i].getIDLName());
            beanMethodMap.put(ops[i].getIDLName(), new SkeletonStrategy(this.translateMethod(deploymentReflectionIndex, ops[i])));
        }
        String[] beanRepositoryIds = remoteInterfaceAnalysis.getAllTypeIds();
        try {
            homeInterfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis((Class)homeClass.getModuleClass());
        }
        catch (RMIIIOPViolationException e) {
            throw EjbLogger.ROOT_LOGGER.failedToAnalyzeRemoteInterface((Exception)((Object)e), componentDescription.getComponentName());
        }
        HashMap<String, SkeletonStrategy> homeMethodMap = new HashMap<String, SkeletonStrategy>();
        AttributeAnalysis[] attrs = homeInterfaceAnalysis.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            OperationAnalysis op = attrs[i].getAccessorAnalysis();
            if (op == null) continue;
            EjbLogger.ROOT_LOGGER.debugf("    %s\n                %s", op.getJavaName(), op.getIDLName());
            homeMethodMap.put(op.getIDLName(), new SkeletonStrategy(this.translateMethod(deploymentReflectionIndex, op)));
            OperationAnalysis setop = attrs[i].getMutatorAnalysis();
            if (setop == null) continue;
            EjbLogger.ROOT_LOGGER.debugf("    %s\n                %s", setop.getJavaName(), setop.getIDLName());
            homeMethodMap.put(setop.getIDLName(), new SkeletonStrategy(this.translateMethod(deploymentReflectionIndex, setop)));
        }
        OperationAnalysis[] homeops = homeInterfaceAnalysis.getOperations();
        for (int i = 0; i < homeops.length; ++i) {
            EjbLogger.ROOT_LOGGER.debugf("    %s\n                %s", homeops[i].getJavaName(), homeops[i].getIDLName());
            homeMethodMap.put(homeops[i].getIDLName(), new SkeletonStrategy(this.translateMethod(deploymentReflectionIndex, homeops[i])));
        }
        String[] homeRepositoryIds = homeInterfaceAnalysis.getAllTypeIds();
        EjbIIOPService service = new EjbIIOPService(beanMethodMap, beanRepositoryIds, homeMethodMap, homeRepositoryIds, this.settingsService.isUseQualifiedName(), iiopMetaData, module);
        ServiceBuilder builder = serviceTarget.addService(componentDescription.getServiceName().append(EjbIIOPService.SERVICE_NAME), (Service)service);
        builder.addDependency(componentDescription.getCreateServiceName(), EJBComponent.class, service.getEjbComponentInjectedValue());
        builder.addDependency(homeView.getServiceName(), ComponentView.class, service.getHomeView());
        builder.addDependency(remoteView.getServiceName(), ComponentView.class, service.getRemoteView());
        builder.addDependency(CorbaORBService.SERVICE_NAME, ORB.class, service.getOrb());
        builder.addDependency(POARegistry.SERVICE_NAME, POARegistry.class, service.getPoaRegistry());
        builder.addDependency(CorbaPOAService.INTERFACE_REPOSITORY_SERVICE_NAME, POA.class, service.getIrPoa());
        builder.addDependency(CorbaNamingService.SERVICE_NAME, NamingContextExt.class, service.getCorbaNamingContext());
        builder.addDependency(IORSecConfigMetaDataService.SERVICE_NAME, IORSecurityConfigMetaData.class, service.getIORSecConfigMetaDataInjectedValue());
        builder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.getServiceModuleLoaderInjectedValue());
        builder.addDependency(TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER);
        builder.install();
    }

    private Method translateMethod(DeploymentReflectionIndex deploymentReflectionIndex, OperationAnalysis op) {
        Method nonMethod = op.getMethod();
        return deploymentReflectionIndex.getClassIndex(nonMethod.getDeclaringClass()).getMethod(nonMethod);
    }

    private static class IIOPInterceptorViewConfigurator
    implements ViewConfigurator {
        private IIOPInterceptorViewConfigurator() {
        }

        public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
            EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
            if (ejbComponentDescription.getTransactionManagementType() == TransactionManagementType.CONTAINER) {
                configuration.addViewInterceptor(EjbIIOPTransactionInterceptor.FACTORY, 32);
            }
        }
    }
}

