/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ee.structure.JBossDescriptorPropertyReplacement;
import org.jboss.as.ee.structure.SpecDescriptorPropertyReplacement;
import org.jboss.as.ejb3.cache.EJBBoundCacheParser;
import org.jboss.as.ejb3.clustering.EJBBoundClusteringMetaDataParser;
import org.jboss.as.ejb3.deliveryactive.parser.EJBBoundDeliveryActiveMetaDataParser;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.EjbJarJBossAllParser;
import org.jboss.as.ejb3.interceptor.ContainerInterceptorsParser;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.pool.EJBBoundPoolParser;
import org.jboss.as.ejb3.resourceadapterbinding.parser.EJBBoundResourceAdapterBindingMetaDataParser;
import org.jboss.as.ejb3.security.parser.EJBBoundSecurityMetaDataParser;
import org.jboss.as.ejb3.security.parser.EJBBoundSecurityMetaDataParser11;
import org.jboss.as.ejb3.security.parser.SecurityRoleMetaDataParser;
import org.jboss.as.ejb3.timerservice.TimerServiceMetaDataParser;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.ejb.parser.jboss.ejb3.IIOPMetaDataParser;
import org.jboss.metadata.ejb.parser.jboss.ejb3.JBossEjb3MetaDataParser;
import org.jboss.metadata.ejb.parser.jboss.ejb3.TransactionTimeoutMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AbstractMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.EjbJarMetaDataParser;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.vfs.VirtualFile;

public class EjbJarParsingDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private static final String WAR_FILE_EXTENSION = ".war";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String EJB_JAR_XML = "ejb-jar.xml";
    private static final String JBOSS_EJB3_XML = "jboss-ejb3.xml";
    private static final String META_INF = "META-INF";
    private static final String WEB_INF = "WEB-INF";

    public void deploy(DeploymentPhaseContext deploymentPhase) throws DeploymentUnitProcessingException {
        EjbJarMetaData ejbJarMetaData;
        DeploymentUnit deploymentUnit = deploymentPhase.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        EjbJarMetaData specMetaData = EjbJarParsingDeploymentUnitProcessor.parseEjbJarXml(deploymentUnit);
        EjbJarMetaData jbossMetaData = EjbJarParsingDeploymentUnitProcessor.parseJBossEjb3Xml(deploymentUnit);
        if (specMetaData == null) {
            if (jbossMetaData == null) {
                return;
            }
            ejbJarMetaData = jbossMetaData;
        } else {
            ejbJarMetaData = jbossMetaData == null ? specMetaData : jbossMetaData.createMerged(specMetaData);
        }
        EjbDeploymentMarker.mark((DeploymentUnit)deploymentUnit);
        if (!deploymentUnit.hasAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION)) {
            EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            EjbJarDescription ejbModuleDescription = new EjbJarDescription(moduleDescription, applicationClassesDescription, deploymentUnit.getName().endsWith(WAR_FILE_EXTENSION));
            deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION, (Object)ejbModuleDescription);
        }
        deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA, (Object)ejbJarMetaData);
        if (jbossMetaData != null && jbossMetaData.getDistinctName() != null) {
            deploymentUnit.putAttachment(org.jboss.as.ee.structure.Attachments.DISTINCT_NAME, (Object)jbossMetaData.getDistinctName());
        }
        if (ejbJarMetaData.getModuleName() != null) {
            eeModuleDescription.setModuleName(ejbJarMetaData.getModuleName());
        }
        if (ejbJarMetaData.isMetadataComplete()) {
            MetadataCompleteMarker.setMetadataComplete((DeploymentUnit)deploymentUnit, (boolean)true);
        }
        if (!ejbJarMetaData.isEJB3x()) {
            MetadataCompleteMarker.setMetadataComplete((DeploymentUnit)deploymentUnit, (boolean)true);
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }

    private static VirtualFile getDescriptor(VirtualFile deploymentRoot, String descriptorName) {
        VirtualFile descriptor;
        if (EjbJarParsingDeploymentUnitProcessor.isWar(deploymentRoot)) {
            descriptor = deploymentRoot.getChild("WEB-INF/" + descriptorName);
        } else if (deploymentRoot.getName().toLowerCase(Locale.ENGLISH).endsWith(JAR_FILE_EXTENSION)) {
            descriptor = deploymentRoot.getChild("META-INF/" + descriptorName);
        } else {
            return null;
        }
        if (descriptor == null || !descriptor.exists()) {
            return null;
        }
        return descriptor;
    }

    private static XMLStreamReader getXMLStreamReader(InputStream stream, VirtualFile ejbJarXml, XMLResolver resolver) throws DeploymentUnitProcessingException {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(resolver);
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(stream);
            return xmlReader;
        }
        catch (XMLStreamException xmlse) {
            throw EjbLogger.ROOT_LOGGER.failedToParse(xmlse, "ejb-jar.xml: " + ejbJarXml.getPathName());
        }
    }

    private static boolean isWar(VirtualFile deploymentRoot) {
        return deploymentRoot.getName().toLowerCase(Locale.ENGLISH).endsWith(WAR_FILE_EXTENSION);
    }

    private static InputStream open(VirtualFile file) throws DeploymentUnitProcessingException {
        try {
            return file.openStream();
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private static EjbJarMetaData parseEjbJarXml(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile alternateDescriptor = (VirtualFile)deploymentRoot.getAttachment(org.jboss.as.ee.structure.Attachments.ALTERNATE_EJB_DEPLOYMENT_DESCRIPTOR);
        VirtualFile descriptor = alternateDescriptor != null ? alternateDescriptor : EjbJarParsingDeploymentUnitProcessor.getDescriptor(deploymentRoot.getRoot(), EJB_JAR_XML);
        if (descriptor == null) {
            return null;
        }
        MetaDataElementParser.DTDInfo dtdInfo = new MetaDataElementParser.DTDInfo();
        InputStream stream = EjbJarParsingDeploymentUnitProcessor.open(descriptor);
        try {
            EjbJarMetaData ejbJarMetaData;
            XMLStreamReader reader = EjbJarParsingDeploymentUnitProcessor.getXMLStreamReader(stream, descriptor, (XMLResolver)dtdInfo);
            EjbJarMetaData ejbJarMetaData2 = ejbJarMetaData = EjbJarMetaDataParser.parse((XMLStreamReader)reader, (MetaDataElementParser.DTDInfo)dtdInfo, (PropertyReplacer)SpecDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit));
            return ejbJarMetaData2;
        }
        catch (XMLStreamException xmlse) {
            throw EjbLogger.ROOT_LOGGER.failedToParse(xmlse, "ejb-jar.xml: " + descriptor.getPathName());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                EjbLogger.DEPLOYMENT_LOGGER.failToCloseFile(ioe);
            }
        }
    }

    private static EjbJarMetaData parseJBossEjb3Xml(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        VirtualFile descriptor = EjbJarParsingDeploymentUnitProcessor.getDescriptor(deploymentRoot, JBOSS_EJB3_XML);
        if (descriptor == null) {
            return (EjbJarMetaData)deploymentUnit.getAttachment(EjbJarJBossAllParser.ATTACHMENT_KEY);
        }
        MetaDataElementParser.DTDInfo dtdInfo = new MetaDataElementParser.DTDInfo();
        InputStream stream = EjbJarParsingDeploymentUnitProcessor.open(descriptor);
        try {
            EjbJarMetaData ejbJarMetaData;
            XMLStreamReader reader = EjbJarParsingDeploymentUnitProcessor.getXMLStreamReader(stream, descriptor, (XMLResolver)dtdInfo);
            JBossEjb3MetaDataParser parser = new JBossEjb3MetaDataParser(EjbJarParsingDeploymentUnitProcessor.createJbossEjbJarParsers());
            EjbJarMetaData ejbJarMetaData2 = ejbJarMetaData = parser.parse(reader, dtdInfo, JBossDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit));
            return ejbJarMetaData2;
        }
        catch (XMLStreamException xmlse) {
            throw EjbLogger.ROOT_LOGGER.failedToParse(xmlse, "jboss-ejb3.xml: " + descriptor.getPathName());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                EjbLogger.DEPLOYMENT_LOGGER.failToCloseFile(ioe);
            }
        }
    }

    static Map<String, AbstractMetaDataParser<?>> createJbossEjbJarParsers() {
        HashMap parsers = new HashMap();
        parsers.put("urn:clustering:1.0", (AbstractMetaDataParser<?>)new EJBBoundClusteringMetaDataParser());
        parsers.put("urn:security", (AbstractMetaDataParser<?>)EJBBoundSecurityMetaDataParser.INSTANCE);
        parsers.put("urn:security:1.0", (AbstractMetaDataParser<?>)EJBBoundSecurityMetaDataParser.INSTANCE);
        parsers.put("urn:security:1.1", (AbstractMetaDataParser<?>)EJBBoundSecurityMetaDataParser11.INSTANCE);
        parsers.put("urn:security-role", SecurityRoleMetaDataParser.INSTANCE);
        parsers.put("urn:security-role:1.0", SecurityRoleMetaDataParser.INSTANCE);
        parsers.put("urn:resource-adapter-binding", (AbstractMetaDataParser<?>)EJBBoundResourceAdapterBindingMetaDataParser.INSTANCE);
        parsers.put("urn:resource-adapter-binding:1.0", (AbstractMetaDataParser<?>)EJBBoundResourceAdapterBindingMetaDataParser.INSTANCE);
        parsers.put("urn:delivery-active:1.0", (AbstractMetaDataParser<?>)EJBBoundDeliveryActiveMetaDataParser.INSTANCE);
        parsers.put("urn:iiop", (AbstractMetaDataParser<?>)new IIOPMetaDataParser());
        parsers.put("urn:iiop:1.0", (AbstractMetaDataParser<?>)new IIOPMetaDataParser());
        parsers.put("urn:trans-timeout", (AbstractMetaDataParser<?>)new TransactionTimeoutMetaDataParser());
        parsers.put("urn:trans-timeout:1.0", (AbstractMetaDataParser<?>)new TransactionTimeoutMetaDataParser());
        parsers.put("urn:ejb-pool:1.0", (AbstractMetaDataParser<?>)new EJBBoundPoolParser());
        parsers.put("urn:ejb-cache:1.0", (AbstractMetaDataParser<?>)new EJBBoundCacheParser());
        parsers.put("urn:container-interceptors:1.0", ContainerInterceptorsParser.INSTANCE);
        parsers.put("urn:timer-service:1.0", (AbstractMetaDataParser<?>)TimerServiceMetaDataParser.INSTANCE);
        return parsers;
    }
}

