/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporterImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.XATerminatorImple;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.ats.jta.recovery.SerializableXAResourceDeserializer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.XATerminator;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBXAResourceDeserializer;
import org.jboss.ejb.client.UserTransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class EJBRemoteTransactionsRepository
implements Service<EJBRemoteTransactionsRepository> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb"}).append(new String[]{"remote-transactions-repository"});
    private final InjectedValue<TransactionManager> transactionManagerInjectedValue = new InjectedValue();
    private final InjectedValue<UserTransaction> userTransactionInjectedValue = new InjectedValue();
    private final InjectedValue<RecoveryManagerService> recoveryManagerService = new InjectedValue();
    private final Map<UserTransactionID, Uid> userTransactions = Collections.synchronizedMap(new HashMap());

    public void start(StartContext context) throws StartException {
        ((RecoveryManagerService)this.recoveryManagerService.getValue()).addSerializableXAResourceDeserializer((SerializableXAResourceDeserializer)EJBXAResourceDeserializer.INSTANCE);
        EjbLogger.REMOTE_LOGGER.debugf("Registered EJB XA resource deserializer %s", EJBXAResourceDeserializer.INSTANCE);
    }

    public void stop(StopContext context) {
    }

    public EJBRemoteTransactionsRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public TransactionManager getTransactionManager() {
        return (TransactionManager)this.transactionManagerInjectedValue.getValue();
    }

    public Transaction removeUserTransaction(UserTransactionID userTransactionID) {
        Uid uid = this.userTransactions.remove(userTransactionID);
        if (uid == null) {
            return null;
        }
        return TransactionImple.getTransaction((Uid)uid);
    }

    public Transaction getUserTransaction(UserTransactionID userTransactionID) {
        Uid uid = this.userTransactions.get(userTransactionID);
        if (uid == null) {
            return null;
        }
        return TransactionImple.getTransaction((Uid)uid);
    }

    Transaction beginUserTransaction(UserTransactionID userTransactionID) throws SystemException, NotSupportedException {
        this.getUserTransaction().begin();
        TransactionImple newlyAssociatedTx = TransactionImple.getTransaction();
        Uid uid = newlyAssociatedTx.get_uid();
        this.userTransactions.put(userTransactionID, uid);
        return newlyAssociatedTx;
    }

    public SubordinateTransaction getImportedTransaction(XidTransactionID xidTransactionID) throws XAException {
        Xid xid = xidTransactionID.getXid();
        TransactionImporter transactionImporter = SubordinationManager.getTransactionImporter();
        return transactionImporter.getImportedTransaction(xid);
    }

    Transaction importTransaction(XidTransactionID xidTransactionID, int txTimeout) throws XAException {
        TransactionImporter transactionImporter = SubordinationManager.getTransactionImporter();
        return transactionImporter.importTransaction(xidTransactionID.getXid(), txTimeout);
    }

    public Xid[] getXidsToRecoverForParentNode(String parentNodeName, int recoveryFlags) throws XAException {
        XATerminator xaTerminator;
        Set inFlightXids;
        HashSet<Xid> xidsToRecover = new HashSet<Xid>();
        TransactionImporter transactionImporter = SubordinationManager.getTransactionImporter();
        if (transactionImporter instanceof TransactionImporterImple && (inFlightXids = ((TransactionImporterImple)transactionImporter).getInflightXids(parentNodeName)) != null) {
            xidsToRecover.addAll(inFlightXids);
        }
        if ((xaTerminator = SubordinationManager.getXATerminator()) instanceof XATerminatorImple) {
            Xid[] inDoubtTransactions = ((XATerminatorImple)xaTerminator).doRecover(null, parentNodeName);
            if (inDoubtTransactions != null) {
                xidsToRecover.addAll(Arrays.asList(inDoubtTransactions));
            }
        } else {
            Xid[] inDoubtTransactions = xaTerminator.recover(recoveryFlags);
            if (inDoubtTransactions != null) {
                xidsToRecover.addAll(Arrays.asList(inDoubtTransactions));
            }
        }
        return xidsToRecover.toArray(new Xid[0]);
    }

    public UserTransaction getUserTransaction() {
        return (UserTransaction)this.userTransactionInjectedValue.getValue();
    }

    public Injector<TransactionManager> getTransactionManagerInjector() {
        return this.transactionManagerInjectedValue;
    }

    public Injector<UserTransaction> getUserTransactionInjector() {
        return this.userTransactionInjectedValue;
    }

    public Injector<RecoveryManagerService> getRecoveryManagerInjector() {
        return this.recoveryManagerService;
    }
}

