/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.spi.impl;

import java.io.Serializable;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntry;

public abstract class AbstractBackingCacheEntry<K extends Serializable, V extends Cacheable<K>>
implements BackingCacheEntry<K, V> {
    private static final long serialVersionUID = 4562025672441864736L;
    private volatile long lastUsed = System.currentTimeMillis();
    private volatile transient int usageCount;
    private volatile boolean prePassivated;
    private volatile transient boolean invalid;

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public boolean isInUse() {
        return this.usageCount > 0;
    }

    @Override
    public synchronized void increaseUsageCount() {
        ++this.usageCount;
        this.setLastUsed(System.currentTimeMillis());
    }

    @Override
    public synchronized void decreaseUsageCount() {
        --this.usageCount;
        this.setLastUsed(System.currentTimeMillis());
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    @Override
    public boolean isPrePassivated() {
        return this.prePassivated;
    }

    @Override
    public void setPrePassivated(boolean prePassivated) {
        this.prePassivated = prePassivated;
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }

    @Override
    public boolean isValid() {
        return !this.invalid;
    }

    public int hashCode() {
        return ((Serializable)this.getId()).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BackingCacheEntry)) {
            return false;
        }
        BackingCacheEntry entry = (BackingCacheEntry)object;
        return ((Serializable)this.getId()).equals(entry.getId());
    }

    @Override
    public int compareTo(BackingCacheEntry<K, V> entry) {
        return Long.valueOf(this.lastUsed).compareTo(entry.getLastUsed());
    }
}

