/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.registry.RegistryEntryProvider;

public class EJBRemotingConnectorClientMappingsEntryProviderService
implements Service<RegistryEntryProvider<String, List<ClientMapping>>> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb"}).append(new String[]{"remoting"}).append(new String[]{"connector"}).append(new String[]{"client-mapping-entry-provider-service"});
    private final RegistryEntryProvider<String, List<ClientMapping>> registryEntryProvider = new ClientMappingEntryProvider();
    private final InjectedValue<ServerEnvironment> serverEnvironment = new InjectedValue();
    private final InjectedValue<RemotingConnectorBindingInfoService.RemotingConnectorInfo> remotingConnectorInfo = new InjectedValue();

    public void start(StartContext context) {
    }

    public void stop(StopContext context) {
    }

    public RegistryEntryProvider<String, List<ClientMapping>> getValue() {
        return this.registryEntryProvider;
    }

    public Injector<ServerEnvironment> getServerEnvironmentInjector() {
        return this.serverEnvironment;
    }

    public Injector<RemotingConnectorBindingInfoService.RemotingConnectorInfo> getRemotingConnectorInfoInjector() {
        return this.remotingConnectorInfo;
    }

    List<ClientMapping> getClientMappings() {
        ArrayList<ClientMapping> ret = new ArrayList<ClientMapping>();
        RemotingConnectorBindingInfoService.RemotingConnectorInfo info = (RemotingConnectorBindingInfoService.RemotingConnectorInfo)this.remotingConnectorInfo.getValue();
        if (info.getSocketBinding().getClientMappings() != null && !info.getSocketBinding().getClientMappings().isEmpty()) {
            ret.addAll(info.getSocketBinding().getClientMappings());
        } else {
            InetAddress clientNetworkAddress;
            String destinationAddress = info.getSocketBinding().getAddress().getHostAddress();
            try {
                clientNetworkAddress = InetAddress.getByName("::");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            ClientMapping defaultClientMapping = new ClientMapping(clientNetworkAddress, 0, destinationAddress, info.getSocketBinding().getAbsolutePort());
            ret.add(defaultClientMapping);
        }
        return ret;
    }

    String getNodeName() {
        return ((ServerEnvironment)this.serverEnvironment.getValue()).getNodeName();
    }

    class ClientMappingEntryProvider
    implements RegistryEntryProvider<String, List<ClientMapping>> {
        ClientMappingEntryProvider() {
        }

        public String getKey() {
            return EJBRemotingConnectorClientMappingsEntryProviderService.this.getNodeName();
        }

        public List<ClientMapping> getValue() {
            return EJBRemotingConnectorClientMappingsEntryProviderService.this.getClientMappings();
        }
    }
}

