/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.distributable;

import java.util.UUID;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.distributable.BatchStack;
import org.jboss.as.ejb3.cache.distributable.RemoveListenerAdapter;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.NodeAffinity;
import org.wildfly.clustering.ejb.Batch;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.RemoveListener;

public class DistributableCache<K, V extends Identifiable<K>>
implements Cache<K, V> {
    private final BeanManager<UUID, K, V> manager;
    private final StatefulObjectFactory<V> factory;
    private final RemoveListener<V> listener;
    private final ServerEnvironment environment;

    public DistributableCache(BeanManager<UUID, K, V> manager, StatefulObjectFactory<V> factory, ServerEnvironment environment) {
        this.manager = manager;
        this.factory = factory;
        this.listener = new RemoveListenerAdapter(factory);
        this.environment = environment;
    }

    public Affinity getStrictAffinity() {
        Affinity affinity = this.manager.getStrictAffinity();
        return affinity != null ? affinity : new NodeAffinity(this.environment.getNodeName());
    }

    public Affinity getWeakAffinity(K id) {
        return this.manager.getWeakAffinity(id);
    }

    public K createIdentifier() {
        return (K)this.manager.getBeanIdentifierFactory().createIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V create() {
        boolean newGroup = false;
        boolean success = false;
        UUID group = (UUID)CURRENT_GROUP.get();
        Batch batch = this.manager.getBatcher().startBatch();
        try {
            Identifiable identifiable;
            block10: {
                if (group == null) {
                    newGroup = true;
                    group = (UUID)this.manager.getGroupIdentifierFactory().createIdentifier();
                    CURRENT_GROUP.set(group);
                }
                try {
                    Identifiable instance = (Identifiable)this.factory.createInstance();
                    Object id = instance.getId();
                    this.manager.createBean(id, (Object)group, (Object)instance).close();
                    success = true;
                    identifiable = instance;
                    if (!newGroup) break block10;
                    CURRENT_GROUP.remove();
                }
                catch (Throwable throwable) {
                    if (newGroup) {
                        CURRENT_GROUP.remove();
                    }
                    throw throwable;
                }
            }
            return (V)identifiable;
        }
        finally {
            if (success) {
                batch.close();
            } else {
                batch.discard();
            }
        }
    }

    @Override
    public V get(K id) {
        BatchStack.pushBatch(this.manager.getBatcher().startBatch());
        try {
            Bean bean = this.manager.findBean(id);
            if (bean == null) {
                BatchStack.popBatch().close();
                return null;
            }
            return (V)((Identifiable)bean.acquire());
        }
        catch (Error | RuntimeException e) {
            BatchStack.popBatch().discard();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(V value) {
        Object id = value.getId();
        try {
            Bean bean = this.manager.findBean(id);
            if (bean != null && bean.release()) {
                bean.close();
            }
        }
        finally {
            BatchStack.popBatch().close();
        }
    }

    @Override
    public void remove(K id) {
        Bean bean = this.manager.findBean(id);
        if (bean != null) {
            bean.remove(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard(K id) {
        try {
            Bean bean = this.manager.findBean(id);
            if (bean != null) {
                bean.remove(null);
            }
        }
        finally {
            BatchStack.popBatch().close();
        }
    }

    @Override
    public boolean contains(K id) {
        return this.manager.containsBean(id);
    }

    @Override
    public void start() {
        this.manager.start();
    }

    @Override
    public void stop() {
        this.manager.stop();
    }

    @Override
    public int getCacheSize() {
        return this.manager.getActiveCount();
    }

    @Override
    public int getPassivatedCount() {
        return this.manager.getPassiveCount();
    }

    @Override
    public int getTotalSize() {
        return this.manager.getActiveCount() + this.manager.getPassiveCount();
    }
}

