/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.security.AccessController;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;

public class TimerHandleImpl
implements TimerHandle {
    private static final long serialVersionUID = 1L;
    private final String timedObjectId;
    private final String serviceName;
    private final String id;
    private transient TimerServiceImpl service;

    public TimerHandleImpl(String id, String timedObjectId, TimerServiceImpl service) throws IllegalArgumentException {
        if (id == null) {
            throw EjbMessages.MESSAGES.idIsNull();
        }
        if (timedObjectId == null) {
            throw EjbMessages.MESSAGES.timedObjectNull();
        }
        if (service == null) {
            throw EjbMessages.MESSAGES.timerServiceIsNull();
        }
        this.timedObjectId = timedObjectId;
        this.id = id;
        this.service = service;
        this.serviceName = service.getServiceName().getCanonicalName();
    }

    public Timer getTimer() throws IllegalStateException, EJBException {
        TimerImpl timer;
        if (this.service == null) {
            this.service = (TimerServiceImpl)TimerHandleImpl.currentServiceContainer().getRequiredService(ServiceName.parse((String)this.serviceName)).getValue();
            if (this.service == null) {
                throw EjbMessages.MESSAGES.timerServiceWithIdNotRegistered(this.timedObjectId);
            }
        }
        if ((timer = this.service.getTimer(this)) == null || !timer.isActive()) {
            throw EjbMessages.MESSAGES.timerHandleIsNotActive(this);
        }
        return timer;
    }

    public String getId() {
        return this.id;
    }

    public String getTimedObjectId() {
        return this.timedObjectId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimerHandleImpl)) {
            return false;
        }
        TimerHandleImpl other = (TimerHandleImpl)obj;
        if (this == other) {
            return true;
        }
        return this.id.equals(other.id) && this.timedObjectId.equals(other.timedObjectId);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }
}

