/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.ejb.ScheduleExpression;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.timerservice.schedule.attribute.DayOfMonth;
import org.jboss.as.ejb3.timerservice.schedule.attribute.DayOfWeek;
import org.jboss.as.ejb3.timerservice.schedule.attribute.Hour;
import org.jboss.as.ejb3.timerservice.schedule.attribute.Minute;
import org.jboss.as.ejb3.timerservice.schedule.attribute.Month;
import org.jboss.as.ejb3.timerservice.schedule.attribute.Second;
import org.jboss.as.ejb3.timerservice.schedule.attribute.Year;

public class CalendarBasedTimeout {
    private ScheduleExpression scheduleExpression;
    private Second second;
    private Minute minute;
    private Hour hour;
    private DayOfWeek dayOfWeek;
    private DayOfMonth dayOfMonth;
    private Month month;
    private Year year;
    private Calendar firstTimeout;
    private TimeZone timezone;

    public CalendarBasedTimeout(ScheduleExpression schedule) {
        if (schedule == null) {
            throw EjbMessages.MESSAGES.invalidScheduleExpression(this.getClass().getName());
        }
        this.nullCheckScheduleAttributes(schedule);
        this.scheduleExpression = this.clone(schedule);
        this.second = new Second(schedule.getSecond());
        this.minute = new Minute(schedule.getMinute());
        this.hour = new Hour(schedule.getHour());
        this.dayOfWeek = new DayOfWeek(schedule.getDayOfWeek());
        this.dayOfMonth = new DayOfMonth(schedule.getDayOfMonth());
        this.month = new Month(schedule.getMonth());
        this.year = new Year(schedule.getYear());
        if (schedule.getTimezone() != null && !schedule.getTimezone().trim().isEmpty()) {
            String timezoneId = schedule.getTimezone();
            String[] availableTimeZoneIDs = TimeZone.getAvailableIDs();
            if (availableTimeZoneIDs != null && Arrays.asList(availableTimeZoneIDs).contains(timezoneId)) {
                this.timezone = TimeZone.getTimeZone(timezoneId);
            } else {
                EjbLogger.ROOT_LOGGER.unknownTimezoneId(timezoneId, TimeZone.getDefault().getID());
                this.timezone = TimeZone.getDefault();
            }
        } else {
            this.timezone = TimeZone.getDefault();
        }
        this.setFirstTimeout();
    }

    public Calendar getNextTimeout() {
        GregorianCalendar now = new GregorianCalendar(this.timezone);
        now.setTime(new Date());
        return this.getNextTimeout(now);
    }

    public Calendar getFirstTimeout() {
        return this.firstTimeout;
    }

    private void setFirstTimeout() {
        this.firstTimeout = new GregorianCalendar(this.timezone);
        Date start = this.scheduleExpression.getStart();
        if (start != null) {
            this.firstTimeout.setTime(start);
        } else {
            this.firstTimeout.set(13, this.second.getFirst());
            this.firstTimeout.set(12, this.minute.getFirst());
            this.firstTimeout.set(11, this.hour.getFirst());
            this.firstTimeout.set(14, 0);
        }
        this.firstTimeout.setFirstDayOfWeek(1);
        this.firstTimeout = this.computeNextSecond(this.firstTimeout);
        if (this.firstTimeout == null) {
            return;
        }
        this.firstTimeout = this.computeNextMinute(this.firstTimeout);
        if (this.firstTimeout == null) {
            return;
        }
        this.firstTimeout = this.computeNextHour(this.firstTimeout);
        if (this.firstTimeout == null) {
            return;
        }
        this.firstTimeout = this.computeNextMonth(this.firstTimeout);
        if (this.firstTimeout == null) {
            return;
        }
        this.firstTimeout = this.computeNextDate(this.firstTimeout);
        if (this.firstTimeout == null) {
            return;
        }
        this.firstTimeout = this.computeNextYear(this.firstTimeout);
        if (this.firstTimeout != null && this.noMoreTimeouts(this.firstTimeout)) {
            this.firstTimeout = null;
        }
    }

    public ScheduleExpression getScheduleExpression() {
        return this.scheduleExpression;
    }

    public Calendar getNextTimeout(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Calendar nextCal = this.copy(currentCal);
        nextCal.setTimeZone(this.timezone);
        Date start = this.scheduleExpression.getStart();
        if (start != null && currentCal.getTime().before(start)) {
            nextCal.setTime(start);
        } else {
            nextCal.add(13, 1);
            nextCal.set(14, 0);
        }
        nextCal.setFirstDayOfWeek(1);
        nextCal = this.computeNextSecond(nextCal);
        if (nextCal == null) {
            return null;
        }
        if ((nextCal = this.computeNextMinute(nextCal)) == null) {
            return null;
        }
        if ((nextCal = this.computeNextHour(nextCal)) == null) {
            return null;
        }
        if ((nextCal = this.computeNextMonth(nextCal)) == null) {
            return null;
        }
        if ((nextCal = this.computeNextDate(nextCal)) == null) {
            return null;
        }
        if ((nextCal = this.computeNextYear(nextCal)) == null) {
            return null;
        }
        if (this.noMoreTimeouts(nextCal)) {
            return null;
        }
        return nextCal;
    }

    private Calendar computeNextSecond(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextSecond = this.second.getNextMatch(currentCal);
        if (nextSecond == null) {
            return null;
        }
        int currentSecond = currentCal.get(13);
        if (currentSecond == nextSecond) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextSecond > currentSecond) {
            nextCal.set(13, nextSecond);
            return nextCal;
        }
        if (nextSecond < currentSecond) {
            nextCal.set(13, nextSecond);
            nextCal.add(12, 1);
            return nextCal;
        }
        return null;
    }

    private Calendar computeNextMinute(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextMinute = this.minute.getNextMatch(currentCal);
        if (nextMinute == null) {
            return null;
        }
        int currentMinute = currentCal.get(12);
        if (currentMinute == nextMinute) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextMinute > currentMinute) {
            nextCal.set(12, nextMinute);
            nextCal.set(13, this.second.getFirst());
            return nextCal;
        }
        if (nextMinute < currentMinute) {
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, nextMinute);
            nextCal.add(11, 1);
            return nextCal;
        }
        return null;
    }

    private Calendar computeNextHour(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextHour = this.hour.getNextMatch(currentCal);
        if (nextHour == null) {
            return null;
        }
        int currentHour = currentCal.get(11);
        if (currentHour == nextHour) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextHour > currentHour) {
            nextCal.set(11, nextHour);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            return nextCal;
        }
        if (nextHour < currentHour) {
            nextCal.set(11, nextHour);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            nextCal.add(5, 1);
            return nextCal;
        }
        return null;
    }

    private Calendar computeNextDayOfWeek(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextDayOfWeek = this.dayOfWeek.getNextMatch(currentCal);
        if (nextDayOfWeek == null) {
            return null;
        }
        int currentDayOfWeek = currentCal.get(7);
        if (currentDayOfWeek == nextDayOfWeek) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextDayOfWeek > currentDayOfWeek) {
            int dayDiff = nextDayOfWeek - currentDayOfWeek;
            nextCal.add(5, dayDiff);
        } else {
            nextCal.set(7, nextDayOfWeek);
            nextCal.add(4, 1);
        }
        nextCal.set(13, this.second.getFirst());
        nextCal.set(12, this.minute.getFirst());
        nextCal.set(11, this.hour.getFirst());
        if (nextCal.get(2) != currentCal.get(2)) {
            nextCal = this.computeNextMonth(nextCal);
        }
        return nextCal;
    }

    private Calendar computeNextMonth(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextMonth = this.month.getNextMatch(currentCal);
        if (nextMonth == null) {
            return null;
        }
        int currentMonth = currentCal.get(2);
        if (currentMonth == nextMonth) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextMonth > currentMonth) {
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            nextCal.set(11, this.hour.getFirst());
            nextCal.set(7, this.dayOfWeek.getFirst());
            nextCal.set(5, 1);
            nextCal.set(2, nextMonth);
            return nextCal;
        }
        if (nextMonth < currentMonth) {
            nextCal.set(2, nextMonth);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            nextCal.set(11, this.hour.getFirst());
            nextCal.set(7, this.dayOfWeek.getFirst());
            nextCal.set(5, 1);
            nextCal.add(1, 1);
            return nextCal;
        }
        return null;
    }

    private Calendar computeNextDate(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        if (this.isDayOfMonthWildcard()) {
            return this.computeNextDayOfWeek(currentCal);
        }
        if (this.isDayOfWeekWildcard()) {
            return this.computeNextDayOfMonth(currentCal);
        }
        Calendar nextDayOfMonthCal = this.computeNextDayOfMonth(currentCal);
        Calendar nextDayOfWeekCal = this.computeNextDayOfWeek(currentCal);
        if (nextDayOfMonthCal == null) {
            return nextDayOfWeekCal;
        }
        if (nextDayOfWeekCal == null) {
            return nextDayOfMonthCal;
        }
        return nextDayOfWeekCal.getTime().before(nextDayOfMonthCal.getTime()) ? nextDayOfWeekCal : nextDayOfMonthCal;
    }

    private Calendar computeNextDayOfMonth(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextDayOfMonth = this.dayOfMonth.getNextMatch(currentCal);
        if (nextDayOfMonth == null) {
            return null;
        }
        int currentDayOfMonth = currentCal.get(5);
        if (currentDayOfMonth == nextDayOfMonth) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextDayOfMonth > currentDayOfMonth) {
            if (this.monthHasDate(nextCal, nextDayOfMonth)) {
                nextCal.set(5, nextDayOfMonth);
                nextCal.set(13, this.second.getFirst());
                nextCal.set(12, this.minute.getFirst());
                nextCal.set(11, this.hour.getFirst());
            } else {
                nextCal = this.advanceTillMonthHasDate(nextCal, nextDayOfMonth);
            }
        } else if (nextDayOfMonth < currentDayOfMonth) {
            nextCal.add(2, 1);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            nextCal.set(11, this.hour.getFirst());
            nextCal = this.computeNextMonth(nextCal);
            if (nextCal == null) {
                return null;
            }
            nextDayOfMonth = this.dayOfMonth.getFirstMatch(nextCal);
            if (nextDayOfMonth == null) {
                return null;
            }
            nextCal = this.advanceTillMonthHasDate(nextCal, nextDayOfMonth);
        }
        return nextCal;
    }

    private Calendar computeNextYear(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextYear = this.year.getNextMatch(currentCal);
        if (nextYear == null || nextYear > Year.MAX_YEAR) {
            return null;
        }
        int currentYear = currentCal.get(1);
        if (currentYear == nextYear) {
            return currentCal;
        }
        if (nextYear < currentYear) {
            return null;
        }
        Calendar nextCal = this.copy(currentCal);
        nextCal.set(1, nextYear);
        nextCal.set(13, this.second.getFirst());
        nextCal.set(12, this.minute.getFirst());
        nextCal.set(11, this.hour.getFirst());
        nextCal.set(2, this.month.getFirstMatch());
        nextCal.set(5, 1);
        nextCal = this.computeNextDate(nextCal);
        if (nextCal == null) {
            return null;
        }
        return nextCal;
    }

    private Calendar advanceTillMonthHasDate(Calendar cal, Integer date) {
        Calendar copy = this.copy(cal);
        while (!this.monthHasDate(copy, date)) {
            if (copy.get(1) > Year.MAX_YEAR) {
                return null;
            }
            copy.add(2, 1);
            copy = this.computeNextMonth(copy);
            if (copy == null) {
                return null;
            }
            date = this.dayOfMonth.getFirstMatch(copy);
            if (date == null) {
                return null;
            }
            copy.set(13, this.second.getFirst());
            copy.set(12, this.minute.getFirst());
            copy.set(11, this.hour.getFirst());
        }
        copy.set(5, date);
        return copy;
    }

    private Calendar copy(Calendar cal) {
        GregorianCalendar copy = new GregorianCalendar(cal.getTimeZone());
        copy.setTime(cal.getTime());
        return copy;
    }

    private boolean monthHasDate(Calendar cal, int date) {
        GregorianCalendar tmpCal = new GregorianCalendar(cal.getTimeZone());
        tmpCal.set(1, cal.get(1));
        tmpCal.set(2, cal.get(2));
        tmpCal.set(5, 1);
        int maximumPossibleDateForTheMonth = ((Calendar)tmpCal).getActualMaximum(5);
        return date <= maximumPossibleDateForTheMonth;
    }

    private boolean isAfterEnd(Calendar cal) {
        Date end = this.scheduleExpression.getEnd();
        if (end == null) {
            return false;
        }
        return cal.getTime().after(end);
    }

    private boolean noMoreTimeouts(Calendar cal) {
        return cal.get(1) > Year.MAX_YEAR || this.isAfterEnd(cal);
    }

    private boolean isDayOfWeekWildcard() {
        return this.scheduleExpression.getDayOfWeek().equals("*");
    }

    private boolean isDayOfMonthWildcard() {
        return this.scheduleExpression.getDayOfMonth().equals("*");
    }

    private void nullCheckScheduleAttributes(ScheduleExpression schedule) {
        if (schedule.getSecond() == null) {
            throw EjbMessages.MESSAGES.invalidScheduleExpressionSecond(schedule);
        }
        if (schedule.getMinute() == null) {
            throw EjbMessages.MESSAGES.invalidScheduleExpressionMinute(schedule);
        }
        if (schedule.getHour() == null) {
            throw EjbMessages.MESSAGES.invalidScheduleExpressionHour(schedule);
        }
        if (schedule.getDayOfMonth() == null) {
            throw EjbMessages.MESSAGES.invalidScheduleExpressionDayOfMonth(schedule);
        }
        if (schedule.getDayOfWeek() == null) {
            throw EjbMessages.MESSAGES.invalidScheduleExpressionDayOfWeek(schedule);
        }
        if (schedule.getMonth() == null) {
            throw EjbMessages.MESSAGES.invalidScheduleExpressionMonth(schedule);
        }
        if (schedule.getYear() == null) {
            throw EjbMessages.MESSAGES.invalidScheduleExpressionYear(schedule);
        }
    }

    private ScheduleExpression clone(ScheduleExpression schedule) {
        ScheduleExpression clonedSchedule = new ScheduleExpression();
        clonedSchedule.second(schedule.getSecond());
        clonedSchedule.minute(schedule.getMinute());
        clonedSchedule.hour(schedule.getHour());
        clonedSchedule.dayOfWeek(schedule.getDayOfWeek());
        clonedSchedule.dayOfMonth(schedule.getDayOfMonth());
        clonedSchedule.month(schedule.getMonth());
        clonedSchedule.year(schedule.getYear());
        clonedSchedule.timezone(schedule.getTimezone());
        clonedSchedule.start(schedule.getStart());
        clonedSchedule.end(schedule.getEnd());
        return clonedSchedule;
    }
}

