/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.Permission;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.List;
import java.util.PropertyPermission;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.security.ImmediatePermissionFactory;

public final class EJBDefaultPermissionsProcessor
implements DeploymentUnitProcessor {
    private static final Permissions DEFAULT_PERMISSIONS;
    private volatile boolean enabled;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ModuleSpecification attachment = (ModuleSpecification)phaseContext.getDeploymentUnit().getAttachment(Attachments.MODULE_SPECIFICATION);
        if (attachment == null) {
            return;
        }
        if (!this.enabled) {
            return;
        }
        if (!EjbDeploymentMarker.isEjbDeployment((DeploymentUnit)phaseContext.getDeploymentUnit())) {
            return;
        }
        List permissions = attachment.getPermissionFactories();
        Enumeration<Permission> e = DEFAULT_PERMISSIONS.elements();
        while (e.hasMoreElements()) {
            permissions.add(new ImmediatePermissionFactory(e.nextElement()));
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    static {
        Permissions permissions = new Permissions();
        permissions.add(new PropertyPermission("*", "read"));
        permissions.add(new RuntimePermission("queuePrintJob"));
        permissions.add(new RuntimePermission("loadLibrary"));
        permissions.add(new FilePermission("*", "read"));
        permissions.add(new FilePermission("*", "write"));
        permissions.add(new SocketPermission("*", "connect"));
        DEFAULT_PERMISSIONS = permissions;
    }
}

