/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.RemotingOptions;

public class ChannelAssociation {
    private final Channel channel;
    private static final int DEFAULT_MAX_OUTBOUND_MESSAGES = 80;
    private final Semaphore channelWriteSemaphore;

    public ChannelAssociation(Channel channel) {
        this.channel = channel;
        Integer maxOutboundWrites = (Integer)this.channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES);
        if (maxOutboundWrites == null) {
            maxOutboundWrites = 80;
        }
        this.channelWriteSemaphore = new Semaphore(maxOutboundWrites, true);
    }

    public MessageOutputStream acquireChannelMessageOutputStream() throws Exception {
        this.channelWriteSemaphore.acquire();
        try {
            return this.channel.writeMessage();
        }
        catch (Exception e) {
            this.channelWriteSemaphore.release();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseChannelMessageOutputStream(MessageOutputStream messageOutputStream) throws IOException {
        try {
            messageOutputStream.close();
        }
        finally {
            this.channelWriteSemaphore.release();
        }
    }

    public Channel getChannel() {
        return this.channel;
    }
}

