/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.concurrency;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.ejb.LockType;
import javax.interceptor.InvocationContext;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.concurrency.EJBReadWriteLock;
import org.jboss.as.ejb3.concurrency.LockableComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;

public class ContainerManagedConcurrencyInterceptor
implements Interceptor {
    private static final Logger logger = Logger.getLogger(ContainerManagedConcurrencyInterceptor.class);
    private final ReadWriteLock readWriteLock = new EJBReadWriteLock();
    private final LockableComponent lockableComponent;

    public ContainerManagedConcurrencyInterceptor(LockableComponent component) {
        if (component == null) {
            throw EjbLogger.ROOT_LOGGER.componentIsNull(LockableComponent.class.getName());
        }
        this.lockableComponent = component;
    }

    protected LockableComponent getLockableComponent() {
        return this.lockableComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        boolean success;
        InvocationContext invocationContext = context.getInvocationContext();
        LockableComponent lockableComponent = this.getLockableComponent();
        Method invokedMethod = invocationContext.getMethod();
        if (invokedMethod == null) {
            throw EjbLogger.ROOT_LOGGER.invocationNotApplicableForMethodInvocation(invocationContext);
        }
        Lock lock = this.getLock(lockableComponent, invokedMethod);
        AccessTimeoutDetails defaultAccessTimeout = lockableComponent.getDefaultAccessTimeout();
        long time = defaultAccessTimeout.getValue();
        TimeUnit unit = defaultAccessTimeout.getTimeUnit();
        AccessTimeoutDetails accessTimeoutOnMethod = lockableComponent.getAccessTimeout(invokedMethod);
        if (accessTimeoutOnMethod != null) {
            if (accessTimeoutOnMethod.getValue() < 0L) {
                EjbLogger.ROOT_LOGGER.debug("Ignoring a negative @AccessTimeout value: " + accessTimeoutOnMethod.getValue() + " and timeout unit: " + accessTimeoutOnMethod.getTimeUnit().name() + ". Will default to timeout value: " + defaultAccessTimeout.getValue() + " and timeout unit: " + defaultAccessTimeout.getTimeUnit().name());
            } else {
                time = accessTimeoutOnMethod.getValue();
                unit = accessTimeoutOnMethod.getTimeUnit();
            }
        }
        if (!(success = lock.tryLock(time, unit))) {
            throw EjbLogger.ROOT_LOGGER.concurrentAccessTimeoutException(invocationContext, time + unit.name());
        }
        try {
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    private Lock getLock(LockableComponent lockableComponent, Method method) {
        LockType lockType = lockableComponent.getLockType(method);
        switch (lockType) {
            case READ: {
                return this.readWriteLock.readLock();
            }
            case WRITE: {
                return this.readWriteLock.writeLock();
            }
        }
        throw EjbLogger.ROOT_LOGGER.failToObtainLockIllegalType(lockType, method, lockableComponent);
    }
}

