/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.XATerminatorImple;
import java.io.Closeable;
import java.io.IOException;
import javax.resource.spi.XATerminator;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.as.ejb3.remote.protocol.versionone.TransactionRequestHandler;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.marshalling.MarshallerFactory;
import org.xnio.IoUtils;

abstract class XidTransactionManagementTask
implements Runnable {
    protected final short invocationId;
    protected final ChannelAssociation channelAssociation;
    protected final EJBRemoteTransactionsRepository transactionsRepository;
    protected final XidTransactionID xidTransactionID;
    protected final MarshallerFactory marshallerFactory;
    protected final TransactionRequestHandler transactionRequestHandler;

    XidTransactionManagementTask(TransactionRequestHandler txRequestHandler, EJBRemoteTransactionsRepository transactionsRepository, MarshallerFactory marshallerFactory, XidTransactionID xidTransactionID, ChannelAssociation channelAssociation, short invocationId) {
        this.transactionRequestHandler = txRequestHandler;
        this.channelAssociation = channelAssociation;
        this.marshallerFactory = marshallerFactory;
        this.invocationId = invocationId;
        this.transactionsRepository = transactionsRepository;
        this.xidTransactionID = xidTransactionID;
    }

    @Override
    public void run() {
        try {
            this.manageTransaction();
        }
        catch (Throwable t) {
            try {
                EjbLogger.ROOT_LOGGER.errorDuringTransactionManagement(t, this.xidTransactionID);
                this.transactionRequestHandler.writeException(this.channelAssociation, this.marshallerFactory, this.invocationId, t, null);
            }
            catch (IOException e) {
                EjbLogger.ROOT_LOGGER.couldNotWriteOutToChannel(e);
                IoUtils.safeClose((Closeable)this.channelAssociation.getChannel());
            }
            return;
        }
        try {
            this.transactionRequestHandler.writeTxInvocationResponseMessage(this.channelAssociation, this.invocationId);
        }
        catch (IOException e) {
            EjbLogger.ROOT_LOGGER.couldNotWriteInvocationSuccessMessage(e);
            IoUtils.safeClose((Closeable)this.channelAssociation.getChannel());
        }
    }

    protected abstract void manageTransaction() throws Throwable;

    protected void resumeTransaction(Transaction transaction) throws Exception {
        TransactionManager transactionManager = this.transactionsRepository.getTransactionManager();
        transactionManager.resume(transaction);
    }

    protected SubordinateTransaction tryRecoveryForImportedTransaction() throws Exception {
        XATerminator xaTerminator = SubordinationManager.getXATerminator();
        if (xaTerminator instanceof XATerminatorImple) {
            EjbLogger.ROOT_LOGGER.debug("Trying to recover an imported transaction for Xid " + this.xidTransactionID.getXid());
            ((XATerminatorImple)xaTerminator).doRecover(null, null);
        }
        return SubordinationManager.getTransactionImporter().getImportedTransaction(this.xidTransactionID.getXid());
    }
}

