/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBRemoteConnectorService;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.EJB3RemoteServiceAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

class ChannelCreationOptionResource
extends SimpleResourceDefinition {
    static final ChannelCreationOptionResource INSTANCE = new ChannelCreationOptionResource();
    static final SimpleAttributeDefinition CHANNEL_CREATION_OPTION_VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CHANNEL_CREATION_OPTION_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setValidator((ParameterValidator)AllowedChannelOptionTypesValidator.access$000())).build();

    ChannelCreationOptionResource() {
        super(PathElement.pathElement((String)"channel-creation-options"), EJB3Extension.getResourceDescriptionResolver("channel-creation-options"), (OperationStepHandler)new ChannelCreationOptionAdd(), (OperationStepHandler)new ChannelCreationOptionRemove());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CHANNEL_CREATION_OPTION_VALUE, null, (OperationStepHandler)new ChannelCreationOptionWriteAttributeHandler((AttributeDefinition)CHANNEL_CREATION_OPTION_VALUE));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CHANNEL_CREATION_OPTION_TYPE, null, (OperationStepHandler)new ChannelCreationOptionWriteAttributeHandler((AttributeDefinition)CHANNEL_CREATION_OPTION_TYPE));
    }

    private static void recreateParentService(OperationContext context, ModelNode ejb3RemoteServiceModelNode, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        EJB3RemoteServiceAdd.INSTANCE.installRuntimeServices(context, ejb3RemoteServiceModelNode, verificationHandler);
    }

    static void registerTransformers_1_1_0(ResourceTransformationDescriptionBuilder parent) {
        parent.addChildResource(INSTANCE.getPathElement()).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{CHANNEL_CREATION_OPTION_VALUE});
    }

    private static class AllowedChannelOptionTypesValidator
    extends ModelTypeValidator
    implements AllowedValuesValidator {
        private static AllowedChannelOptionTypesValidator INSTANCE = new AllowedChannelOptionTypesValidator();
        private final List<ModelNode> allowedChannelOptTypes = new ArrayList<ModelNode>();

        private AllowedChannelOptionTypesValidator() {
            super(ModelType.STRING, false);
            this.allowedChannelOptTypes.add(new ModelNode().set("remoting"));
            this.allowedChannelOptTypes.add(new ModelNode().set("xnio"));
        }

        public List<ModelNode> getAllowedValues() {
            return this.allowedChannelOptTypes;
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined() && value.getType() != ModelType.EXPRESSION && !this.allowedChannelOptTypes.contains(value)) {
                throw EjbLogger.ROOT_LOGGER.unknownChannelCreationOptionType(value.asString());
            }
        }

        static /* synthetic */ AllowedChannelOptionTypesValidator access$000() {
            return INSTANCE;
        }
    }

    private static class ChannelCreationOptionRemove
    extends RestartParentResourceRemoveHandler {
        private ChannelCreationOptionRemove() {
            super("remote");
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode ejb3RemoteServiceModelNode, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            ChannelCreationOptionResource.recreateParentService(context, ejb3RemoteServiceModelNode, verificationHandler);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return EJBRemoteConnectorService.SERVICE_NAME;
        }
    }

    private static class ChannelCreationOptionAdd
    extends RestartParentResourceAddHandler {
        private ChannelCreationOptionAdd() {
            super("remote");
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            CHANNEL_CREATION_OPTION_VALUE.validateAndSet(operation, model);
            CHANNEL_CREATION_OPTION_TYPE.validateAndSet(operation, model);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            ChannelCreationOptionResource.recreateParentService(context, parentModel, verificationHandler);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return EJBRemoteConnectorService.SERVICE_NAME;
        }
    }

    private static class ChannelCreationOptionWriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        public ChannelCreationOptionWriteAttributeHandler(AttributeDefinition attributeDefinition) {
            super("remote", new AttributeDefinition[]{attributeDefinition});
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            ChannelCreationOptionResource.recreateParentService(context, parentModel, verificationHandler);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return EJBRemoteConnectorService.SERVICE_NAME;
        }
    }
}

