/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBRemoteConnectorService;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.EJBRemotingConnectorClientMappingsEntryProviderService;
import org.jboss.as.ejb3.remote.RegistryCollector;
import org.jboss.as.ejb3.remote.RegistryCollectorService;
import org.jboss.as.ejb3.remote.RegistryInstallerService;
import org.jboss.as.ejb3.remote.RemoteAsyncInvocationCancelStatusService;
import org.jboss.as.ejb3.subsystem.ChannelCreationOptionResource;
import org.jboss.as.ejb3.subsystem.EJB3RemoteResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.as.txn.service.TransactionSynchronizationRegistryService;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.as.txn.service.UserTransactionService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.clustering.spi.LocalServiceInstaller;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class EJB3RemoteServiceAdd
extends AbstractAddStepHandler {
    static final EJB3RemoteServiceAdd INSTANCE = new EJB3RemoteServiceAdd();

    private EJB3RemoteServiceAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        newControllers.addAll(this.installRuntimeServices(context, model, verificationHandler));
        EJBRemoteTransactionsRepository transactionsRepository = new EJBRemoteTransactionsRepository();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceController transactionRepositoryServiceController = serviceTarget.addService(EJBRemoteTransactionsRepository.SERVICE_NAME, (Service)transactionsRepository).addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, transactionsRepository.getTransactionManagerInjector()).addDependency(UserTransactionService.SERVICE_NAME, UserTransaction.class, transactionsRepository.getUserTransactionInjector()).addDependency(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, RecoveryManagerService.class, transactionsRepository.getRecoveryManagerInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        newControllers.add(transactionRepositoryServiceController);
        RemoteAsyncInvocationCancelStatusService asyncInvocationCancelStatusService = new RemoteAsyncInvocationCancelStatusService();
        ServiceController asyncCancelTrackerServiceController = serviceTarget.addService(RemoteAsyncInvocationCancelStatusService.SERVICE_NAME, (Service)asyncInvocationCancelStatusService).install();
        newControllers.add(asyncCancelTrackerServiceController);
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode model, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        String connectorName = EJB3RemoteResourceDefinition.CONNECTOR_REF.resolveModelAttribute(context, model).asString();
        String threadPoolName = EJB3RemoteResourceDefinition.THREAD_POOL_NAME.resolveModelAttribute(context, model).asString();
        ServiceName remotingServerInfoServiceName = RemotingConnectorBindingInfoService.serviceName((String)connectorName);
        ArrayList services = new ArrayList();
        ServiceTarget target = context.getServiceTarget();
        ServiceBuilder clientMappingEntryProviderServiceBuilder = new EJBRemotingConnectorClientMappingsEntryProviderService().build(target, remotingServerInfoServiceName).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (verificationHandler != null) {
            clientMappingEntryProviderServiceBuilder.addListener((ServiceListener)verificationHandler);
        }
        services.add(clientMappingEntryProviderServiceBuilder.install());
        ServiceBuilder registryInstallerBuilder = new RegistryInstallerService().build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (verificationHandler != null) {
            registryInstallerBuilder.addListener((ServiceListener)verificationHandler);
        }
        services.add(registryInstallerBuilder.install());
        Resource rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        PathElement infinispanPath = PathElement.pathElement((String)"subsystem", (String)"infinispan");
        if (!rootResource.hasChild(infinispanPath) || !rootResource.getChild(infinispanPath).hasChild(PathElement.pathElement((String)"cache-container", (String)"ejb"))) {
            ModuleIdentifier moduleId = Module.forClass(((Object)((Object)this)).getClass()).getIdentifier();
            for (LocalServiceInstaller installer : ServiceLoader.load(LocalServiceInstaller.class, LocalServiceInstaller.class.getClassLoader())) {
                installer.install(target, "ejb", moduleId);
            }
        }
        OptionMap channelCreationOptions = this.getChannelCreationOptions(context);
        EJBRemoteConnectorService ejbRemoteConnectorService = new EJBRemoteConnectorService(2, new String[]{"river"}, channelCreationOptions);
        ServiceBuilder ejbRemoteConnectorServiceBuilder = target.addService(EJBRemoteConnectorService.SERVICE_NAME, (Service)ejbRemoteConnectorService);
        ejbRemoteConnectorServiceBuilder.addDependency(RemotingServices.SUBSYSTEM_ENDPOINT, Endpoint.class, ejbRemoteConnectorService.getEndpointInjector());
        ejbRemoteConnectorServiceBuilder.addDependency(EJB3SubsystemModel.BASE_THREAD_POOL_SERVICE_NAME.append(new String[]{threadPoolName}), ExecutorService.class, ejbRemoteConnectorService.getExecutorService()).addDependency(DeploymentRepository.SERVICE_NAME, DeploymentRepository.class, ejbRemoteConnectorService.getDeploymentRepositoryInjector()).addDependency(EJBRemoteTransactionsRepository.SERVICE_NAME, EJBRemoteTransactionsRepository.class, ejbRemoteConnectorService.getEJBRemoteTransactionsRepositoryInjector()).addDependency(RegistryCollectorService.SERVICE_NAME, RegistryCollector.class, ejbRemoteConnectorService.getClusterRegistryCollectorInjector()).addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, ejbRemoteConnectorService.getTransactionManagerInjector()).addDependency(TransactionSynchronizationRegistryService.SERVICE_NAME, TransactionSynchronizationRegistry.class, ejbRemoteConnectorService.getTxSyncRegistryInjector()).addDependency(RemoteAsyncInvocationCancelStatusService.SERVICE_NAME, RemoteAsyncInvocationCancelStatusService.class, ejbRemoteConnectorService.getAsyncInvocationCancelStatusInjector()).addDependency(remotingServerInfoServiceName, RemotingConnectorBindingInfoService.RemotingConnectorInfo.class, ejbRemoteConnectorService.getRemotingConnectorInfoInjectedValue()).setInitialMode(ServiceController.Mode.ACTIVE);
        if (verificationHandler != null) {
            ejbRemoteConnectorServiceBuilder.addListener((ServiceListener)verificationHandler);
        }
        services.add(ejbRemoteConnectorServiceBuilder.install());
        return services;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        EJB3RemoteResourceDefinition.CONNECTOR_REF.validateAndSet(operation, model);
        EJB3RemoteResourceDefinition.THREAD_POOL_NAME.validateAndSet(operation, model);
    }

    private OptionMap getChannelCreationOptions(OperationContext context) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ModelNode channelCreationOptions = fullModel.get("channel-creation-options");
        if (channelCreationOptions.isDefined() && channelCreationOptions.asInt() > 0) {
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            OptionMap.Builder builder = OptionMap.builder();
            for (Property optionProperty : channelCreationOptions.asPropertyList()) {
                String name = optionProperty.getName();
                ModelNode propValueModel = optionProperty.getValue();
                String type = ChannelCreationOptionResource.CHANNEL_CREATION_OPTION_TYPE.resolveModelAttribute(context, propValueModel).asString();
                String optionClassName = this.getClassNameForChannelOptionType(type);
                String fullyQualifiedOptionName = optionClassName + "." + name;
                Option option = Option.fromString((String)fullyQualifiedOptionName, (ClassLoader)loader);
                String value = ChannelCreationOptionResource.CHANNEL_CREATION_OPTION_VALUE.resolveModelAttribute(context, propValueModel).asString();
                builder.set(option, option.parseValue(value, loader));
            }
            return builder.getMap();
        }
        return OptionMap.EMPTY;
    }

    private String getClassNameForChannelOptionType(String optionType) {
        if ("remoting".equals(optionType)) {
            return RemotingOptions.class.getName();
        }
        if ("xnio".equals(optionType)) {
            return Options.class.getName();
        }
        throw EjbLogger.ROOT_LOGGER.unknownChannelCreationOptionType(optionType);
    }
}

