/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import javax.ejb.TransactionAttributeType;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.tx.CMTTxInterceptor;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.proxy.MethodIdentifier;

public class LifecycleCMTTxInterceptor
extends CMTTxInterceptor
implements Interceptor {
    private final TransactionAttributeType transactionAttributeType;
    private final int transactionTimeout;

    public LifecycleCMTTxInterceptor(TransactionAttributeType transactionAttributeType, int transactionTimeout) {
        this.transactionAttributeType = transactionAttributeType;
        this.transactionTimeout = transactionTimeout;
    }

    @Override
    public Object processInvocation(InterceptorContext invocation) throws Exception {
        EJBComponent component = (EJBComponent)((Object)invocation.getPrivateData(Component.class));
        switch (this.transactionAttributeType) {
            case MANDATORY: {
                return this.mandatory(invocation, component);
            }
            case NEVER: {
                return this.never(invocation, component);
            }
            case NOT_SUPPORTED: {
                return this.notSupported(invocation, component);
            }
            case REQUIRED: {
                return this.required(invocation, component, this.transactionTimeout);
            }
            case REQUIRES_NEW: {
                return this.requiresNew(invocation, component, this.transactionTimeout);
            }
            case SUPPORTS: {
                return this.supports(invocation, component);
            }
        }
        throw EjbLogger.ROOT_LOGGER.unknownTxAttributeOnInvocation(this.transactionAttributeType, invocation);
    }

    public static class Factory
    extends ComponentInterceptorFactory {
        private final MethodIdentifier methodIdentifier;
        private final boolean treatRequiredAsRequiresNew;

        public Factory(MethodIdentifier methodIdentifier, boolean treatRequiredAsRequiresNew) {
            this.methodIdentifier = methodIdentifier;
            this.treatRequiredAsRequiresNew = treatRequiredAsRequiresNew;
        }

        protected Interceptor create(Component component, InterceptorFactoryContext context) {
            EJBComponent ejb = (EJBComponent)component;
            TransactionAttributeType txAttr = this.methodIdentifier == null ? TransactionAttributeType.REQUIRED : ejb.getTransactionAttributeType(MethodIntf.BEAN, this.methodIdentifier);
            int txTimeout = this.methodIdentifier == null ? -1 : ejb.getTransactionTimeout(MethodIntf.BEAN, this.methodIdentifier);
            if (this.treatRequiredAsRequiresNew && txAttr == TransactionAttributeType.REQUIRED) {
                txAttr = TransactionAttributeType.REQUIRES_NEW;
            }
            LifecycleCMTTxInterceptor interceptor = new LifecycleCMTTxInterceptor(txAttr, txTimeout);
            return interceptor;
        }
    }
}

