/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.modules.Module;

public class DeploymentDescriptorInterceptorBindingsProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EjbJarMetaData metaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        DeploymentReflectionIndex index = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        if (metaData == null) {
            return;
        }
        if (metaData.getAssemblyDescriptor() == null) {
            return;
        }
        if (metaData.getAssemblyDescriptor().getInterceptorBindings() == null) {
            return;
        }
        HashSet<String> interceptorClasses = new HashSet<String>();
        if (metaData.getInterceptors() != null) {
            for (InterceptorMetaData interceptor : metaData.getInterceptors()) {
                interceptorClasses.add(interceptor.getInterceptorClass());
            }
        }
        HashMap<String, ArrayList<InterceptorBindingMetaData>> bindingsPerComponent = new HashMap<String, ArrayList<InterceptorBindingMetaData>>();
        ArrayList<InterceptorBindingMetaData> defaultInterceptorBindings = new ArrayList<InterceptorBindingMetaData>();
        for (InterceptorBindingMetaData binding : metaData.getAssemblyDescriptor().getInterceptorBindings()) {
            if (binding.getEjbName().equals("*")) {
                if (binding.getMethod() != null) {
                    throw EjbLogger.ROOT_LOGGER.defaultInterceptorsNotBindToMethod();
                }
                if (binding.getInterceptorOrder() != null) {
                    throw EjbLogger.ROOT_LOGGER.defaultInterceptorsNotSpecifyOrder();
                }
                defaultInterceptorBindings.add(binding);
                continue;
            }
            ArrayList<InterceptorBindingMetaData> bindings = (ArrayList<InterceptorBindingMetaData>)bindingsPerComponent.get(binding.getEjbName());
            if (bindings == null) {
                bindings = new ArrayList<InterceptorBindingMetaData>();
                bindingsPerComponent.put(binding.getEjbName(), bindings);
            }
            bindings.add(binding);
        }
        ArrayList<InterceptorDescription> defaultInterceptors = new ArrayList<InterceptorDescription>();
        for (InterceptorBindingMetaData binding : defaultInterceptorBindings) {
            if (binding.getInterceptorClasses() == null) continue;
            for (String clazz : binding.getInterceptorClasses()) {
                if (interceptorClasses.contains(clazz)) {
                    defaultInterceptors.add(new InterceptorDescription(clazz));
                    continue;
                }
                EjbLogger.ROOT_LOGGER.defaultInterceptorClassNotListed(clazz);
            }
        }
        for (ComponentDescription componentDescription : eeModuleDescription.getComponentDescriptions()) {
            Class componentClass;
            try {
                componentClass = module.getClassLoader().loadClass(componentDescription.getComponentClassName());
            }
            catch (ClassNotFoundException e) {
                throw EjbLogger.ROOT_LOGGER.failToLoadComponentClass(e, componentDescription.getComponentClassName());
            }
            List bindings = (List)bindingsPerComponent.get(componentDescription.getComponentName());
            HashMap<Method, ArrayList<InterceptorBindingMetaData>> methodInterceptors = new HashMap<Method, ArrayList<InterceptorBindingMetaData>>();
            ArrayList<InterceptorBindingMetaData> classLevelBindings = new ArrayList<InterceptorBindingMetaData>();
            boolean classLevelExcludeDefaultInterceptors = false;
            HashMap<Method, Boolean> methodLevelExcludeDefaultInterceptors = new HashMap<Method, Boolean>();
            HashMap<Method, Boolean> methodLevelExcludeClassInterceptors = new HashMap<Method, Boolean>();
            boolean classLevelAbsoluteOrder = false;
            HashMap<Method, Boolean> methodLevelAbsoluteOrder = new HashMap<Method, Boolean>();
            if (bindings != null) {
                for (InterceptorBindingMetaData binding : bindings) {
                    Collection methods;
                    if (binding.getMethod() == null) {
                        classLevelBindings.add(binding);
                        if (binding.isExcludeDefaultInterceptors()) {
                            classLevelExcludeDefaultInterceptors = true;
                        }
                        if (!binding.isTotalOrdering()) continue;
                        if (classLevelAbsoluteOrder) {
                            throw EjbLogger.ROOT_LOGGER.twoEjbBindingsSpecifyAbsoluteOrder(componentClass.toString());
                        }
                        classLevelAbsoluteOrder = true;
                        continue;
                    }
                    NamedMethodMetaData namedMethodMetaData = binding.getMethod();
                    ClassReflectionIndex classIndex = index.getClassIndex(componentClass);
                    Method resolvedMethod = null;
                    if (namedMethodMetaData.getMethodParams() == null) {
                        methods = classIndex.getAllMethods(namedMethodMetaData.getMethodName());
                        if (methods.isEmpty()) {
                            throw EjbLogger.ROOT_LOGGER.failToFindMethodInEjbJarXml(componentClass.getName(), namedMethodMetaData.getMethodName());
                        }
                        if (methods.size() > 1) {
                            throw EjbLogger.ROOT_LOGGER.multipleMethodReferencedInEjbJarXml(namedMethodMetaData.getMethodName(), componentClass.getName());
                        }
                        resolvedMethod = (Method)methods.iterator().next();
                    } else {
                        methods = classIndex.getAllMethods(namedMethodMetaData.getMethodName(), namedMethodMetaData.getMethodParams().size());
                        for (Method method : methods) {
                            boolean match = true;
                            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                                if (method.getParameterTypes()[i].getName().equals(namedMethodMetaData.getMethodParams().get(i))) continue;
                                match = false;
                                break;
                            }
                            if (!match) continue;
                            resolvedMethod = method;
                            break;
                        }
                        if (resolvedMethod == null) {
                            throw EjbLogger.ROOT_LOGGER.failToFindMethodWithParameterTypes(componentClass.getName(), namedMethodMetaData.getMethodName(), namedMethodMetaData.getMethodParams());
                        }
                    }
                    ArrayList<InterceptorBindingMetaData> list = (ArrayList<InterceptorBindingMetaData>)methodInterceptors.get(resolvedMethod);
                    if (list == null) {
                        list = new ArrayList<InterceptorBindingMetaData>();
                        methodInterceptors.put(resolvedMethod, list);
                    }
                    list.add(binding);
                    if (binding.isExcludeDefaultInterceptors()) {
                        methodLevelExcludeDefaultInterceptors.put(resolvedMethod, true);
                    }
                    if (binding.isExcludeClassInterceptors()) {
                        methodLevelExcludeClassInterceptors.put(resolvedMethod, true);
                    }
                    if (!binding.isTotalOrdering()) continue;
                    if (methodLevelAbsoluteOrder.containsKey(resolvedMethod)) {
                        throw EjbLogger.ROOT_LOGGER.twoEjbBindingsSpecifyAbsoluteOrder(resolvedMethod.toString());
                    }
                    methodLevelAbsoluteOrder.put(resolvedMethod, true);
                }
            }
            componentDescription.setDefaultInterceptors(defaultInterceptors);
            if (classLevelExcludeDefaultInterceptors) {
                componentDescription.setExcludeDefaultInterceptors(true);
            }
            ArrayList<InterceptorDescription> classLevelInterceptors = new ArrayList<InterceptorDescription>();
            if (classLevelAbsoluteOrder) {
                for (InterceptorBindingMetaData interceptorBindingMetaData : classLevelBindings) {
                    if (!interceptorBindingMetaData.isTotalOrdering()) continue;
                    for (String interceptor : interceptorBindingMetaData.getInterceptorOrder()) {
                        classLevelInterceptors.add(new InterceptorDescription(interceptor));
                    }
                }
                componentDescription.setExcludeDefaultInterceptors(true);
            } else {
                classLevelInterceptors.addAll(componentDescription.getClassInterceptors());
                for (InterceptorBindingMetaData interceptorBindingMetaData : classLevelBindings) {
                    if (interceptorBindingMetaData.getInterceptorClasses() == null) continue;
                    for (String interceptor : interceptorBindingMetaData.getInterceptorClasses()) {
                        classLevelInterceptors.add(new InterceptorDescription(interceptor));
                    }
                }
            }
            componentDescription.setClassInterceptors(classLevelInterceptors);
            for (Map.Entry entry : methodInterceptors.entrySet()) {
                Boolean excludeClassInterceptors;
                Method method = (Method)entry.getKey();
                List methodBindings = (List)entry.getValue();
                boolean totalOrder = methodLevelAbsoluteOrder.containsKey(method);
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)method);
                Boolean excludeDefaultInterceptors = (Boolean)methodLevelExcludeDefaultInterceptors.get(method);
                excludeDefaultInterceptors = excludeDefaultInterceptors == null ? false : excludeDefaultInterceptors;
                if (!excludeDefaultInterceptors.booleanValue()) {
                    excludeDefaultInterceptors = componentDescription.isExcludeDefaultInterceptors() || componentDescription.isExcludeDefaultInterceptors(methodIdentifier);
                }
                if (!(excludeClassInterceptors = Boolean.valueOf((excludeClassInterceptors = (Boolean)methodLevelExcludeClassInterceptors.get(method)) == null ? false : excludeClassInterceptors)).booleanValue()) {
                    excludeClassInterceptors = componentDescription.isExcludeClassInterceptors(methodIdentifier);
                }
                ArrayList<InterceptorDescription> methodLevelInterceptors = new ArrayList<InterceptorDescription>();
                if (totalOrder) {
                    for (InterceptorBindingMetaData binding : methodBindings) {
                        if (!binding.isTotalOrdering()) continue;
                        for (String interceptor : binding.getInterceptorOrder()) {
                            methodLevelInterceptors.add(new InterceptorDescription(interceptor));
                        }
                    }
                } else {
                    List annotationMethodLevel;
                    if (!excludeDefaultInterceptors.booleanValue()) {
                        methodLevelInterceptors.addAll(defaultInterceptors);
                    }
                    if (!excludeClassInterceptors.booleanValue()) {
                        for (InterceptorDescription interceptor : classLevelInterceptors) {
                            methodLevelInterceptors.add(interceptor);
                        }
                    }
                    if ((annotationMethodLevel = (List)componentDescription.getMethodInterceptors().get(methodIdentifier)) != null) {
                        methodLevelInterceptors.addAll(annotationMethodLevel);
                    }
                    for (InterceptorBindingMetaData binding : methodBindings) {
                        if (binding.getInterceptorClasses() == null) continue;
                        for (String interceptor : binding.getInterceptorClasses()) {
                            methodLevelInterceptors.add(new InterceptorDescription(interceptor));
                        }
                    }
                }
                componentDescription.excludeClassInterceptors(methodIdentifier);
                componentDescription.excludeDefaultInterceptors(methodIdentifier);
                componentDescription.setMethodInterceptors(methodIdentifier, methodLevelInterceptors);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

