/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.AnonymousCallbackHandler;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.xnio.Option;
import org.xnio.OptionMap;

class EJBClientCommonConnectionConfig
implements EJBClientConfiguration.CommonConnectionCreationConfiguration {
    private OptionMap connectionCreationOptions = OptionMap.EMPTY;
    private OptionMap channelCreationOptions = OptionMap.EMPTY;
    private long connectionTimeout = 5000L;
    private CallbackHandlerProvider callbackHandlerProvider;

    EJBClientCommonConnectionConfig() {
    }

    public OptionMap getConnectionCreationOptions() {
        return this.connectionCreationOptions;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandlerProvider == null ? new AnonymousCallbackHandler() : this.callbackHandlerProvider.getCallbackHandler();
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public OptionMap getChannelCreationOptions() {
        return this.channelCreationOptions;
    }

    public boolean isConnectEagerly() {
        return true;
    }

    protected void setChannelCreationOptions(OptionMap channelCreationOptions) {
        this.channelCreationOptions = channelCreationOptions;
    }

    protected void setConnectionCreationOptions(OptionMap connectionCreationOptions) {
        this.connectionCreationOptions = connectionCreationOptions;
    }

    protected void setConnectionTimeout(long timeout) {
        this.connectionTimeout = timeout;
    }

    protected void setCallbackHandler(ServiceRegistry serviceRegistry, String username, String securityRealmName) {
        this.callbackHandlerProvider = new CallbackHandlerProvider(serviceRegistry, username, securityRealmName);
    }

    protected static OptionMap getOptionMapFromProperties(Properties properties, ClassLoader classLoader) {
        OptionMap.Builder optionMapBuilder = OptionMap.builder();
        for (String propertyName : properties.stringPropertyNames()) {
            try {
                Option option = Option.fromString((String)propertyName, (ClassLoader)classLoader);
                optionMapBuilder.parse(option, properties.getProperty(propertyName), classLoader);
            }
            catch (IllegalArgumentException e) {
                EjbLogger.ROOT_LOGGER.failedToCreateOptionForProperty(propertyName, e.getMessage());
            }
        }
        return optionMapBuilder.getMap();
    }

    private class CallbackHandlerProvider {
        private final ServiceRegistry serviceRegistry;
        private final String userName;
        private final String securityRealmName;

        CallbackHandlerProvider(ServiceRegistry serviceRegistry, String userName, String securityRealm) {
            this.serviceRegistry = serviceRegistry;
            this.userName = userName;
            this.securityRealmName = securityRealm;
        }

        CallbackHandler getCallbackHandler() {
            CallbackHandlerFactory cbhFactory;
            if (this.securityRealmName == null || this.securityRealmName.trim().isEmpty()) {
                return new AnonymousCallbackHandler();
            }
            ServiceName securityRealmServiceName = SecurityRealm.ServiceUtil.createServiceName((String)this.securityRealmName);
            ServiceController securityRealmController = this.serviceRegistry.getService(securityRealmServiceName);
            if (securityRealmController == null) {
                return new AnonymousCallbackHandler();
            }
            SecurityRealm securityRealm = (SecurityRealm)securityRealmController.getValue();
            if (securityRealm != null && (cbhFactory = securityRealm.getSecretCallbackHandlerFactory()) != null && this.userName != null) {
                return cbhFactory.getCallbackHandler(this.userName);
            }
            return new AnonymousCallbackHandler();
        }
    }
}

