/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.ExposeModelResource;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

class JMXSubsystemAdd
extends AbstractAddStepHandler {
    static final JMXSubsystemAdd INSTANCE = new JMXSubsystemAdd();

    private JMXSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        this.launchServices(context, model, verificationHandler, newControllers);
    }

    void launchServices(OperationContext context, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceController<?> controller;
        ModelNode recursiveModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        String resolvedDomain = this.getDomainName(context, recursiveModel, "resolved");
        String expressionsDomain = this.getDomainName(context, recursiveModel, "expression");
        boolean legacyWithProperPropertyFormat = false;
        if (model.hasDefined("proper-property-format")) {
            legacyWithProperPropertyFormat = ExposeModelResourceExpression.DOMAIN_NAME.resolveModelAttribute(context, recursiveModel).asBoolean();
        }
        ServiceController<?> serviceController = controller = verificationHandler != null ? MBeanServerService.addService(context.getServiceTarget(), resolvedDomain, expressionsDomain, legacyWithProperPropertyFormat, new ServiceListener[]{verificationHandler}) : MBeanServerService.addService(context.getServiceTarget(), resolvedDomain, expressionsDomain, legacyWithProperPropertyFormat, new ServiceListener[0]);
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    private String getDomainName(OperationContext context, ModelNode model, String child) throws OperationFailedException {
        if (!model.hasDefined("expose-model")) {
            return null;
        }
        if (!model.get("expose-model").hasDefined(child)) {
            return null;
        }
        ModelNode childModel = model.get(new String[]{"expose-model", child});
        return ExposeModelResource.getDomainNameAttribute(child).resolveModelAttribute(context, childModel).asString();
    }
}

