/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.service;

import java.lang.reflect.Method;
import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.descriptor.CallbackConfig;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.logging.PojoLogger;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.as.pojo.service.InstancesService;
import org.jboss.as.pojo.service.MethodJoinpoint;
import org.jboss.msc.value.Value;

public class Callback {
    private final BeanInfo beanInfo;
    private final Object bean;
    private final CallbackConfig config;
    private Method method;

    public Callback(BeanInfo beanInfo, Object bean, CallbackConfig config) {
        this.beanInfo = beanInfo;
        this.bean = bean;
        this.config = config;
    }

    protected Method getMethod() {
        if (this.method == null) {
            Method m = this.beanInfo.findMethod(this.config.getMethodName(), this.config.getSignature());
            if (m.getParameterCount() != 1) {
                throw PojoLogger.ROOT_LOGGER.illegalParameterLength(m);
            }
            this.method = m;
        }
        return this.method;
    }

    public Class<?> getType() {
        return this.getMethod().getParameterTypes()[0];
    }

    public BeanState getState() {
        return this.config.getState();
    }

    public void dispatch() throws Throwable {
        for (Object bean : InstancesService.getBeans(this.getType(), this.getState())) {
            this.dispatch(bean);
        }
    }

    public void dispatch(final Object dependency) throws Throwable {
        MethodJoinpoint joinpoint = new MethodJoinpoint(this.getMethod());
        joinpoint.setTarget((Value<Object>)((Value)() -> this.bean));
        ValueConfig param = new ValueConfig(){

            @Override
            protected Object getClassValue(Class<?> type) {
                return dependency;
            }
        };
        joinpoint.setParameters(new ValueConfig[]{param});
        joinpoint.dispatch();
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Callback)) {
            return false;
        }
        Callback callback = (Callback)obj;
        return this.config.equals(callback.config);
    }
}

