/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.remoting;

import java.security.Principal;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmRole;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.security.remoting.RemoteConnection;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;

public final class RemotingConnectionCredential {
    private final RemoteConnection connection;
    private final SecurityIdentity securityIdentity;
    private final Subject subject;

    public RemotingConnectionCredential(RemoteConnection connection, SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"connection", (Object)connection);
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        this.connection = connection;
        this.securityIdentity = securityIdentity;
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add((Principal)new RealmUser(securityIdentity.getPrincipal().getName()));
        StreamSupport.stream(securityIdentity.getRoles().spliterator(), true).forEach(role -> {
            principals.add((Principal)new RealmGroup(role));
            principals.add((Principal)new RealmRole(role));
        });
        this.subject = subject;
    }

    SSLSession getSSLSession() {
        return this.connection.getSslSession();
    }

    SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RemotingConnectionCredential && this.equals((RemotingConnectionCredential)obj);
    }

    public boolean equals(RemotingConnectionCredential obj) {
        return this.connection.equals(obj.connection) && this.securityIdentity.equals(obj.securityIdentity);
    }
}

