/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.interfaces.InetAddressUtil;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.version.ProductConfig;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ServerEnvironment
extends ProcessEnvironment
implements Serializable {
    private static final long serialVersionUID = 1725061010357265545L;
    public static final String JAVA_EXT_DIRS = "java.ext.dirs";
    public static final String HOME_DIR = "jboss.home.dir";
    @Deprecated
    public static final String MODULES_DIR = "jboss.modules.dir";
    public static final String BUNDLES_DIR = "jboss.bundles.dir";
    public static final String VFS_MODULE_IDENTIFIER = "org.jboss.vfs";
    public static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    public static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    public static final String SERVER_DATA_DIR = "jboss.server.data.dir";
    public static final String SERVER_CONTENT_DIR = "jboss.server.content.dir";
    @Deprecated
    public static final String SERVER_DEPLOY_DIR = "jboss.server.deploy.dir";
    public static final String SERVER_LOG_DIR = "jboss.server.log.dir";
    public static final String SERVER_TEMP_DIR = "jboss.server.temp.dir";
    public static final String CONTROLLER_TEMP_DIR = "jboss.controller.temp.dir";
    public static final String NODE_NAME = "jboss.node.name";
    public static final String SERVER_NAME = "jboss.server.name";
    public static final String HOST_NAME = "jboss.host.name";
    public static final String QUALIFIED_HOST_NAME = "jboss.qualified.host.name";
    public static final String BOOTSTRAP_MAX_THREADS = "org.jboss.server.bootstrap.maxThreads";
    public static final String JBOSS_BIND_ADDRESS = "jboss.bind.address";
    public static final String JBOSS_BIND_ADDRESS_PREFIX = "jboss.bind.address.";
    public static final String JBOSS_DEFAULT_MULTICAST_ADDRESS = "jboss.default.multicast.address";
    public static final String JBOSS_SERVER_DEFAULT_CONFIG = "jboss.server.default.config";
    @Deprecated
    public static final String JBOSS_PERSIST_SERVER_CONFIG = "jboss.server.persist.config";
    protected static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    protected static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    private static final Set<String> ILLEGAL_PROPERTIES = new HashSet<String>(Arrays.asList("jboss.domain.base.dir", "jboss.domain.config.dir", "java.ext.dirs", "jboss.home.dir", "modules.path", "jboss.server.base.dir", "jboss.server.config.dir", "jboss.server.data.dir", "jboss.server.deploy.dir", "jboss.server.log.dir", "org.jboss.server.bootstrap.maxThreads", "jboss.controller.temp.dir", "jboss.server.default.config", "jboss.server.persist.config"));
    private static final Set<String> BOOT_PROPERTIES = new HashSet<String>(Arrays.asList("jboss.bundles.dir", "jboss.server.temp.dir", "jboss.node.name", "jboss.server.name", "jboss.host.name", "jboss.qualified.host.name"));
    private final Properties primordialProperties;
    private final Properties providedProperties;
    private volatile boolean processNameSet;
    private final LaunchType launchType;
    private final String hostControllerName;
    private volatile String qualifiedHostName;
    private volatile String hostName;
    private volatile String serverName;
    private volatile String nodeName;
    private final File[] javaExtDirs;
    private final File homeDir;
    private final File modulesDir;
    private final File serverBaseDir;
    private final File serverConfigurationDir;
    private final ConfigurationFile serverConfigurationFile;
    private final File serverLogDir;
    private final File controllerTempDir;
    private volatile File serverDataDir;
    private volatile File serverContentDir;
    private volatile File serverTempDir;
    private volatile File bundlesDir;
    private final File domainBaseDir;
    private final File domainConfigurationDir;
    private final boolean standalone;
    private final boolean allowModelControllerExecutor;
    private final RunningMode initialRunningMode;
    private final ProductConfig productConfig;
    private final RunningModeControl runningModeControl;
    private static final File[] NO_FILES = new File[0];

    public ServerEnvironment(String hostControllerName, Properties props, Map<String, String> env, String serverConfig, String initialServerConfig, LaunchType launchType, RunningMode initialRunningMode, ProductConfig productConfig) {
        if (props == null) {
            throw ControllerMessages.MESSAGES.nullVar("props");
        }
        this.launchType = launchType;
        this.standalone = launchType != LaunchType.DOMAIN;
        this.initialRunningMode = initialRunningMode == null ? RunningMode.NORMAL : initialRunningMode;
        this.runningModeControl = new RunningModeControl(this.initialRunningMode);
        this.hostControllerName = hostControllerName;
        if (this.standalone && hostControllerName != null) {
            throw ServerMessages.MESSAGES.hostControllerNameNonNullInStandalone();
        }
        if (!this.standalone && hostControllerName == null) {
            throw ServerMessages.MESSAGES.hostControllerNameNullInDomain();
        }
        this.configureQualifiedHostName(props.getProperty(QUALIFIED_HOST_NAME), props.getProperty(HOST_NAME), props, env);
        this.javaExtDirs = this.getFilesFromProperty(JAVA_EXT_DIRS, props);
        this.homeDir = this.getFileFromProperty(HOME_DIR, props);
        if (this.homeDir == null) {
            throw ServerMessages.MESSAGES.missingHomeDirConfiguration(HOME_DIR);
        }
        if (!this.homeDir.exists() || !this.homeDir.isDirectory()) {
            throw ServerMessages.MESSAGES.homeDirectoryDoesNotExist(this.homeDir);
        }
        File tmp = this.getFileFromProperty(MODULES_DIR, props);
        if (tmp == null) {
            tmp = new File(this.homeDir, "modules");
        } else if (!tmp.exists() || !tmp.isDirectory()) {
            throw ServerMessages.MESSAGES.modulesDirectoryDoesNotExist(tmp);
        }
        this.modulesDir = tmp;
        this.configureBundlesDir(props.getProperty(BUNDLES_DIR), props);
        tmp = this.getFileFromProperty(SERVER_BASE_DIR, props);
        if (tmp == null) {
            tmp = new File(this.homeDir, this.standalone ? "standalone" : "domain/servers/" + this.serverName);
        }
        if (this.standalone) {
            if (!tmp.exists()) {
                throw ServerMessages.MESSAGES.serverBaseDirectoryDoesNotExist(tmp);
            }
            if (!tmp.isDirectory()) {
                throw ServerMessages.MESSAGES.serverBaseDirectoryIsNotADirectory(tmp);
            }
        } else if (tmp.exists()) {
            if (!tmp.isDirectory()) {
                throw ServerMessages.MESSAGES.serverBaseDirectoryIsNotADirectory(tmp);
            }
        } else if (!tmp.mkdirs()) {
            throw ServerMessages.MESSAGES.couldNotCreateServerBaseDirectory(tmp);
        }
        this.serverBaseDir = tmp;
        tmp = this.getFileFromProperty(SERVER_CONFIG_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverBaseDir, "configuration");
        }
        this.serverConfigurationDir = tmp;
        if (!(!this.standalone || this.serverConfigurationDir.exists() && this.serverConfigurationDir.isDirectory())) {
            throw ServerMessages.MESSAGES.configDirectoryDoesNotExist(this.serverConfigurationDir);
        }
        String defaultServerConfig = WildFlySecurityManager.getPropertyPrivileged((String)JBOSS_SERVER_DEFAULT_CONFIG, (String)"standalone.xml");
        String config = initialServerConfig == null ? serverConfig : initialServerConfig;
        boolean persist = initialServerConfig == null;
        this.serverConfigurationFile = this.standalone ? new ConfigurationFile(this.serverConfigurationDir, defaultServerConfig, config, persist) : null;
        String propertyKey = JBOSS_PERSIST_SERVER_CONFIG;
        WildFlySecurityManager.setPropertyPrivileged((String)JBOSS_PERSIST_SERVER_CONFIG, (String)Boolean.toString(persist));
        tmp = this.getFileFromProperty(SERVER_DATA_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverBaseDir, "data");
        }
        this.serverDataDir = tmp;
        if (this.serverDataDir.exists()) {
            if (!this.serverDataDir.isDirectory()) {
                throw ServerMessages.MESSAGES.serverDataDirectoryIsNotDirectory(this.serverDataDir);
            }
        } else if (!this.serverDataDir.mkdirs()) {
            throw ServerMessages.MESSAGES.couldNotCreateServerDataDirectory(this.serverDataDir);
        }
        if ((tmp = this.getFileFromProperty(SERVER_CONTENT_DIR, props)) == null) {
            String deprecatedProp = SERVER_DEPLOY_DIR;
            tmp = this.getFileFromProperty(deprecatedProp, props);
        }
        if (tmp == null) {
            tmp = new File(this.serverDataDir, "content");
        }
        this.serverContentDir = tmp;
        if (this.serverContentDir.exists()) {
            if (!this.serverContentDir.isDirectory()) {
                throw ServerMessages.MESSAGES.serverContentDirectoryIsNotDirectory(this.serverContentDir);
            }
        } else if (!this.serverContentDir.mkdirs()) {
            throw ServerMessages.MESSAGES.couldNotCreateServerContentDirectory(this.serverContentDir);
        }
        if ((tmp = this.getFileFromProperty(SERVER_LOG_DIR, props)) == null) {
            tmp = new File(this.serverBaseDir, "log");
        }
        if (tmp.exists()) {
            if (!tmp.isDirectory()) {
                throw ServerMessages.MESSAGES.logDirectoryIsNotADirectory(tmp);
            }
        } else if (!tmp.mkdirs()) {
            throw ServerMessages.MESSAGES.couldNotCreateLogDirectory(tmp);
        }
        this.serverLogDir = tmp;
        tmp = this.configureServerTempDir(props.getProperty(SERVER_TEMP_DIR), props);
        if (tmp.exists()) {
            if (!tmp.isDirectory()) {
                throw ServerMessages.MESSAGES.serverTempDirectoryIsNotADirectory(tmp);
            }
        } else if (!tmp.mkdirs()) {
            throw ServerMessages.MESSAGES.couldNotCreateServerTempDirectory(tmp);
        }
        if ((tmp = this.getFileFromProperty(CONTROLLER_TEMP_DIR, props)) == null) {
            tmp = this.serverTempDir;
        }
        if (tmp.exists()) {
            if (!tmp.isDirectory()) {
                throw ServerMessages.MESSAGES.controllerTempDirectoryIsNotADirectory(tmp);
            }
        } else if (!tmp.mkdirs()) {
            throw ServerMessages.MESSAGES.couldNotCreateControllerTempDirectory(tmp);
        }
        this.controllerTempDir = tmp;
        tmp = this.getFileFromProperty(DOMAIN_BASE_DIR, props);
        if (tmp != null) {
            if (!tmp.exists() || !tmp.isDirectory()) {
                throw ServerMessages.MESSAGES.domainBaseDirDoesNotExist(tmp);
            }
            this.domainBaseDir = tmp;
        } else {
            this.domainBaseDir = null;
        }
        tmp = this.getFileFromProperty(DOMAIN_CONFIG_DIR, props);
        if (tmp != null) {
            if (!tmp.exists() || !tmp.isDirectory()) {
                throw ServerMessages.MESSAGES.domainConfigDirDoesNotExist(tmp);
            }
            this.domainConfigurationDir = tmp;
        } else {
            this.domainConfigurationDir = null;
        }
        boolean allowExecutor = true;
        String maxThreads = WildFlySecurityManager.getPropertyPrivileged((String)BOOTSTRAP_MAX_THREADS, null);
        if (maxThreads != null && maxThreads.length() > 0) {
            try {
                Integer.decode(maxThreads);
                allowExecutor = false;
            }
            catch (NumberFormatException ex) {
                ServerLogger.ROOT_LOGGER.failedToParseCommandLineInteger(BOOTSTRAP_MAX_THREADS, maxThreads);
            }
        }
        this.allowModelControllerExecutor = allowExecutor;
        this.productConfig = productConfig;
        this.primordialProperties = new Properties();
        ServerEnvironment.copyProperties(props, this.primordialProperties);
        this.providedProperties = new Properties();
        ServerEnvironment.copyProperties(this.primordialProperties, this.providedProperties);
        WildFlySecurityManager.setPropertyPrivileged((String)QUALIFIED_HOST_NAME, (String)this.qualifiedHostName);
        WildFlySecurityManager.setPropertyPrivileged((String)HOST_NAME, (String)this.hostName);
        WildFlySecurityManager.setPropertyPrivileged((String)SERVER_NAME, (String)this.serverName);
        WildFlySecurityManager.setPropertyPrivileged((String)NODE_NAME, (String)this.nodeName);
        WildFlySecurityManager.setPropertyPrivileged((String)HOME_DIR, (String)this.homeDir.getAbsolutePath());
        WildFlySecurityManager.setPropertyPrivileged((String)MODULES_DIR, (String)this.modulesDir.getAbsolutePath());
        WildFlySecurityManager.setPropertyPrivileged((String)SERVER_BASE_DIR, (String)this.serverBaseDir.getAbsolutePath());
        WildFlySecurityManager.setPropertyPrivileged((String)SERVER_CONFIG_DIR, (String)this.serverConfigurationDir.getAbsolutePath());
        WildFlySecurityManager.setPropertyPrivileged((String)SERVER_DATA_DIR, (String)this.serverDataDir.getAbsolutePath());
        WildFlySecurityManager.setPropertyPrivileged((String)SERVER_DEPLOY_DIR, (String)this.serverContentDir.getAbsolutePath());
        WildFlySecurityManager.setPropertyPrivileged((String)SERVER_LOG_DIR, (String)this.serverLogDir.getAbsolutePath());
        WildFlySecurityManager.setPropertyPrivileged((String)SERVER_TEMP_DIR, (String)this.serverTempDir.getAbsolutePath());
        if (launchType.getProcessType() == ProcessType.DOMAIN_SERVER) {
            if (this.domainBaseDir != null) {
                WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_BASE_DIR, (String)this.domainBaseDir.getAbsolutePath());
            }
            if (this.domainConfigurationDir != null) {
                WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_CONFIG_DIR, (String)this.domainConfigurationDir.getAbsolutePath());
            }
        }
        try {
            ModuleLoader bootLoader = Module.getBootModuleLoader();
            Module vfsModule = bootLoader.loadModule(ModuleIdentifier.create((String)VFS_MODULE_IDENTIFIER));
            Module.registerURLStreamHandlerFactoryModule((Module)vfsModule);
        }
        catch (Exception ex) {
            ServerLogger.ROOT_LOGGER.cannotAddURLStreamHandlerFactory(ex, VFS_MODULE_IDENTIFIER);
        }
    }

    private static void copyProperties(Properties src, Properties dest) {
        for (Map.Entry<Object, Object> entry : src.entrySet()) {
            Object val;
            Object key = entry.getKey();
            if (!(key instanceof String) || (val = entry.getValue()) != null && !(val instanceof String)) continue;
            dest.setProperty((String)key, (String)val);
        }
    }

    void resetProvidedProperties() {
        this.providedProperties.clear();
        ServerEnvironment.copyProperties(this.primordialProperties, this.providedProperties);
        this.processNameSet = false;
    }

    public String getHostControllerName() {
        return this.hostControllerName;
    }

    public String getServerName() {
        return this.serverName;
    }

    private void configureServerName(String serverName, Properties providedProperties) {
        if (serverName == null) {
            serverName = this.hostName;
        } else {
            providedProperties.setProperty(SERVER_NAME, serverName);
            serverName = ServerEnvironment.resolveGUID((String)serverName);
        }
        this.serverName = serverName;
        this.configureNodeName(providedProperties.getProperty(NODE_NAME), providedProperties);
    }

    public String getQualifiedHostName() {
        return this.qualifiedHostName;
    }

    private void configureQualifiedHostName(String qualifiedHostName, String providedHostName, Properties providedProperties, Map<String, String> env) {
        if (qualifiedHostName == null) {
            qualifiedHostName = providedHostName;
            if (qualifiedHostName == null) {
                qualifiedHostName = env.get("HOSTNAME");
            }
            if (qualifiedHostName == null) {
                qualifiedHostName = env.get("COMPUTERNAME");
            }
            if (qualifiedHostName == null) {
                try {
                    qualifiedHostName = InetAddressUtil.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    qualifiedHostName = null;
                }
            }
            if (qualifiedHostName != null && qualifiedHostName.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$|:")) {
                qualifiedHostName = null;
            }
            qualifiedHostName = qualifiedHostName == null ? "unknown-host.unknown-domain" : qualifiedHostName.trim().toLowerCase();
        } else {
            providedProperties.setProperty(QUALIFIED_HOST_NAME, qualifiedHostName);
        }
        this.qualifiedHostName = qualifiedHostName;
        this.configureHostName(providedProperties.getProperty(HOST_NAME), providedProperties);
    }

    public String getHostName() {
        return this.hostName;
    }

    private void configureHostName(String hostName, Properties providedProperties) {
        if (hostName == null) {
            providedProperties.remove(HOST_NAME);
            int idx = this.qualifiedHostName.indexOf(46);
            hostName = idx == -1 ? this.qualifiedHostName : this.qualifiedHostName.substring(0, idx);
        } else {
            providedProperties.setProperty(HOST_NAME, hostName);
        }
        this.hostName = hostName;
        this.configureServerName(providedProperties.getProperty(SERVER_NAME), providedProperties);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    private void configureNodeName(String nodeName, Properties providedProperties) {
        if (nodeName == null) {
            providedProperties.remove(NODE_NAME);
            nodeName = this.hostControllerName == null ? this.serverName : this.hostControllerName + ":" + this.serverName;
        } else {
            providedProperties.setProperty(NODE_NAME, nodeName);
        }
        this.nodeName = nodeName;
    }

    public File[] getJavaExtDirs() {
        return (File[])this.javaExtDirs.clone();
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    @Deprecated
    public File getModulesDir() {
        return this.modulesDir;
    }

    public File getBundlesDir() {
        return this.bundlesDir;
    }

    private void configureBundlesDir(String dirPath, Properties providedProperties) {
        boolean haveDirProperty = dirPath != null;
        File tmp = this.getFileFromPath(dirPath);
        if (tmp == null) {
            if (haveDirProperty) {
                throw ServerMessages.MESSAGES.bundlesDirectoryDoesNotExist(new File(dirPath).getAbsoluteFile());
            }
            providedProperties.remove(BUNDLES_DIR);
            tmp = new File(this.homeDir, "bundles");
        } else {
            providedProperties.setProperty(BUNDLES_DIR, dirPath);
        }
        this.bundlesDir = tmp;
    }

    public File getServerBaseDir() {
        return this.serverBaseDir;
    }

    public File getServerConfigurationDir() {
        return this.serverConfigurationDir;
    }

    public ConfigurationFile getServerConfigurationFile() {
        return this.serverConfigurationFile;
    }

    public File getServerDataDir() {
        return this.serverDataDir;
    }

    public File getServerContentDir() {
        return this.serverContentDir;
    }

    @Deprecated
    public File getServerDeployDir() {
        return this.serverContentDir;
    }

    public File getServerLogDir() {
        return this.serverLogDir;
    }

    public File getServerTempDir() {
        return this.serverTempDir;
    }

    private File configureServerTempDir(String path, Properties providedProps) {
        File tmp = this.getFileFromPath(path);
        if (tmp == null) {
            providedProps.remove(SERVER_TEMP_DIR);
            tmp = new File(this.serverBaseDir, "tmp");
        } else {
            providedProps.setProperty(SERVER_TEMP_DIR, path);
        }
        this.serverTempDir = tmp;
        return tmp;
    }

    File getControllerTempDir() {
        return this.controllerTempDir;
    }

    public File getDomainBaseDir() {
        return this.domainBaseDir;
    }

    public File getDomainConfigurationDir() {
        return this.domainConfigurationDir;
    }

    public LaunchType getLaunchType() {
        return this.launchType;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public RunningMode getInitialRunningMode() {
        return this.initialRunningMode;
    }

    public RunningModeControl getRunningModeControl() {
        return this.runningModeControl;
    }

    boolean isAllowModelControllerExecutor() {
        return this.allowModelControllerExecutor;
    }

    public ProductConfig getProductConfig() {
        return this.productConfig;
    }

    public static int getBootstrapMaxThreads() {
        int cpuCount = Runtime.getRuntime().availableProcessors();
        int defaultThreads = cpuCount * 2;
        String maxThreads = WildFlySecurityManager.getPropertyPrivileged((String)BOOTSTRAP_MAX_THREADS, null);
        if (maxThreads != null && maxThreads.length() > 0) {
            try {
                int max = Integer.decode(maxThreads);
                defaultThreads = Math.max(max, 1);
            }
            catch (NumberFormatException ex) {
                ServerLogger.ROOT_LOGGER.failedToParseCommandLineInteger(BOOTSTRAP_MAX_THREADS, maxThreads);
            }
        }
        return defaultThreads;
    }

    protected String getProcessName() {
        return this.serverName;
    }

    protected void setProcessName(String processName) {
        if (processName != null) {
            if (this.primordialProperties.contains(SERVER_NAME)) {
                String rawServerProp = WildFlySecurityManager.getPropertyPrivileged((String)SERVER_NAME, (String)this.serverName);
                ServerLogger.AS_ROOT_LOGGER.duplicateServerNameConfiguration(SERVER_NAME, rawServerProp, processName);
            }
            this.serverName = processName;
            WildFlySecurityManager.setPropertyPrivileged((String)SERVER_NAME, (String)this.serverName);
            this.processNameSet = true;
            if (!this.primordialProperties.contains(NODE_NAME)) {
                this.nodeName = this.serverName;
                WildFlySecurityManager.setPropertyPrivileged((String)NODE_NAME, (String)this.nodeName);
            }
        }
    }

    protected boolean isRuntimeSystemPropertyUpdateAllowed(String propertyName, String propertyValue, boolean bootTime) throws OperationFailedException {
        if (ILLEGAL_PROPERTIES.contains(propertyName)) {
            throw ServerMessages.MESSAGES.systemPropertyNotManageable(propertyName);
        }
        if (this.processNameSet && SERVER_NAME.equals(propertyName)) {
            throw ServerMessages.MESSAGES.systemPropertyCannotOverrideServerName(SERVER_NAME);
        }
        return bootTime || !BOOT_PROPERTIES.contains(propertyName);
    }

    protected void systemPropertyUpdated(String propertyName, String propertyValue) {
        if (BOOT_PROPERTIES.contains(propertyName)) {
            if (BUNDLES_DIR.equals(propertyName)) {
                this.configureBundlesDir(propertyValue, this.providedProperties);
            } else if (SERVER_TEMP_DIR.equals(propertyName)) {
                this.configureServerTempDir(propertyValue, this.providedProperties);
            } else if (QUALIFIED_HOST_NAME.equals(propertyName)) {
                this.configureQualifiedHostName(propertyValue, this.providedProperties.getProperty(HOST_NAME), this.providedProperties, WildFlySecurityManager.getSystemEnvironmentPrivileged());
            } else if (HOST_NAME.equals(propertyName)) {
                this.configureHostName(propertyValue, this.providedProperties);
            } else if (SERVER_NAME.equals(propertyName)) {
                this.configureServerName(propertyValue, this.providedProperties);
            } else if (NODE_NAME.equals(propertyName)) {
                this.configureNodeName(propertyValue, this.providedProperties);
            }
        }
    }

    private File getFileFromProperty(String name, Properties props) {
        return this.getFileFromPath(props.getProperty(name));
    }

    private File getFileFromPath(String path) {
        File relative;
        File result;
        File file = result = path != null ? new File(path) : null;
        if (result != null && this.homeDir != null && !result.exists() && !result.isAbsolute() && (relative = new File(this.homeDir, path)).exists()) {
            result = relative;
        }
        return result;
    }

    private File[] getFilesFromProperty(String name, Properties props) {
        String sep = WildFlySecurityManager.getPropertyPrivileged((String)"path.separator", null);
        String value = props.getProperty(name, null);
        if (value != null) {
            String[] paths = value.split(Pattern.quote(sep));
            int len = paths.length;
            File[] files = new File[len];
            for (int i = 0; i < len; ++i) {
                files[i] = new File(paths[i]);
            }
            return files;
        }
        return NO_FILES;
    }

    public static enum LaunchType {
        DOMAIN(ProcessType.DOMAIN_SERVER),
        STANDALONE(ProcessType.STANDALONE_SERVER),
        EMBEDDED(ProcessType.EMBEDDED_SERVER),
        APPCLIENT(ProcessType.APPLICATION_CLIENT);

        private final ProcessType processType;

        private LaunchType(ProcessType processType) {
            this.processType = processType;
        }

        public ProcessType getProcessType() {
            return this.processType;
        }
    }
}

