/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.deployment.AbstractDeploymentUnitService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentAttributes {
    public static final ResourceDescriptionResolver DEPLOYMENT_RESOLVER = ServerDescriptions.getResourceDescriptionResolver("deployment", false);
    public static final SimpleAttributeDefinition NAME = SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)false).setValidator((ParameterValidator)new StringLengthValidator(1, false)).build();
    public static final AttributeDefinition TO_REPLACE = SimpleAttributeDefinitionBuilder.create((String)"to-replace", (SimpleAttributeDefinition)NAME).build();
    public static final SimpleAttributeDefinition RUNTIME_NAME = SimpleAttributeDefinitionBuilder.create((String)"runtime-name", (ModelType)ModelType.STRING, (boolean)false).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    public static final SimpleAttributeDefinition RUNTIME_NAME_NILLABLE = SimpleAttributeDefinitionBuilder.create((String)"runtime-name", (ModelType)ModelType.STRING, (boolean)true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).build();
    public static final SimpleAttributeDefinition ENABLED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"enabled", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(false)).setAllowExpression(false).setAttributeMarshaller(new AttributeMarshaller(){

        public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel) {
            return !resourceModel.has(attribute.getName()) || resourceModel.get(attribute.getName()).getType() != ModelType.BOOLEAN || !resourceModel.get(attribute.getName()).asBoolean();
        }

        public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            ModelNode value;
            ModelNode modelNode = value = resourceModel.hasDefined(attribute.getName()) ? resourceModel.get(attribute.getName()) : new ModelNode(false);
            if (value.getType() != ModelType.BOOLEAN || !value.asBoolean()) {
                writer.writeAttribute(attribute.getXmlName(), value.asString());
            }
        }
    })).build();
    public static final AttributeDefinition PERSISTENT = SimpleAttributeDefinitionBuilder.create((String)"persistent", (ModelType)ModelType.BOOLEAN, (boolean)false).build();
    public static final AttributeDefinition STATUS = SimpleAttributeDefinitionBuilder.create((String)"status", (ModelType)ModelType.STRING, (boolean)false).setValidator((ParameterValidator)new EnumValidator(AbstractDeploymentUnitService.DeploymentStatus.class, false, (Enum[])new AbstractDeploymentUnitService.DeploymentStatus[0])).build();
    public static final SimpleAttributeDefinition CONTENT_INPUT_STREAM_INDEX = DeploymentAttributes.createContentValueTypeAttribute("input-stream-index", ModelType.INT, (ParameterValidator)new StringLengthValidator(1, true), false);
    public static final SimpleAttributeDefinition CONTENT_HASH = DeploymentAttributes.createContentValueTypeAttribute("hash", ModelType.BYTES, (ParameterValidator)new HashValidator(true), false);
    public static final SimpleAttributeDefinition CONTENT_BYTES = DeploymentAttributes.createContentValueTypeAttribute("bytes", ModelType.BYTES, (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true), false);
    public static final SimpleAttributeDefinition CONTENT_URL = DeploymentAttributes.createContentValueTypeAttribute("url", ModelType.STRING, (ParameterValidator)new StringLengthValidator(1, true), false);
    public static final AttributeDefinition CONTENT_PATH = DeploymentAttributes.createContentValueTypeAttribute("path", ModelType.STRING, (ParameterValidator)new StringLengthValidator(1, true), false);
    public static final AttributeDefinition CONTENT_RELATIVE_TO = DeploymentAttributes.createContentValueTypeAttribute("relative-to", ModelType.STRING, (ParameterValidator)new StringLengthValidator(1, true), false);
    public static final AttributeDefinition CONTENT_ARCHIVE = DeploymentAttributes.createContentValueTypeAttribute("archive", ModelType.BOOLEAN, (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN), false);
    public static final ObjectListAttributeDefinition CONTENT_ALL = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"content", (ObjectTypeAttributeDefinition)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"content", (AttributeDefinition[])new AttributeDefinition[]{CONTENT_INPUT_STREAM_INDEX, CONTENT_HASH, CONTENT_BYTES, CONTENT_URL, CONTENT_PATH, CONTENT_RELATIVE_TO, CONTENT_ARCHIVE}).setValidator((ParameterValidator)new ContentTypeValidator())).build()).setMinSize(1)).setMaxSize(1)).build();
    public static final ObjectListAttributeDefinition CONTENT_ALL_NILLABLE = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"content", (ObjectTypeAttributeDefinition)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"content", (AttributeDefinition[])new AttributeDefinition[]{CONTENT_INPUT_STREAM_INDEX, CONTENT_HASH, CONTENT_BYTES, CONTENT_URL, CONTENT_PATH, CONTENT_RELATIVE_TO, CONTENT_ARCHIVE}).setValidator((ParameterValidator)new ContentTypeValidator())).build()).setMinSize(1)).setMaxSize(1)).setAllowNull(true).build();
    public static final ObjectListAttributeDefinition CONTENT_RESOURCE = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"content", (ObjectTypeAttributeDefinition)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"content", (AttributeDefinition[])new AttributeDefinition[]{CONTENT_HASH, CONTENT_PATH, CONTENT_RELATIVE_TO, CONTENT_ARCHIVE}).setValidator((ParameterValidator)new ContentTypeValidator())).build()).setMinSize(1)).setMaxSize(1)).build();
    public static final AttributeDefinition[] SERVER_RESOURCE_ATTRIBUTES = new AttributeDefinition[]{NAME, RUNTIME_NAME, CONTENT_RESOURCE, ENABLED, PERSISTENT, STATUS};
    public static final AttributeDefinition[] SERVER_ADD_ATTRIBUTES = new AttributeDefinition[]{RUNTIME_NAME_NILLABLE, CONTENT_ALL, ENABLED};
    public static final AttributeDefinition[] SERVER_GROUP_RESOURCE_ATTRIBUTES = new AttributeDefinition[]{NAME, RUNTIME_NAME, ENABLED};
    public static final AttributeDefinition[] SERVER_GROUP_ADD_ATTRIBUTES = new AttributeDefinition[]{RUNTIME_NAME_NILLABLE, ENABLED};
    public static final AttributeDefinition[] DOMAIN_RESOURCE_ATTRIBUTES = new AttributeDefinition[]{NAME, RUNTIME_NAME, CONTENT_RESOURCE};
    public static final AttributeDefinition[] DOMAIN_ADD_ATTRIBUTES = new AttributeDefinition[]{RUNTIME_NAME_NILLABLE, CONTENT_ALL};
    public static final Map<String, AttributeDefinition> MANAGED_CONTENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(new AttributeDefinition[]{CONTENT_INPUT_STREAM_INDEX, CONTENT_HASH, CONTENT_BYTES, CONTENT_URL});
    public static final Map<String, AttributeDefinition> UNMANAGED_CONTENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(CONTENT_PATH, CONTENT_RELATIVE_TO, CONTENT_ARCHIVE);
    public static final Map<String, AttributeDefinition> ALL_CONTENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(MANAGED_CONTENT_ATTRIBUTES, UNMANAGED_CONTENT_ATTRIBUTES);
    public static final OperationDefinition DEPLOY_DEFINITION = new SimpleOperationDefinition("deploy", DEPLOYMENT_RESOLVER);
    public static final OperationDefinition UNDEPLOY_DEFINITION = new SimpleOperationDefinition("undeploy", DEPLOYMENT_RESOLVER);
    public static final OperationDefinition REDEPLOY_DEFINITION = new SimpleOperationDefinition("redeploy", DEPLOYMENT_RESOLVER);
    public static final OperationDefinition SERVER_DEPLOYMENT_ADD_DEFINITION = new SimpleOperationDefinitionBuilder("add", DEPLOYMENT_RESOLVER).setParameters(SERVER_ADD_ATTRIBUTES).build();
    public static final OperationDefinition SERVER_GROUP_DEPLOYMENT_ADD_DEFINITION = new SimpleOperationDefinitionBuilder("add", DEPLOYMENT_RESOLVER).setParameters(SERVER_GROUP_ADD_ATTRIBUTES).build();
    public static final OperationDefinition DOMAIN_DEPLOYMENT_ADD_DEFINITION = new SimpleOperationDefinitionBuilder("add", DEPLOYMENT_RESOLVER).setParameters(DOMAIN_ADD_ATTRIBUTES).build();
    private static SimpleAttributeDefinition UPLOAD_HASH_REPLY = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CONTENT_HASH).setAllowNull(false).build();
    public static final AttributeDefinition BYTES_NOT_NULL = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CONTENT_BYTES).setAllowNull(false).build();
    public static final OperationDefinition UPLOAD_BYTES_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-bytes", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{BYTES_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).build();
    public static final OperationDefinition DOMAIN_UPLOAD_BYTES_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-bytes", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{BYTES_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).build();
    public static final AttributeDefinition URL_NOT_NULL = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CONTENT_URL).setAllowNull(false).build();
    public static final OperationDefinition UPLOAD_URL_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-url", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{URL_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).build();
    public static final OperationDefinition DOMAIN_UPLOAD_URL_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-url", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{URL_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).build();
    public static final AttributeDefinition INPUT_STREAM_INDEX_NOT_NULL = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CONTENT_INPUT_STREAM_INDEX).setAllowNull(false).build();
    public static final OperationDefinition UPLOAD_STREAM_ATTACHMENT_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-stream", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{INPUT_STREAM_INDEX_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).build();
    public static final OperationDefinition DOMAIN_UPLOAD_STREAM_ATTACHMENT_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-stream", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{INPUT_STREAM_INDEX_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).build();
    public static final Map<String, AttributeDefinition> REPLACE_DEPLOYMENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(new AttributeDefinition[]{NAME, TO_REPLACE, CONTENT_ALL_NILLABLE, RUNTIME_NAME_NILLABLE});
    public static final OperationDefinition REPLACE_DEPLOYMENT_DEFINITION = new SimpleOperationDefinitionBuilder("replace-deployment", DEPLOYMENT_RESOLVER).setParameters(REPLACE_DEPLOYMENT_ATTRIBUTES.values().toArray(new AttributeDefinition[REPLACE_DEPLOYMENT_ATTRIBUTES.size()])).build();
    public static final Map<String, AttributeDefinition> SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(new AttributeDefinition[]{NAME, TO_REPLACE, RUNTIME_NAME_NILLABLE});
    public static final OperationDefinition SERVER_GROUP_REPLACE_DEPLOYMENT_DEFINITION = new SimpleOperationDefinitionBuilder("replace-deployment", DEPLOYMENT_RESOLVER).setParameters(SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES.values().toArray(new AttributeDefinition[SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES.size()])).build();
    public static final Map<String, AttributeDefinition> FULL_REPLACE_DEPLOYMENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(new AttributeDefinition[]{NAME, RUNTIME_NAME_NILLABLE, CONTENT_ALL});
    public static final OperationDefinition FULL_REPLACE_DEPLOYMENT_DEFINITION = new SimpleOperationDefinitionBuilder("full-replace-deployment", DEPLOYMENT_RESOLVER).setParameters(FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.values().toArray(new AttributeDefinition[FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.size()])).build();

    private static SimpleAttributeDefinition createContentValueTypeAttribute(String name, ModelType type, ParameterValidator validator, boolean allowExpression) {
        SimpleAttributeDefinitionBuilder builder = SimpleAttributeDefinitionBuilder.create((String)name, (ModelType)type, (boolean)true);
        if (validator != null) {
            builder.setValidator(validator);
        }
        builder.setAllowExpression(allowExpression);
        return builder.build();
    }

    private static Map<String, AttributeDefinition> createAttributeMap(AttributeDefinition ... defs) {
        HashMap<String, AttributeDefinition> map = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition def : defs) {
            map.put(def.getName(), def);
        }
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, AttributeDefinition> createAttributeMap(Map<String, AttributeDefinition> ... maps) {
        HashMap<String, AttributeDefinition> map = new HashMap<String, AttributeDefinition>();
        for (Map<String, AttributeDefinition> other : maps) {
            map.putAll(other);
        }
        return Collections.unmodifiableMap(map);
    }

    private static class ContentTypeValidator
    extends ParametersValidator {
        private ContentTypeValidator() {
        }

        public void validateParameter(String parameterName, ModelNode contentItemNode) throws OperationFailedException {
            HashSet<String> managedNames = new HashSet<String>();
            HashSet<String> unmanagedNames = new HashSet<String>();
            for (String name : contentItemNode.keys()) {
                if (!contentItemNode.hasDefined(name)) continue;
                if (MANAGED_CONTENT_ATTRIBUTES.containsKey(name)) {
                    managedNames.add(name);
                    continue;
                }
                if (UNMANAGED_CONTENT_ATTRIBUTES.containsKey(name)) {
                    unmanagedNames.add(name);
                    continue;
                }
                throw ServerMessages.MESSAGES.unknownContentItemKey(name);
            }
            if (managedNames.size() > 1) {
                throw ServerMessages.MESSAGES.cannotHaveMoreThanOneManagedContentItem(MANAGED_CONTENT_ATTRIBUTES.keySet());
            }
            if (unmanagedNames.size() > 0 && managedNames.size() > 0) {
                throw ServerMessages.MESSAGES.cannotMixUnmanagedAndManagedContentItems(managedNames, unmanagedNames);
            }
            if (unmanagedNames.size() > 0) {
                if (!unmanagedNames.contains(CONTENT_ARCHIVE.getName())) {
                    throw ServerMessages.MESSAGES.nullParameter(CONTENT_ARCHIVE.getName());
                }
                if (!unmanagedNames.contains(CONTENT_PATH.getName())) {
                    throw ServerMessages.MESSAGES.nullParameter(CONTENT_PATH.getName());
                }
            }
            for (String key : contentItemNode.keys()) {
                AttributeDefinition def = MANAGED_CONTENT_ATTRIBUTES.get(key);
                if (def == null) {
                    def = UNMANAGED_CONTENT_ATTRIBUTES.get(key);
                }
                if (def == null) continue;
                def.validateOperation(contentItemNode);
            }
        }
    }

    private static class HashValidator
    extends ModelTypeValidator
    implements MinMaxValidator {
        public HashValidator(boolean nillable) {
            super(ModelType.BYTES, nillable);
        }

        public Long getMin() {
            return 20L;
        }

        public Long getMax() {
            return 20L;
        }
    }
}

