/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;

public class DeploymentFullReplaceHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "full-replace-deployment";
    protected final ContentRepository contentRepository;
    private final AbstractVaultReader vaultReader;

    protected DeploymentFullReplaceHandler(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.vaultReader = vaultReader;
    }

    public static DeploymentFullReplaceHandler create(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        return new DeploymentFullReplaceHandler(contentRepository, vaultReader);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode contentNode;
        DeploymentHandlerUtil.ContentItem contentItem;
        byte[] originalHash;
        for (AttributeDefinition def : DeploymentAttributes.FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.values()) {
            def.validateOperation(operation);
        }
        final String name = DeploymentAttributes.FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.get("name").resolveModelAttribute(context, operation).asString();
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)});
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        boolean exists = root.hasChild(PathElement.pathElement((String)"deployment", (String)name));
        if (!exists) {
            throw ServerMessages.MESSAGES.noSuchDeployment(name);
        }
        ModelNode replaceNode = context.readResourceForUpdate(address).getModel();
        String replacedRuntimeName = DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, replaceNode).asString();
        String runtimeName = operation.hasDefined(DeploymentAttributes.RUNTIME_NAME.getName()) ? operation.get(DeploymentAttributes.RUNTIME_NAME.getName()).asString() : name;
        ModelNode content = operation.require("content").clone();
        ModelNode contentItemNode = content.require(0);
        byte[] byArray = originalHash = replaceNode.get("content").get(0).hasDefined(DeploymentAttributes.CONTENT_HASH.getName()) ? DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, replaceNode.get("content").get(0)).asBytes() : null;
        if (contentItemNode.hasDefined(DeploymentAttributes.CONTENT_HASH.getName())) {
            byte[] hash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItemNode).asBytes();
            contentItem = this.addFromHash(hash);
        } else if (DeploymentHandlerUtils.hasValidContentAdditionParameterDefined(contentItemNode)) {
            contentItem = this.addFromContentAdditionParameter(context, contentItemNode);
            contentItemNode = new ModelNode();
            contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(contentItem.getHash());
            content.clear();
            content.add(contentItemNode);
        } else {
            contentItem = this.addUnmanaged(context, contentItemNode);
        }
        ModelNode deployNode = context.readResourceForUpdate(address).getModel();
        DeploymentFullReplaceHandler.removeContentAdditions(deployNode.require("content"));
        deployNode.get("name").set(name);
        deployNode.get(DeploymentAttributes.RUNTIME_NAME.getName()).set(runtimeName);
        deployNode.get("content").set(content);
        DeploymentAttributes.ENABLED.validateAndSet(deployNode, replaceNode);
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, replaceNode).asBoolean()) {
            DeploymentHandlerUtil.replace(context, replaceNode, runtimeName, name, replacedRuntimeName, this.vaultReader, contentItem);
        }
        final byte[] newHash = (contentNode = replaceNode.get("content").get(0)).hasDefined(DeploymentAttributes.CONTENT_HASH.getName()) ? DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentNode).asBytes() : null;
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    if (originalHash != null && newHash != null && !Arrays.equals(originalHash, newHash)) {
                        DeploymentFullReplaceHandler.this.contentRepository.removeContent(originalHash, (Object)name);
                        if (DeploymentFullReplaceHandler.this.contentRepository != null && newHash != null) {
                            DeploymentFullReplaceHandler.this.contentRepository.addContentReference(newHash, (Object)name);
                        }
                    }
                } else if (newHash != null) {
                    DeploymentFullReplaceHandler.this.contentRepository.removeContent(newHash, (Object)name);
                }
            }
        });
    }

    private static void removeAttributes(ModelNode node, Iterable<String> attributeNames) {
        for (String attributeName : attributeNames) {
            node.remove(attributeName);
        }
    }

    private static void removeContentAdditions(ModelNode content) {
        for (ModelNode contentItem : content.asList()) {
            DeploymentFullReplaceHandler.removeAttributes(contentItem, DeploymentAttributes.ALL_CONTENT_ATTRIBUTES.keySet());
        }
    }

    DeploymentHandlerUtil.ContentItem addFromHash(byte[] hash) throws OperationFailedException {
        if (!this.contentRepository.syncContent(hash)) {
            throw ServerMessages.MESSAGES.noSuchDeploymentContent(HashUtil.bytesToHexString((byte[])hash));
        }
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeploymentHandlerUtil.ContentItem addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        byte[] hash;
        InputStream in = DeploymentHandlerUtils.getInputStream(context, contentItemNode);
        try {
            try {
                hash = this.contentRepository.addContent(in);
            }
            catch (IOException e) {
                throw DeploymentHandlerUtils.createFailureException(e.toString());
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
        contentItemNode.clear();
        contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(hash);
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    DeploymentHandlerUtil.ContentItem addUnmanaged(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        String path = DeploymentAttributes.CONTENT_PATH.resolveModelAttribute(context, contentItemNode).asString();
        String relativeTo = DeploymentHandlerUtils.asString(contentItemNode, DeploymentAttributes.CONTENT_RELATIVE_TO.getName());
        boolean archive = DeploymentAttributes.CONTENT_ARCHIVE.resolveModelAttribute(context, contentItemNode).asBoolean();
        return new DeploymentHandlerUtil.ContentItem(path, relativeTo, archive);
    }
}

