/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import jakarta.ejb.TransactionAttribute;
import jakarta.jws.WebService;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class XTSDependenciesDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier XTS_MODULE = ModuleIdentifier.create((String)"org.jboss.xts");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        CompositeIndex compositeIndex = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        if (this.isTransactionalEndpointPresent(compositeIndex)) {
            this.addXTSModuleDependency(unit);
        }
    }

    private boolean isTransactionalEndpointPresent(CompositeIndex compositeIndex) {
        ArrayList annotations = new ArrayList();
        annotations.addAll(compositeIndex.getAnnotations(DotName.createSimple((String)Transactional.class.getName())));
        annotations.addAll(compositeIndex.getAnnotations(DotName.createSimple((String)TransactionAttribute.class.getName())));
        for (AnnotationInstance annotation : annotations) {
            ClassInfo classInfo;
            AnnotationTarget target = annotation.target();
            if (!(target instanceof ClassInfo) || (classInfo = (ClassInfo)target).annotationsMap().get(DotName.createSimple((String)WebService.class.getName())) == null) continue;
            return true;
        }
        return false;
    }

    private void addXTSModuleDependency(DeploymentUnit unit) {
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, XTS_MODULE, false, false, false, false));
    }
}

