/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.TextFile;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import wiremock.com.google.common.io.Resources;

public class ClasspathFileSource
implements FileSource {
    private final String path;
    private final ClassLoader classLoader;
    private URI pathUri;
    private ZipFile zipFile;
    private File rootDirectory;

    public ClasspathFileSource(String path) {
        this((ClassLoader)null, path);
    }

    public ClasspathFileSource(Class<?> classpath, String path) {
        this(classpath.getClassLoader(), path);
    }

    public ClasspathFileSource(ClassLoader classLoader, String path) {
        block5: {
            this.path = path;
            this.classLoader = classLoader;
            try {
                URL resource = this.getClassLoader().getResource(path);
                if (resource == null) {
                    this.rootDirectory = new File(path);
                    this.pathUri = this.rootDirectory.toURI();
                    return;
                }
                this.pathUri = resource.toURI();
                if (Arrays.asList("jar", "war", "ear", "zip").contains(this.pathUri.getScheme())) {
                    String jarFileUri = this.pathUri.getSchemeSpecificPart().split("!")[0];
                    String jarFilePath = jarFileUri.replace("file:", "");
                    File file = new File(jarFilePath);
                    this.zipFile = new ZipFile(file);
                    break block5;
                }
                if (this.pathUri.getScheme().equals("file")) {
                    this.rootDirectory = new File(this.pathUri);
                    break block5;
                }
                throw new IllegalArgumentException("ClasspathFileSource can't handle paths of type " + this.pathUri.getScheme());
            }
            catch (Exception e) {
                Exceptions.throwUnchecked(e);
            }
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return ParameterUtils.getFirstNonNull(Thread.currentThread().getContextClassLoader(), Resources.class.getClassLoader());
    }

    private boolean isFileSystem() {
        return this.rootDirectory != null;
    }

    @Override
    public BinaryFile getBinaryFileNamed(String name) {
        if (this.isFileSystem()) {
            return new BinaryFile(new File(this.rootDirectory, name).toURI());
        }
        return new BinaryFile(this.getZipEntryUri(name));
    }

    @Override
    public TextFile getTextFileNamed(String name) {
        if (this.isFileSystem()) {
            return new TextFile(new File(this.rootDirectory, name).toURI());
        }
        return new TextFile(this.getZipEntryUri(name));
    }

    private URI getZipEntryUri(String name) {
        String lookFor = this.path + "/" + name;
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        StringBuilder candidates = new StringBuilder();
        while (enumeration.hasMoreElements()) {
            ZipEntry candidate = enumeration.nextElement();
            if (candidate.getName().equals(lookFor)) {
                return this.getUriFor(candidate);
            }
            candidates.append(candidate.getName()).append("\n");
        }
        throw new RuntimeException("Was unable to find entry: \"" + lookFor + "\", found:\n" + candidates);
    }

    @Override
    public void createIfNecessary() {
    }

    @Override
    public FileSource child(String subDirectoryName) {
        return new ClasspathFileSource(this.classLoader, this.path + "/" + subDirectoryName);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public URI getUri() {
        return this.pathUri;
    }

    @Override
    public List<TextFile> listFilesRecursively() {
        if (this.isFileSystem()) {
            this.assertExistsAndIsDirectory();
            ArrayList<File> fileList = new ArrayList<File>();
            this.recursivelyAddFilesToList(this.rootDirectory, fileList);
            return this.toTextFileList(fileList);
        }
        return this.zipFile.stream().filter(jarEntry -> !jarEntry.isDirectory() && jarEntry.getName().startsWith(this.path)).map(jarEntry -> new TextFile(this.getUriFor((ZipEntry)jarEntry))).collect(Collectors.toList());
    }

    private URI getUriFor(ZipEntry jarEntry) {
        try {
            return Resources.getResource(jarEntry.getName()).toURI();
        }
        catch (URISyntaxException e) {
            return Exceptions.throwUnchecked(e, URI.class);
        }
    }

    private void recursivelyAddFilesToList(File root, List<File> fileList) {
        File[] files;
        for (File file : files = Optional.ofNullable(root.listFiles()).orElse(new File[0])) {
            if (file.isDirectory()) {
                this.recursivelyAddFilesToList(file, fileList);
                continue;
            }
            fileList.add(file);
        }
    }

    private List<TextFile> toTextFileList(List<File> fileList) {
        return fileList.stream().map(input -> new TextFile(input.toURI())).collect(Collectors.toList());
    }

    @Override
    public void writeTextFile(String name, String contents) {
    }

    @Override
    public void writeBinaryFile(String name, byte[] contents) {
    }

    @Override
    public boolean exists() {
        return this.isFileSystem() && this.rootDirectory.exists() || !this.isFileSystem();
    }

    @Override
    public void deleteFile(String name) {
    }

    private void assertExistsAndIsDirectory() {
        if (this.rootDirectory.exists() && !this.rootDirectory.isDirectory()) {
            throw new RuntimeException(this.rootDirectory + " is not a directory");
        }
        if (!this.rootDirectory.exists()) {
            throw new RuntimeException(this.rootDirectory + " does not exist");
        }
    }
}

