/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.Objects;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class EqualToPattern
extends StringValuePattern {
    private final Boolean caseInsensitive;

    public EqualToPattern(@JsonProperty(value="equalTo") String testValue, @JsonProperty(value="caseInsensitive") Boolean caseInsensitive) {
        super(testValue);
        this.caseInsensitive = caseInsensitive;
    }

    public EqualToPattern(String expectedValue) {
        this(expectedValue, null);
    }

    public String getEqualTo() {
        return (String)this.expectedValue;
    }

    public Boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public MatchResult match(final String value) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                return EqualToPattern.this.shouldMatchCaseInsensitive() ? value != null && value.equalsIgnoreCase((String)EqualToPattern.this.expectedValue) : Objects.equals(EqualToPattern.this.expectedValue, value);
            }

            @Override
            public double getDistance() {
                return Strings.normalisedLevenshteinDistance((String)EqualToPattern.this.expectedValue, value);
            }
        };
    }

    private boolean shouldMatchCaseInsensitive() {
        return this.caseInsensitive != null && this.caseInsensitive != false;
    }
}

