/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.integration.ballerina.autogen;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.SnippetBlock;

public class SnippetsContent {
    private SnippetsContent() {
    }

    public static SnippetBlock getStoreForwardMessageProcessor() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"storeforward");
        String snippet = "\nstoreforward:MessageStoreConfiguration ${1:storeConfig} = {\n    messageBroker: \"${2:ACTIVE_MQ}\",\n    providerUrl: \"${3:tcp://localhost:61616}\",\n    queueName: \"${4:queue_name}\"\n};\nstoreforward:ForwardingProcessorConfiguration ${5:processorConfig} = {\n    storeConfig: ${6:storeConfig},\n    HttpEndpointUrl: \"${7:http://localhost:9000/services/SimpleStockQuoteService}\",\n    pollTimeConfig: 1000,\n    retryInterval: 3000,\n    maxRedeliveryAttempts: 5\n};\nstoreforward:MessageForwardingProcessor ${8:forwardingProcessor} = check new storeforward:MessageForwardingProcessor(${9:processorConfig}, ${10:handleResponse});\nfunction ${11:handleResponse}(http:Response ${12:response}) {\n    int ${13:statusCode} = ${14:response}.statusCode;\n    if (${15:statusCode} == http:STATUS_OK) {\n        log:printInfo(\"Successful\");\n    } else {\n        log:printError(\"Error: \" + ${16:statusCode}.toString());\n    }\n}";
        return new SnippetBlock("storeforward/message_processor", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getSAPClient() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"sap");
        String snippet = "\nsap:ProducerConfig ${1:sapProducerConfig} = {\n    destinationName: \"${2:destination_name}\",\n    sapclient: \"${3:sap_client}\",\n    username: \"${4:username}\",\n    password: \"${5:password}\",\n    ashost: \"${6:ashost}\",\n    sysnr: \"${7:sysnr}\",\n    language: \"${8:language}\"\n};\nsap:Producer ${9:sapProducer} = new (${10:sapProducerConfig});";
        return new SnippetBlock("client/sap", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getSAPService() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"sap");
        String snippet = "\nservice ${1:sapConsumer} on ${2:sapListener} {\n   resource function onMessage(string ${3:message}) {\n       io:println(\"Message received from SAP: \" + ${4:message});\n   }\n}";
        return new SnippetBlock("service/sap", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getGmailClient() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"gmail");
        String snippet = "\ngmail:GmailConfiguration ${1:gmailConfig} = {\n    oauthClientConfig: {\n        accessToken: \"${2:access_token}\",\n        refreshConfig: {\n            refreshUrl: gmail:REFRESH_URL,\n            refreshToken: \"${3:refresh_token}\",\n            clientId: \"${4:client_id}\",\n            clientSecret: \"${5:client_secret}\"\n        }\n    }\n};\ngmail:Client ${6:gmailClient} = new (${7:gmailConfig});";
        return new SnippetBlock("client/gmail", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getFTPListener() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"ftp");
        String snippet = "\nlistener ftp:Listener ${1:ftpListener} = new({\n    protocol: ftp:FTP,\n    host: \"${2:ftp_host}\",\n    secureSocket: {\n        basicAuth: {\n            username: \"${3:ftp_username}\",\n            password: \"${4:ftp_password}\"\n        }\n    },\n    port: ${5:ftp_port},\n    path: \"${6:remote_ftp_directory_location}\",\n    pollingInterval: ${7:polling_interval},\n    fileNamePattern: \"${8:file_type}\"\n});";
        return new SnippetBlock("listener/ftp", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getSMBService() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"smb");
        String snippet = "\nservice ${1:smbServerConnector} on ${2:smbListener} {\n    resource function onFileChange(3:smb:WatchEvent ${4:fileEvent}) {\n        foreach smb:FileInfo ${5:addedFile} in ${6:fileEvent}.addedFiles {\n            log:printInfo(\"Added file path: \" + ${7:addedFile}.path);\n        }\n        foreach string ${8:deletedFile} in ${9:fileEvent}.deletedFiles {\n            log:printInfo(\"Deleted file path: \" + ${10:deletedFile});\n        }\n    }\n}";
        return new SnippetBlock("service/smb", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getFTPClient() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"ftp");
        String snippet = "\nftp:ClientEndpointConfig ${1:ftpConfig} = {\n    protocol: ftp:FTP,\n    host: \"${2:ftp_host}\",\n    port: ${3:ftp_port},\n    secureSocket: {\n        basicAuth: {\n            username: \"${4:ftp_username}\",\n            password: \"${5:ftp_password}\"\n        }\n    }\n};\nftp:Client ${6:ftpClient} = new(${7:ftpConfig});";
        return new SnippetBlock("client/ftp", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getSAPListener() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"sap");
        String snippet = "\nsap:ConsumerServerConfig ${serverConfig} = {\n    transportName: <sap:Transport>\"${1:transport_name}\",\n    serverName: \"${2:server_name}\",\n    gwhost: \"${3:gwhost}\",\n    progid: \"${4:progid}\",\n    repositorydestination: \"${5:repository_destination}\",\n    gwserv: \"${6:gwserv}\",\n    unicode: <sap:Value>\"${7:unicode}\"\n};\nsap:ConsumerDestinationConfig ${8:destinationConfig} = {\n    sapclient: \"${9:sap_client}\",\n    username: \"${10:username}\",\n    password: \"${11:password}\",\n    ashost: \"${12:ashost}\",\n    sysnr: \"${13:sysnr}\",\n    language: \"${14:language}\"\n};\nlistener sap:Listener ${15:sapListener} = new (${16:serverConfig}, ${17:destinationConfig});";
        return new SnippetBlock("listener/sap", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getSMBClient() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"smb");
        String snippet = "\nsmb:ClientEndpointConfig ${1:smbConfig} = {\n    protocol: smb:SMB,\n    host: \"${2:smb_host}\",\n    port: ${3:smb_port},\n    secureSocket: {\n        basicAuth: {\n            username: \"${4:smb_username}\",\n            password: \"${5:smb_password}\"\n        }\n    }\n};\nsmb:Client ${6:smbClient} = new(${7:smbConfig});";
        return new SnippetBlock("client/smb", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getJMSMessageConsumer() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"jms");
        String snippet = "\njms:Connection ${1:connection} = check jms:createConnection({\n    initialContextFactory: \"${org.apache.activemq.jndi.ActiveMQInitialContextFactory}\",\n    providerUrl: \"${tcp://localhost:61616}\"\n});\njms:Session ${2:session} = check ${3:connection}->createSession({acknowledgementMode: \"${4:AUTO_ACKNOWLEDGE}\"});\njms:Destination ${5:topic} = check ${6:session}->createTopic(\"${7:MyTopic}\");\nlistener jms:MessageConsumer ${8:jmsConsumer} = check ${9:session}->createConsumer(${10:topic});\nservice ${11:messageListener} on ${12:jmsConsumer} {\n    resource function onMessage(jms:Message message) {\n    }\n}";
        return new SnippetBlock("jms/message_consumer", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getJMSDurableSubscriber() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"jms");
        String snippet = "\njms:Connection ${1:connection} = check jms:createConnection({\n    initialContextFactory: \"${org.apache.activemq.jndi.ActiveMQInitialContextFactory}\",\n    providerUrl: \"${tcp://localhost:61616}\"\n});\njms:Session ${2:session} = check ${3:connection}->createSession({acknowledgementMode: \"${4:AUTO_ACKNOWLEDGE}\"});\njms:Destination ${5:topic} = check ${6:session}->createTopic(\"${7:topic_name}\");\nlistener jms:MessageConsumer ${8:jmsConsumer} = check session->createDurableSubscriber(${9:topic}, \"${10:subscription_name}\");\nservice ${11:messageListener} on ${12:jmsConsumer} {\n    resource function onMessage(jms:Message ${13:message}) {\n    }\n}";
        return new SnippetBlock("jms/durable_subscriber", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getStoreForwardMessageStore() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"storeforward");
        String snippet = "\nstoreforward:MessageStoreConfiguration ${1:storeConfig} = {\n    messageBroker: \"${2:ACTIVE_MQ}\",\n    providerUrl: \"${3:tcp://localhost:61616}\",\n    queueName: \"${4:queue_name}\"\n};\nstoreforward:Client ${5:storeClient} = check new storeforward:Client(${6:storeConfig});";
        return new SnippetBlock("storeforward/message_store", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getAmazonS3Client() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"amazons3");
        String snippet = "\namazons3:ClientConfiguration ${1:amazonS3Config} = {\n    accessKeyId: \"${2:access_key_id}\",\n    secretAccessKey: \"${3:secret_access_key}\",\n    region: \"${4:region}\"\n};\namazons3:AmazonS3Client|amazons3:ConnectorError ${5:amazonS3Client} = new(${6:amazonS3Config});";
        return new SnippetBlock("client/amazons3", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getJDBCClient() {
        ImmutablePair imports0 = new ImmutablePair((Object)"ballerinax", (Object)"java.jdbc");
        String snippet = "\njdbc:Client ${1:jdbcClient} = new ({\n    url: \"${2:jdbc_url}\",\n    username: \"${3:username}\",\n    password: \"${4:password}\",\n    poolOptions: { maximumPoolSize: 5 },\n    dbOptions: { useSSL: false }\n});";
        return new SnippetBlock("client/jdbc", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getSalesforceClient() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"sfdc46");
        String snippet = "\nsfdc46:SalesforceConfiguration ${1:salesforceConfig} = {\n    baseUrl: \"${2:baseUrl}\",\n    clientConfig: {\n        accessToken: \"${3:access_token}\",\n        refreshConfig: {\n            clientId: \"${4:client_id}\",\n            clientSecret: \"${5:client_secret}\",\n            refreshToken: \"${6:refresh_token}\",\n            refreshUrl: \"${7:refresh_url}\"\n        }\n    }\n};\nsfdc46:Client ${8:salesforceClient} = new(${9:salesforceConfig});";
        return new SnippetBlock("client/salesforce", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getAmazonSQSClient() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"amazonsqs");
        String snippet = "\namazonsqs:Configuration ${1:sqsConfig} = {\n    accessKey: \"${2:access_key_id}\",\n    secretKey: \"${3:secret_access_key}\",\n    region: \"${4:region}\",\n    accountNumber: \"${5:account_number}\"\n};\namazonsqs:Client ${6:sqsClient} = new(${7:sqsConfig});";
        return new SnippetBlock("client/amazonsqs", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getGSheetClient() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"gsheets4");
        String snippet = "\ngsheets4:SpreadsheetConfiguration ${1:spreadsheetConfig} = {\n    oAuthClientConfig: {\n        accessToken: \"${2:access_token}\",\n        refreshConfig: {\n            clientId: \"${3:client_id}\",\n            clientSecret: \"${4:client_secret}\"\n            refreshUrl: \"${5:refresh_url}\",\n            refreshToken: \"${6:refresh_token}\"\n        }\n    }\n};\ngsheets4:Client ${7:spreadsheetClient} = new (${8:spreadsheetConfig});";
        return new SnippetBlock("client/gsheet", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getSMBListener() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"smb");
        String snippet = "\nlistener smb:Listener ${1:smbListener} = new({\n     protocol: smb:SMB,\n     host: \"${2:smb_host}\",\n     secureSocket: {\n         basicAuth: {\n             username: \"${3:smb_username}\",\n             password: \"${4:smb_password}\"\n         }\n     },\n     port: ${5:smb_port},\n     path: \"${6:remote_smb_directory_location}\",\n     pollingInterval: ${7:polling_interval},\n     fileNamePattern: \"${8:file_type}\"\n });";
        return new SnippetBlock("listener/smb", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getFTPService() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"ftp");
        String snippet = "\nservice ${1:ftpServerConnector} on ${2:ftpListener} {\n    resource function onFileChange(ftp:WatchEvent ${3:fileEvent}) {\n        foreach ftp:FileInfo ${4:addedFile} in ${5:fileEvent}.addedFiles {\n            log:printInfo(\"Added file path: \" + ${6:addedFile}.path);\n        }\n        foreach string ${7:deletedFile} in ${8:fileEvent}.deletedFiles {\n            log:printInfo(\"Deleted file path: \" + ${9:deletedFile});\n        }\n    }\n}";
        return new SnippetBlock("service/ftp", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }

    public static SnippetBlock getMongoDBClient() {
        ImmutablePair imports0 = new ImmutablePair((Object)"wso2", (Object)"mongodb");
        String snippet = "\nmongodb:Client ${1:mongodbClient} = new({\n    host: \"${2:host}\",\n    dbName: \"${3:database_name}\",\n    username: \"${4:username}\",\n    password: \"${5:password}\",\n    options: { sslEnabled: false, serverSelectionTimeout: 500 }\n});";
        return new SnippetBlock("client/mongodb", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{imports0});
    }
}

