/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.agents.memory;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;

public class SizingAgent {
    private static Instrumentation instrumentation;

    public static void premain(String options, Instrumentation instrumentation) {
        SizingAgent.instrumentation = instrumentation;
        Class[] loaded = instrumentation.getAllLoadedClasses();
    }

    public static void main(String[] args) {
        System.out.println("Size of Object: " + SizingAgent.sizeOf(new Object()));
        System.out.println("Size of direct subclass: " + SizingAgent.sizeOf(new SizingAgent()));
        System.out.println("Size of Calendar: " + SizingAgent.sizeOf(Calendar.getInstance()));
    }

    public static long sizeOf(Object obj) {
        if (instrumentation == null) {
            return 0L;
        }
        if (SizingAgent.isSharedFlyweight(obj)) {
            return 0L;
        }
        return instrumentation.getObjectSize(obj);
    }

    public static long deepSizeOf(Object obj) {
        if (instrumentation == null) {
            return 0L;
        }
        IdentityHashMap visited = new IdentityHashMap();
        Stack<Object> stack = new Stack<Object>();
        stack.push(obj);
        long result = 0L;
        do {
            result += SizingAgent.internalSizeOf(stack.pop(), stack, visited);
        } while (!stack.isEmpty());
        return result;
    }

    private static boolean isSharedFlyweight(Object obj) {
        if (obj instanceof Comparable) {
            if (obj instanceof Enum) {
                return true;
            }
            if (obj instanceof String) {
                return obj == ((String)obj).intern();
            }
            if (obj instanceof Boolean) {
                return obj == Boolean.TRUE || obj == Boolean.FALSE;
            }
            if (obj instanceof Integer) {
                return obj == Integer.valueOf((Integer)obj);
            }
            if (obj instanceof Short) {
                return obj == Short.valueOf((Short)obj);
            }
            if (obj instanceof Byte) {
                return obj == Byte.valueOf((Byte)obj);
            }
            if (obj instanceof Long) {
                return obj == Long.valueOf((Long)obj);
            }
            if (obj instanceof Character) {
                return obj == Character.valueOf(((Character)obj).charValue());
            }
        }
        return false;
    }

    private static boolean skipObject(Object obj, Map visited) {
        return obj == null || visited.containsKey(obj) || SizingAgent.isSharedFlyweight(obj);
    }

    private static long internalSizeOf(Object obj, Stack stack, Map visited) {
        if (SizingAgent.skipObject(obj, visited)) {
            return 0L;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            SizingAgent.addArrayElementsToStack(clazz, obj, stack);
        } else {
            while (clazz != null) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
                    field.setAccessible(true);
                    try {
                        stack.add(field.get(obj));
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        visited.put(obj, null);
        return SizingAgent.sizeOf(obj);
    }

    private static void addArrayElementsToStack(Class clazz, Object obj, Stack stack) {
        if (!clazz.getComponentType().isPrimitive()) {
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                stack.add(Array.get(obj, i));
            }
        }
    }
}

