/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.hooks;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.epr.EndpointFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.epr.WSAEndpoint;
import org.apache.ode.utils.Namespaces;

public class SessionOutHandler
extends AbstractHandler {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(SessionOutHandler.class);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        if (messageContext.isPropertyTrue("disableAddressingForOutMessages")) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Skipped WS-Adressing Headers for sessions");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        org.apache.ode.bpel.iapi.EndpointReference otargetSession = (org.apache.ode.bpel.iapi.EndpointReference)messageContext.getProperty("targetSessionEndpoint");
        org.apache.ode.bpel.iapi.EndpointReference ocallbackSession = (org.apache.ode.bpel.iapi.EndpointReference)messageContext.getProperty("callbackSessionEndpoint");
        if (otargetSession == null) {
            otargetSession = (org.apache.ode.bpel.iapi.EndpointReference)messageContext.getOptions().getProperty("targetSessionEndpoint");
        }
        if (ocallbackSession == null) {
            ocallbackSession = (org.apache.ode.bpel.iapi.EndpointReference)messageContext.getOptions().getProperty("callbackSessionEndpoint");
        }
        if (otargetSession != null || ocallbackSession != null) {
            SOAPHeader header = messageContext.getEnvelope().getHeader();
            SOAPFactory factory = (SOAPFactory)messageContext.getEnvelope().getOMFactory();
            OMNamespace intalioSessNS = factory.createOMNamespace(Namespaces.INTALIO_SESSION_NS, "intalio");
            OMNamespace odeSessNS = factory.createOMNamespace(Namespaces.ODE_SESSION_NS, "odesession");
            OMNamespace wsAddrNS = factory.createOMNamespace(Namespaces.WS_ADDRESSING_NS, "addr");
            if (header == null) {
                header = factory.createSOAPHeader(messageContext.getEnvelope());
            }
            if (otargetSession != null && otargetSession instanceof MutableEndpoint) {
                WSAEndpoint targetEpr = EndpointFactory.convertToWSA((MutableEndpoint)((MutableEndpoint)otargetSession));
                SOAPHeaderBlock to = factory.createSOAPHeaderBlock("To", wsAddrNS);
                header.addChild((OMNode)to);
                to.setText(targetEpr.getUrl());
                String action = messageContext.getSoapAction();
                SOAPHeaderBlock wsaAction = factory.createSOAPHeaderBlock("Action", wsAddrNS);
                header.addChild((OMNode)wsaAction);
                wsaAction.setText(action);
                EndpointReference replyToEpr = messageContext.getReplyTo();
                if (replyToEpr != null) {
                    SOAPHeaderBlock replyTo = factory.createSOAPHeaderBlock("ReplyTo", wsAddrNS);
                    OMElement address = factory.createOMElement("Address", wsAddrNS);
                    replyTo.addChild((OMNode)address);
                    header.addChild((OMNode)replyTo);
                    address.setText(replyToEpr.getAddress());
                    String messageId = messageContext.getMessageID();
                    SOAPHeaderBlock messageIdElem = factory.createSOAPHeaderBlock("MessageID", wsAddrNS);
                    header.addChild((OMNode)messageIdElem);
                    messageIdElem.setText(messageId);
                }
                if (targetEpr.getSessionId() != null) {
                    SOAPHeaderBlock session = factory.createSOAPHeaderBlock("session", odeSessNS);
                    header.addChild((OMNode)session);
                    session.setText(targetEpr.getSessionId());
                    session = factory.createSOAPHeaderBlock("session", intalioSessNS);
                    header.addChild((OMNode)session);
                    session.setText(targetEpr.getSessionId());
                }
                __log.debug((Object)("Sending stateful TO epr in message header using session " + targetEpr.getSessionId()));
            }
            if (ocallbackSession != null && ocallbackSession instanceof MutableEndpoint) {
                WSAEndpoint callbackEpr = EndpointFactory.convertToWSA((MutableEndpoint)((MutableEndpoint)ocallbackSession));
                SOAPHeaderBlock odeCallback = factory.createSOAPHeaderBlock("callback", odeSessNS);
                SOAPHeaderBlock intCallback = factory.createSOAPHeaderBlock("callback", intalioSessNS);
                header.addChild((OMNode)odeCallback);
                header.addChild((OMNode)intCallback);
                OMElement address = factory.createOMElement("Address", wsAddrNS);
                odeCallback.addChild((OMNode)address);
                intCallback.addChild((OMNode)address.cloneOMElement());
                address.setText(callbackEpr.getUrl());
                if (callbackEpr.getSessionId() != null) {
                    OMElement odeSession = factory.createOMElement("session", odeSessNS);
                    OMElement intSession = factory.createOMElement("session", intalioSessNS);
                    odeSession.setText(callbackEpr.getSessionId());
                    intSession.setText(callbackEpr.getSessionId());
                    odeCallback.addChild((OMNode)odeSession);
                    intCallback.addChild((OMNode)intSession);
                }
                __log.debug((Object)("Sending stateful FROM epr in message header using session " + callbackEpr.getSessionId()));
            }
            __log.debug((Object)"Sending a message containing wsa endpoints in headers for session passing.");
            __log.debug((Object)messageContext.getEnvelope().toString());
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

