/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.OdeFault;
import org.apache.ode.il.OMUtils;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.wsdl.Messages;
import org.apache.ode.utils.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMessageConverter {
    private static final Messages __msgs = (Messages)Messages.getMessages(Messages.class);
    private static final Log __log = LogFactory.getLog(SoapMessageConverter.class);
    SOAPFactory _soapFactory;
    Definition _def;
    QName _serviceName;
    String _portName;
    Service _serviceDef;
    Binding _binding;
    Port _port;
    boolean _isRPC;
    private SOAPBinding _soapBinding;

    public SoapMessageConverter(Definition def, QName serviceName, String portName) throws AxisFault {
        if (def == null) {
            throw new NullPointerException("No WSDL definition was found for service " + serviceName + " and port " + portName);
        }
        this._def = def;
        this._serviceName = serviceName;
        this._portName = portName;
        this._serviceDef = this._def.getService(serviceName);
        if (this._serviceDef == null) {
            throw new OdeFault(__msgs.msgServiceDefinitionNotFound(serviceName));
        }
        this._port = this._serviceDef.getPort(portName);
        if (this._port == null) {
            throw new OdeFault(__msgs.msgPortDefinitionNotFound(serviceName, portName));
        }
        this._binding = this._port.getBinding();
        if (this._binding == null) {
            throw new OdeFault(__msgs.msgBindingNotFound(portName));
        }
        try {
            if (!WsdlUtils.useSOAPBinding((Port)this._port)) {
                throw new OdeFault(__msgs.msgNoSOAPBindingForPort(this._portName));
            }
            this._soapBinding = (SOAPBinding)WsdlUtils.getBindingExtension((Port)this._port);
        }
        catch (IllegalArgumentException iae) {
            throw new OdeFault(iae);
        }
        String style = this._soapBinding.getStyle();
        boolean bl = this._isRPC = style != null && style.equals("rpc");
        if (this._soapBinding.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
            this._soapFactory = OMAbstractFactory.getSOAP11Factory();
        } else if (this._soapBinding.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/")) {
            this._soapFactory = OMAbstractFactory.getSOAP12Factory();
        } else {
            throw new IllegalStateException("Unsupported SOAP binding: " + this._soapBinding.getElementType());
        }
    }

    public void createSoapRequest(MessageContext msgCtx, org.apache.ode.bpel.iapi.Message message, Operation op) throws AxisFault {
        if (op == null) {
            throw new NullPointerException("Null operation");
        }
        if (op.getInput().getMessage().getParts().size() > 0 && message == null) {
            throw new NullPointerException("Null message.");
        }
        if (msgCtx == null) {
            throw new NullPointerException("Null msgCtx");
        }
        BindingOperation bop = this._binding.getBindingOperation(op.getName(), null, null);
        if (bop == null) {
            throw new OdeFault(__msgs.msgBindingOperationNotFound(this._serviceName, this._portName, op.getName()));
        }
        BindingInput bi = bop.getBindingInput();
        if (bi == null) {
            throw new OdeFault(__msgs.msgBindingInputNotFound(this._serviceName, this._portName, op.getName()));
        }
        SOAPEnvelope soapEnv = msgCtx.getEnvelope();
        if (soapEnv == null) {
            soapEnv = this._soapFactory.getDefaultEnvelope();
            msgCtx.setEnvelope(soapEnv);
        }
        this.createSoapHeaders(soapEnv, SoapMessageConverter.getSOAPHeaders((ElementExtensible)bi), op.getInput().getMessage(), message.getHeaderParts());
        SOAPBody soapBody = SoapMessageConverter.getSOAPBody((ElementExtensible)bi);
        if (soapBody != null) {
            org.apache.axiom.soap.SOAPBody sb = soapEnv.getBody() == null ? this._soapFactory.createSOAPBody(soapEnv) : soapEnv.getBody();
            this.createSoapBody(sb, soapBody, op.getInput().getMessage(), message.getMessage(), op.getName());
        }
    }

    public void createSoapResponse(MessageContext msgCtx, org.apache.ode.bpel.iapi.Message message, Operation op) throws AxisFault {
        SOAPBody soapBody;
        if (op == null) {
            throw new NullPointerException("Null operation");
        }
        if (message == null) {
            throw new NullPointerException("Null message.");
        }
        if (msgCtx == null) {
            throw new NullPointerException("Null msgCtx");
        }
        BindingOperation bop = this._binding.getBindingOperation(op.getName(), null, null);
        if (bop == null) {
            throw new OdeFault(__msgs.msgBindingOperationNotFound(this._serviceName, this._portName, op.getName()));
        }
        BindingOutput bo = bop.getBindingOutput();
        if (bo == null) {
            throw new OdeFault(__msgs.msgBindingOutputNotFound(this._serviceName, this._portName, op.getName()));
        }
        SOAPEnvelope soapEnv = msgCtx.getEnvelope();
        if (soapEnv == null) {
            soapEnv = this._soapFactory.getDefaultEnvelope();
            msgCtx.setEnvelope(soapEnv);
        }
        if (message.getHeaderParts().size() > 0 || SoapMessageConverter.getSOAPHeaders((ElementExtensible)bo).size() > 0) {
            this.createSoapHeaders(soapEnv, SoapMessageConverter.getSOAPHeaders((ElementExtensible)bo), op.getOutput().getMessage(), message.getHeaderParts());
        }
        if ((soapBody = SoapMessageConverter.getSOAPBody((ElementExtensible)bo)) != null) {
            org.apache.axiom.soap.SOAPBody sb = soapEnv.getBody() == null ? this._soapFactory.createSOAPBody(soapEnv) : soapEnv.getBody();
            this.createSoapBody(sb, soapBody, op.getOutput().getMessage(), message.getMessage(), op.getName() + "Response");
        }
    }

    public void createSoapHeaders(SOAPEnvelope soapEnv, List<javax.wsdl.extensions.soap.SOAPHeader> headerDefs, Message msgdef, Map<String, Node> headers) throws AxisFault {
        for (javax.wsdl.extensions.soap.SOAPHeader sh : headerDefs) {
            this.handleSoapHeaderDef(soapEnv, sh, msgdef, headers);
        }
        SOAPHeader soaphdr = soapEnv.getHeader();
        if (soaphdr == null) {
            soaphdr = this._soapFactory.createSOAPHeader(soapEnv);
        }
        for (Node headerNode : headers.values()) {
            if (headerNode.getNodeType() == 1) {
                if (soaphdr.getFirstChildWithName(new QName(headerNode.getNamespaceURI(), headerNode.getLocalName())) != null) continue;
                soaphdr.addChild((OMNode)OMUtils.toOM((Element)((Element)headerNode), (OMFactory)this._soapFactory));
                continue;
            }
            throw new OdeFault(__msgs.msgSoapHeaderMustBeAnElement(headerNode));
        }
    }

    private void handleSoapHeaderDef(SOAPEnvelope soapEnv, javax.wsdl.extensions.soap.SOAPHeader headerdef, Message msgdef, Map<String, Node> headers) throws AxisFault {
        boolean payloadMessageHeader;
        boolean bl = payloadMessageHeader = headerdef.getMessage() == null || headerdef.getMessage().equals(msgdef.getQName());
        if (headerdef.getPart() == null) {
            return;
        }
        if (payloadMessageHeader && msgdef.getPart(headerdef.getPart()) == null) {
            throw new OdeFault(__msgs.msgSoapHeaderReferencesUnkownPart(headerdef.getPart()));
        }
        Element srcPartEl = null;
        if (headers.size() > 0 && payloadMessageHeader) {
            try {
                srcPartEl = (Element)headers.get(headerdef.getPart());
            }
            catch (ClassCastException e) {
                throw new OdeFault(__msgs.msgSoapHeaderMustBeAnElement(headers.get(headerdef.getPart())));
            }
        }
        if (srcPartEl == null && payloadMessageHeader) {
            throw new OdeFault(__msgs.msgOdeMessageMissingRequiredPart(headerdef.getPart()));
        }
        if (srcPartEl == null) {
            return;
        }
        SOAPHeader soaphdr = soapEnv.getHeader();
        if (soaphdr == null) {
            soaphdr = this._soapFactory.createSOAPHeader(soapEnv);
        }
        OMElement omPart = OMUtils.toOM((Element)srcPartEl, (OMFactory)this._soapFactory);
        Iterator i = omPart.getChildren();
        while (i.hasNext()) {
            soaphdr.addChild((OMNode)i.next());
        }
    }

    public SOAPFault createSoapFault(Element message, QName faultName, Operation op) throws AxisFault {
        OMElement detail = this.buildSoapDetail(message, faultName, op);
        SOAPFault fault = this._soapFactory.createSOAPFault();
        SOAPFaultCode code = this._soapFactory.createSOAPFaultCode(fault);
        code.setText(new QName(Namespaces.SOAP_ENV_NS, "Server"));
        SOAPFaultReason reason = this._soapFactory.createSOAPFaultReason(fault);
        reason.setText(faultName);
        SOAPFaultDetail soapDetail = this._soapFactory.createSOAPFaultDetail(fault);
        if (detail != null) {
            soapDetail.addDetailEntry(detail);
        }
        return fault;
    }

    private OMElement buildSoapDetail(Element message, QName faultName, Operation op) throws AxisFault {
        if (faultName.getNamespaceURI() == null) {
            return this.toFaultDetail(faultName, message);
        }
        if (op == null) {
            return this.toFaultDetail(faultName, message);
        }
        Fault f = op.getFault(faultName.getLocalPart());
        if (f == null) {
            return this.toFaultDetail(faultName, message);
        }
        Part p = (Part)f.getMessage().getParts().values().iterator().next();
        if (p == null) {
            return this.toFaultDetail(faultName, message);
        }
        Element partEl = DOMUtils.findChildByName((Element)message, (QName)new QName(null, p.getName()));
        if (partEl == null) {
            return this.toFaultDetail(faultName, message);
        }
        Element detail = DOMUtils.findChildByName((Element)partEl, (QName)p.getElementName());
        if (detail == null) {
            return this.toFaultDetail(faultName, message);
        }
        return OMUtils.toOM((Element)detail, (OMFactory)this._soapFactory);
    }

    private OMElement toFaultDetail(QName fault, Element message) {
        if (message == null) {
            return null;
        }
        Element firstPart = DOMUtils.getFirstChildElement((Element)message);
        if (firstPart == null) {
            return null;
        }
        Element detail = DOMUtils.getFirstChildElement((Element)firstPart);
        if (detail == null) {
            return OMUtils.toOM((Element)firstPart, (OMFactory)this._soapFactory);
        }
        return OMUtils.toOM((Element)detail, (OMFactory)this._soapFactory);
    }

    public void parseSoapRequest(org.apache.ode.bpel.iapi.Message odeMessage, SOAPEnvelope envelope, Operation op) throws AxisFault {
        BindingOperation bop = this._binding.getBindingOperation(op.getName(), null, null);
        if (bop == null) {
            throw new OdeFault(__msgs.msgBindingOperationNotFound(this._serviceName, this._portName, op.getName()));
        }
        BindingInput bi = bop.getBindingInput();
        if (bi == null) {
            throw new OdeFault(__msgs.msgBindingInputNotFound(this._serviceName, this._portName, op.getName()));
        }
        SOAPBody soapBody = SoapMessageConverter.getSOAPBody((ElementExtensible)bi);
        if (soapBody != null) {
            this.extractSoapBodyParts(odeMessage, envelope.getBody(), soapBody, op.getInput().getMessage(), op.getName());
        }
        if (envelope.getHeader() != null) {
            this.extractSoapHeaderParts(odeMessage, envelope.getHeader(), SoapMessageConverter.getSOAPHeaders((ElementExtensible)bi), op.getInput().getMessage());
        }
    }

    public void parseSoapResponse(org.apache.ode.bpel.iapi.Message odeMessage, SOAPEnvelope envelope, Operation op) throws AxisFault {
        BindingOperation bop = this._binding.getBindingOperation(op.getName(), null, null);
        if (bop == null) {
            throw new OdeFault(__msgs.msgBindingOperationNotFound(this._serviceName, this._portName, op.getName()));
        }
        BindingOutput bo = bop.getBindingOutput();
        if (bo == null) {
            throw new OdeFault(__msgs.msgBindingInputNotFound(this._serviceName, this._portName, op.getName()));
        }
        SOAPBody soapBody = SoapMessageConverter.getSOAPBody((ElementExtensible)bo);
        if (soapBody != null) {
            this.extractSoapBodyParts(odeMessage, envelope.getBody(), soapBody, op.getOutput().getMessage(), op.getName() + "Response");
        }
        if (envelope.getHeader() != null) {
            this.extractSoapHeaderParts(odeMessage, envelope.getHeader(), SoapMessageConverter.getSOAPHeaders((ElementExtensible)bo), op.getOutput().getMessage());
        }
    }

    public void createSoapBody(org.apache.axiom.soap.SOAPBody sb, SOAPBody soapBody, Message msgDef, Element message, String rpcWrapper) throws AxisFault {
        org.apache.axiom.soap.SOAPBody partHolder = this._isRPC ? this._soapFactory.createOMElement(new QName(soapBody.getNamespaceURI(), rpcWrapper, "odens"), (OMContainer)sb) : sb;
        List parts = msgDef.getOrderedParts(soapBody.getParts());
        for (Part part : parts) {
            Element srcPartEl = DOMUtils.findChildByName((Element)message, (QName)new QName(null, part.getName()));
            if (srcPartEl == null) {
                throw new OdeFault(__msgs.msgOdeMessageMissingRequiredPart(part.getName()));
            }
            OMElement omPart = OMUtils.toOM((Element)srcPartEl, (OMFactory)this._soapFactory);
            if (this._isRPC) {
                partHolder.addChild((OMNode)omPart);
                continue;
            }
            Iterator i = omPart.getChildElements();
            while (i.hasNext()) {
                partHolder.addChild((OMNode)i.next());
            }
        }
    }

    public void extractSoapBodyParts(org.apache.ode.bpel.iapi.Message message, org.apache.axiom.soap.SOAPBody soapBody, SOAPBody bodyDef, Message msg, String rpcWrapper) throws AxisFault {
        List bodyParts = msg.getOrderedParts(bodyDef.getParts());
        if (this._isRPC) {
            QName rpcWrapQName = new QName(bodyDef.getNamespaceURI(), rpcWrapper);
            OMElement partWrapper = soapBody.getFirstChildWithName(rpcWrapQName);
            if (partWrapper == null) {
                throw new OdeFault(__msgs.msgSoapBodyDoesNotContainExpectedPartWrapper(this._serviceName, this._portName, rpcWrapQName));
            }
            for (Part pdef : bodyParts) {
                OMElement srcPart = partWrapper.getFirstChildWithName(new QName(null, pdef.getName()));
                if (srcPart == null) {
                    throw new OdeFault(__msgs.msgSOAPBodyDoesNotContainRequiredPart(pdef.getName()));
                }
                message.setPart(srcPart.getLocalName(), OMUtils.toDOM((OMElement)srcPart));
            }
        } else {
            Iterator srcParts = soapBody.getChildElements();
            for (Part partDef : bodyParts) {
                if (!srcParts.hasNext()) {
                    throw new OdeFault(__msgs.msgSOAPBodyDoesNotContainRequiredPart(partDef.getName()));
                }
                OMElement srcPart = (OMElement)srcParts.next();
                if (partDef.getElementName() == null) {
                    throw new OdeFault(__msgs.msgBindingDefinesNonElementDocListParts());
                }
                if (!srcPart.getQName().equals(partDef.getElementName())) {
                    throw new OdeFault(__msgs.msgUnexpectedElementInSOAPBody(srcPart.getQName(), partDef.getElementName()));
                }
                Document doc = DOMUtils.newDocument();
                Element destPart = doc.createElementNS(null, partDef.getName());
                destPart.appendChild(doc.importNode(OMUtils.toDOM((OMElement)srcPart), true));
                message.setPart(partDef.getName(), destPart);
            }
        }
    }

    public void extractSoapHeaderParts(org.apache.ode.bpel.iapi.Message message, SOAPHeader soapHeader, List<javax.wsdl.extensions.soap.SOAPHeader> headerDefs, Message msg) throws AxisFault {
        for (javax.wsdl.extensions.soap.SOAPHeader headerDef : headerDefs) {
            this.handleSoapHeaderPartDef(message, soapHeader, headerDef, msg);
        }
        Iterator headersIter = soapHeader.getChildElements();
        while (headersIter.hasNext()) {
            OMElement header = (OMElement)headersIter.next();
            String partName = this.findHeaderPartName(headerDefs, header.getQName());
            message.setHeaderPart(partName, OMUtils.toDOM((OMElement)header));
        }
    }

    private void handleSoapHeaderPartDef(org.apache.ode.bpel.iapi.Message odeMessage, SOAPHeader header, javax.wsdl.extensions.soap.SOAPHeader headerdef, Message msgType) throws AxisFault {
        boolean requiredHeader;
        boolean payloadMessageHeader = headerdef.getMessage() == null || headerdef.getMessage().equals(msgType.getQName());
        boolean bl = requiredHeader = payloadMessageHeader || headerdef.getRequired() != null && headerdef.getRequired() != false;
        if (requiredHeader && header == null) {
            throw new OdeFault(__msgs.msgSoapHeaderMissingRequiredElement(headerdef.getElementType()));
        }
        if (header == null) {
            return;
        }
        Message hdrMsg = this._def.getMessage(headerdef.getMessage());
        if (hdrMsg == null) {
            return;
        }
        Part p = hdrMsg.getPart(headerdef.getPart());
        if (p == null || p.getElementName() == null) {
            return;
        }
        OMElement headerEl = header.getFirstChildWithName(p.getElementName());
        if (requiredHeader && headerEl == null) {
            throw new OdeFault(__msgs.msgSoapHeaderMissingRequiredElement(headerdef.getElementType()));
        }
        if (headerEl == null) {
            return;
        }
        odeMessage.setHeaderPart(p.getName(), OMUtils.toDOM((OMElement)headerEl));
    }

    private String findHeaderPartName(List<javax.wsdl.extensions.soap.SOAPHeader> headerDefs, QName elmtName) {
        for (javax.wsdl.extensions.soap.SOAPHeader headerDef : headerDefs) {
            Message hdrMsg = this._def.getMessage(headerDef.getMessage());
            for (Object o : hdrMsg.getParts().values()) {
                Part p = (Part)o;
                if (!p.getElementName().equals(elmtName)) continue;
                return p.getName();
            }
        }
        return elmtName.getLocalPart();
    }

    public static SOAPBody getSOAPBody(ElementExtensible ee) {
        return SoapMessageConverter.getFirstExtensibilityElement(ee, SOAPBody.class);
    }

    public static List<javax.wsdl.extensions.soap.SOAPHeader> getSOAPHeaders(ElementExtensible eee) {
        return (List)CollectionsX.filter(new ArrayList(), (Collection)eee.getExtensibilityElements(), javax.wsdl.extensions.soap.SOAPHeader.class);
    }

    public static <T> T getFirstExtensibilityElement(ElementExtensible parent, Class<T> cls) {
        Collection ee = CollectionsX.filter((Collection)parent.getExtensibilityElements(), cls);
        return ee.isEmpty() ? null : (T)ee.iterator().next();
    }

    public String getWSAInputAction(String operation) {
        Object actionQName;
        BindingOperation bop = this._binding.getBindingOperation(operation, null, null);
        if (bop == null) {
            return "";
        }
        Input input = bop.getOperation().getInput();
        if (input != null && (actionQName = input.getExtensionAttribute(new QName(Namespaces.WS_ADDRESSING_NS, "Action"))) != null && actionQName instanceof QName) {
            return ((QName)actionQName).getLocalPart();
        }
        return "";
    }

    public String getSoapAction(String operation) {
        BindingOperation bop = this._binding.getBindingOperation(operation, null, null);
        if (bop == null) {
            return "";
        }
        Iterator i$ = CollectionsX.filter((Collection)bop.getExtensibilityElements(), SOAPOperation.class).iterator();
        if (i$.hasNext()) {
            SOAPOperation soapOp = (SOAPOperation)i$.next();
            return soapOp.getSoapActionURI();
        }
        return "";
    }

    public Fault parseSoapFault(Element odeMsgEl, SOAPEnvelope envelope, Operation operation) throws AxisFault {
        SOAPFault flt = envelope.getBody().getFault();
        SOAPFaultDetail detail = flt.getDetail();
        Fault fdef = this.inferFault(operation, flt);
        if (fdef == null) {
            return null;
        }
        Part pdef = (Part)fdef.getMessage().getParts().values().iterator().next();
        Element partel = odeMsgEl.getOwnerDocument().createElementNS(null, pdef.getName());
        odeMsgEl.appendChild(partel);
        if (detail.getFirstChildWithName(pdef.getElementName()) != null) {
            partel.appendChild(odeMsgEl.getOwnerDocument().importNode(OMUtils.toDOM((OMElement)detail.getFirstChildWithName(pdef.getElementName())), true));
        } else {
            partel.appendChild(odeMsgEl.getOwnerDocument().importNode(OMUtils.toDOM((OMElement)detail), true));
        }
        return fdef;
    }

    private Fault inferFault(Operation operation, SOAPFault flt) {
        if (flt.getDetail() == null || flt.getDetail().getFirstElement() == null) {
            return null;
        }
        QName elName = flt.getDetail().getFirstElement().getQName();
        return WsdlUtils.inferFault((Operation)operation, (QName)elName);
    }
}

