/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.evt;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import org.apache.ode.bpel.evt.EventContext;
import org.apache.ode.utils.CollectionUtils;

public abstract class BpelEvent
implements Serializable {
    public transient EventContext eventContext;
    private Date _timestamp = new Date();
    private int _lineNo = -1;

    public int getLineNo() {
        return this._lineNo;
    }

    public void setLineNo(int lineNo) {
        this._lineNo = lineNo;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(Date tstamp) {
        this._timestamp = tstamp;
    }

    public String toString() {
        Method[] methods;
        StringBuilder sb = new StringBuilder("\n" + BpelEvent.eventName(this) + ":");
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0) continue;
            try {
                String field = method.getName().substring(3);
                Object value = method.invoke((Object)this, CollectionUtils.EMPTY_OBJECT_ARRAY);
                if (value == null) continue;
                sb.append("\n\t").append(field).append(" = ").append(value == null ? "null" : value.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static String eventName(BpelEvent event) {
        String name = event.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public abstract TYPE getType();

    public static enum TYPE {
        dataHandling,
        activityLifecycle,
        scopeHandling,
        instanceLifecycle,
        correlation;

    }
}

