/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockScheduler
implements Scheduler {
    private static final Log __log = LogFactory.getLog(MockScheduler.class);
    private Scheduler.JobProcessor _processor;
    private ExecutorService _executorSvc = Executors.newCachedThreadPool();
    private ThreadLocal<Boolean> _transacted = new ThreadLocal();
    private TransactionManager _txm;
    private Timer _timer = new Timer(false);
    ThreadLocal<List<Scheduler.Synchronizer>> _synchros = new ThreadLocal<List<Scheduler.Synchronizer>>(){

        @Override
        protected List<Scheduler.Synchronizer> initialValue() {
            return new ArrayList<Scheduler.Synchronizer>();
        }
    };

    public MockScheduler() {
        this._transacted.set(false);
    }

    public MockScheduler(TransactionManager txm) {
        this._txm = txm;
        this._transacted.set(false);
    }

    public String schedulePersistedJob(Scheduler.JobDetails detail, Date date) throws ContextException {
        if (date != null) {
            return this.scheduleVolatileJob(true, detail, date);
        }
        return this.scheduleVolatileJob(true, detail);
    }

    public String scheduleVolatileJob(boolean transacted, Scheduler.JobDetails jobDetail) throws ContextException {
        return this.scheduleVolatileJob(transacted, jobDetail, null);
    }

    public String scheduleVolatileJob(final boolean transacted, final Scheduler.JobDetails detail, final Date date) throws ContextException {
        if (date != null) {
            this.registerSynchronizer(new Scheduler.Synchronizer(){

                public void afterCompletion(boolean success) {
                    if (!success) {
                        return;
                    }
                    MockScheduler.this._timer.schedule(new TimerTask(){

                        public void run() {
                            MockScheduler.this.exec(transacted, detail);
                        }
                    }, date);
                }

                public void beforeCompletion() {
                }
            });
            return null;
        }
        this.registerSynchronizer(new Scheduler.Synchronizer(){

            public void afterCompletion(boolean success) {
                if (!success) {
                    return;
                }
                MockScheduler.this.exec(transacted, detail);
            }

            public void beforeCompletion() {
            }
        });
        return null;
    }

    private void exec(boolean transacted, final Scheduler.JobDetails detail) {
        try {
            if (transacted) {
                this.execIsolatedTransaction(new Callable(){

                    public Object call() throws Exception {
                        Scheduler.JobInfo ji = new Scheduler.JobInfo("volatileJob", detail, 0);
                        MockScheduler.this.doExecute(ji);
                        return null;
                    }
                });
            } else {
                Scheduler.JobInfo ji = new Scheduler.JobInfo("volatileJob", detail, 0);
                this.doExecute(ji);
            }
        }
        catch (Exception e) {
            throw new ContextException("Failure when scheduling a new volatile job.", (Throwable)e);
        }
    }

    public String scheduleMapSerializableRunnable(final Scheduler.MapSerializableRunnable runnable, final Date when) throws ContextException {
        if (when != null) {
            this.registerSynchronizer(new Scheduler.Synchronizer(){

                public void afterCompletion(boolean success) {
                    if (!success) {
                        return;
                    }
                    MockScheduler.this._timer.schedule(new TimerTask(){

                        public void run() {
                            runnable.run();
                        }
                    }, when);
                }

                public void beforeCompletion() {
                }
            });
            return null;
        }
        return this.scheduleVolatileJob(true, new Scheduler.JobDetails());
    }

    public void cancelJob(String arg0) throws ContextException {
    }

    public <T> T execTransaction(Callable<T> transaction) throws Exception, ContextException {
        return this.execTransaction(transaction, 0);
    }

    public <T> T execTransaction(Callable<T> transaction, int timeout) throws Exception, ContextException {
        if (timeout > 0) {
            this._txm.setTransactionTimeout(timeout);
        }
        this.beginTransaction();
        try {
            T retval = transaction.call();
            this.commitTransaction();
            T t = retval;
            return t;
        }
        catch (Throwable t) {
            __log.error((Object)"Caught an exception during transaction", t);
            this.rollbackTransaction();
            throw new ContextException("Error in tx", t);
        }
        finally {
            if (timeout > 0) {
                this._txm.setTransactionTimeout(0);
            }
        }
    }

    public void setRollbackOnly() throws Exception {
        if (this._txm != null) {
            this._txm.setRollbackOnly();
        }
    }

    public <T> Future<T> execIsolatedTransaction(final Callable<T> transaction) throws Exception, ContextException {
        return this._executorSvc.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return MockScheduler.this.execTransaction(transaction);
            }
        });
    }

    public boolean isTransacted() {
        if (this._txm != null) {
            try {
                return this._txm.getTransaction() != null;
            }
            catch (SystemException e) {
                __log.error((Object)"Exception in mock scheduler isTransacted.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this._transacted.get();
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
    }

    public void registerSynchronizer(final Scheduler.Synchronizer synch) throws ContextException {
        if (this._txm != null) {
            try {
                this._txm.getTransaction().registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                        synch.beforeCompletion();
                    }

                    public void afterCompletion(int status) {
                        synch.afterCompletion(status == 3);
                    }
                });
            }
            catch (Exception e) {
                __log.error((Object)"Exception in mock scheduler sync registration.", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            this._synchros.get().add(synch);
        }
    }

    public void beginTransaction() {
        if (this._txm != null) {
            try {
                this._txm.begin();
            }
            catch (Exception e) {
                __log.error((Object)"Exception in mock scheduler begin.", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            this._synchros.get().clear();
        }
        this._transacted.set(Boolean.TRUE);
    }

    public void commitTransaction() {
        if (this._txm != null) {
            try {
                this._txm.commit();
            }
            catch (Exception e) {
                __log.error((Object)"Exception in mock scheduler commit.", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            for (Scheduler.Synchronizer s : this._synchros.get()) {
                try {
                    s.beforeCompletion();
                }
                catch (Throwable t) {}
            }
            for (Scheduler.Synchronizer s : this._synchros.get()) {
                try {
                    s.afterCompletion(true);
                }
                catch (Throwable throwable) {}
            }
            this._synchros.get().clear();
        }
        this._transacted.set(Boolean.FALSE);
    }

    public void rollbackTransaction() {
        if (this._txm != null) {
            try {
                this._txm.rollback();
            }
            catch (Exception e) {
                __log.error((Object)"Exception in mock scheduler rollback.", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            for (Scheduler.Synchronizer s : this._synchros.get()) {
                try {
                    s.beforeCompletion();
                }
                catch (Throwable t) {}
            }
            for (Scheduler.Synchronizer s : this._synchros.get()) {
                try {
                    s.afterCompletion(false);
                }
                catch (Throwable throwable) {}
            }
            this._synchros.get().clear();
        }
        this._transacted.set(Boolean.FALSE);
    }

    private void doExecute(Scheduler.JobInfo ji) {
        Scheduler.JobProcessor processor = this._processor;
        if (processor == null) {
            throw new RuntimeException("No processor.");
        }
        try {
            processor.onScheduledJob(ji);
        }
        catch (Exception jpe) {
            throw new RuntimeException("Scheduled transaction failed unexpectedly: transaction will not be retried!.", jpe);
        }
    }

    public void setJobProcessor(Scheduler.JobProcessor processor) throws ContextException {
        this._processor = processor;
    }

    public void setExecutorSvc(ExecutorService executorSvc) {
        this._executorSvc = executorSvc;
    }

    public void setPolledRunnableProcesser(Scheduler.JobProcessor delegatedRunnableProcessor) {
    }

    public boolean amICoordinator() {
        return true;
    }

    public void acquireTransactionLocks() {
    }
}

