/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.epr;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDL11Endpoint
implements MutableEndpoint {
    private Element _serviceElmt;

    public WSDL11Endpoint() {
    }

    public WSDL11Endpoint(QName serviceQName, String portName, String location) {
        Document doc = DOMUtils.newDocument();
        Element serviceRef = doc.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        doc.appendChild(serviceRef);
        this._serviceElmt = doc.createElementNS(Namespaces.WSDL_11, "service");
        serviceRef.appendChild(this._serviceElmt);
        if (serviceQName != null) {
            this._serviceElmt.setAttribute("name", serviceQName.getLocalPart());
            this._serviceElmt.setAttribute("targetNamespace", serviceQName.getNamespaceURI());
        }
        Element port = doc.createElementNS(Namespaces.WSDL_11, "port");
        if (portName != null) {
            port.setAttribute("name", portName);
        }
        port.setAttribute("binding", "");
        Element address = doc.createElementNS(Namespaces.SOAP_NS, "address");
        if (location != null) {
            address.setAttribute("location", location);
        }
        this._serviceElmt.appendChild(port);
        port.appendChild(address);
    }

    public WSDL11Endpoint(QName serviceName, String portName) {
        this(serviceName, portName, null);
    }

    public String getUrl() {
        Element port = (Element)this._serviceElmt.getElementsByTagNameNS(Namespaces.WSDL_11, "port").item(0);
        Element address = (Element)port.getElementsByTagNameNS(Namespaces.SOAP_NS, "address").item(0);
        if (address == null) {
            address = (Element)port.getElementsByTagNameNS(Namespaces.HTTP_NS, "address").item(0);
        }
        if (address == null) {
            address = (Element)port.getElementsByTagNameNS(Namespaces.SOAP12_NS, "address").item(0);
        }
        if (address == null) {
            throw new IllegalArgumentException("soap:address and http:address element in element " + DOMUtils.domToString((Node)this._serviceElmt) + " is missing or in the wrong namespace.");
        }
        return address.getAttribute("location");
    }

    public QName getServiceName() {
        return new QName(this._serviceElmt.getAttribute("targetNamespace"), this._serviceElmt.getAttribute("name"));
    }

    public boolean accept(Node node) {
        if (node.getNodeType() == 1) {
            Element elmt = (Element)node;
            if (elmt.getLocalName().equals("service-ref") && (elmt.getNamespaceURI().equals(Namespaces.WS_BPEL_20_NS) || elmt.getNamespaceURI().equals(Namespaces.WSBPEL2_0_FINAL_SERVREF))) {
                elmt = DOMUtils.getFirstChildElement((Element)elmt);
            }
            if (elmt.getLocalName().equals("service") && elmt.getNamespaceURI().equals(Namespaces.WSDL_11)) {
                return true;
            }
        }
        return false;
    }

    public void set(Node node) {
        this._serviceElmt = node.getNamespaceURI().equals(SERVICE_REF_QNAME.getNamespaceURI()) ? DOMUtils.getFirstChildElement((Element)((Element)node)) : (Element)node;
    }

    public Document toXML() {
        Document doc = DOMUtils.newDocument();
        Element serviceRef = doc.createElementNS(Namespaces.WSBPEL2_0_FINAL_SERVREF, "service-ref");
        doc.appendChild(serviceRef);
        serviceRef.appendChild(doc.importNode(this._serviceElmt, true));
        return this._serviceElmt.getOwnerDocument();
    }

    public Map toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("address", this.getUrl());
        result.put("service", new QName(this._serviceElmt.getAttribute("targetNamespace"), this._serviceElmt.getAttribute("name")));
        Element port = DOMUtils.getFirstChildElement((Element)this._serviceElmt);
        result.put("port", port.getAttribute("name"));
        return result;
    }

    public void fromMap(Map eprMap) {
        Document doc = DOMUtils.newDocument();
        Element serviceRef = doc.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        doc.appendChild(serviceRef);
        this._serviceElmt = doc.createElementNS(Namespaces.WSDL_11, "service");
        serviceRef.appendChild(this._serviceElmt);
        if (eprMap.get("service") != null) {
            QName serviceQName = (QName)eprMap.get("service");
            this._serviceElmt.setAttribute("name", serviceQName.getLocalPart());
            this._serviceElmt.setAttribute("targetNamespace", serviceQName.getNamespaceURI());
        }
        Element port = doc.createElementNS(Namespaces.WSDL_11, "port");
        if (eprMap.get("port") != null) {
            port.setAttribute("name", (String)eprMap.get("port"));
        }
        port.setAttribute("binding", "");
        Element address = doc.createElementNS(Namespaces.SOAP_NS, "address");
        if (eprMap.get("address") != null) {
            address.setAttribute("location", (String)eprMap.get("address"));
        }
        this._serviceElmt.appendChild(port);
        port.appendChild(address);
    }
}

