/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il;

import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;

public class EmbeddedGeronimoFactory {
    private static final Log LOG = LogFactory.getLog(EmbeddedGeronimoFactory.class);

    public TransactionManager getTransactionManager() {
        LOG.info((Object)"Using embedded Geronimo transaction manager");
        try {
            return new GeronimoTransactionManager();
        }
        catch (XAException exception) {
            throw new IllegalStateException("Unable to instantiate Geronimo Transaction Manager", exception);
        }
    }

    public TransactionManager getTransactionManager(int timeOut) {
        LOG.info((Object)"Using embedded Geronimo transaction manager with timeout");
        try {
            return new GeronimoTransactionManager(timeOut);
        }
        catch (XAException exception) {
            throw new IllegalStateException("Unable to instantiate Geronimo Transaction Manager", exception);
        }
    }
}

