/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.o;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.o.OProcess;

public class Serializer {
    public static final byte[] MAGIC_NUMBER_OFH_20040908 = new byte[]{85, 53, 83, 0, 79, 70, 72, 32, 4, 9, 8};
    public static final byte[] MAGIC_NUMBER_OFH_20061101 = new byte[]{85, 53, 83, 0, 79, 70, 72, 32, 6, 17, 1};
    public static final byte[] MAGIC_NUMBER = MAGIC_NUMBER_OFH_20061101;
    public static final short FORMAT_SERIALIZED_JAVA14 = 1;
    public final byte[] magic = new byte[MAGIC_NUMBER.length];
    public short format;
    public long compileTime;
    public final int numProcesses = 1;
    public InputStream _inputStream;
    public String guid;
    public QName type;

    public Serializer(long compileTime) {
        System.arraycopy(MAGIC_NUMBER, 0, this.magic, 0, MAGIC_NUMBER.length);
        this.format = 1;
        this.compileTime = compileTime;
    }

    public Serializer() {
    }

    public Serializer(InputStream inputStream) throws IOException {
        this._inputStream = inputStream;
        this.read(inputStream);
    }

    public void read(InputStream is) throws IOException {
        DataInputStream oin = new DataInputStream(is);
        byte[] magic = new byte[MAGIC_NUMBER.length];
        oin.read(magic, 0, magic.length);
        if (Arrays.equals(MAGIC_NUMBER_OFH_20040908, magic)) {
            OProcess oprocess;
            this.format = oin.readShort();
            this.compileTime = oin.readLong();
            oin.readInt();
            CustomObjectInputStream ois = new CustomObjectInputStream(this._inputStream);
            try {
                oprocess = (OProcess)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("DataStream Error");
            }
            this.type = new QName(oprocess.targetNamespace, oprocess.processName);
            this.guid = "OLD-FORMAT-NO-GUID";
            return;
        }
        if (Arrays.equals(MAGIC_NUMBER, magic)) {
            this.format = oin.readShort();
            this.compileTime = oin.readLong();
            this.guid = oin.readUTF();
            String tns = oin.readUTF();
            String name = oin.readUTF();
            this.type = new QName(tns, name);
            return;
        }
        throw new IOException("Unrecognized file format (bad magic number).");
    }

    public void writeOProcess(OProcess process, OutputStream os) throws IOException {
        DataOutputStream out = new DataOutputStream(os);
        out.write(MAGIC_NUMBER);
        out.writeShort(this.format);
        out.writeLong(this.compileTime);
        out.writeUTF(process.guid);
        out.writeUTF(process.targetNamespace);
        out.writeUTF(process.processName);
        out.flush();
        CustomObjectOutputStream oos = new CustomObjectOutputStream(os);
        oos.writeObject(process);
        oos.flush();
    }

    public OProcess readOProcess() throws IOException, ClassNotFoundException {
        OProcess oprocess;
        CustomObjectInputStream ois = new CustomObjectInputStream(this._inputStream);
        try {
            oprocess = (OProcess)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("DataStream Error");
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException iOException) {}
        }
        return oprocess;
    }

    static class OQName
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String local;
        final String uri;
        final String prefix;

        OQName(String uri, String local, String prefix) {
            this.uri = uri;
            this.local = local;
            this.prefix = prefix;
        }
    }

    static class CustomObjectInputStream
    extends ObjectInputStream {
        public CustomObjectInputStream(InputStream in) throws IOException {
            super(in);
            this.enableResolveObject(true);
        }

        @Override
        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof OQName) {
                OQName q = (OQName)obj;
                return new QName(q.uri, q.local, q.prefix);
            }
            return super.resolveObject(obj);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass read = super.readClassDescriptor();
            if (read.getName().startsWith("com.fs.pxe.")) {
                return ObjectStreamClass.lookup(Class.forName(read.getName().replace("com.fs.pxe.", "org.apache.ode.")));
            }
            if (read.getName().startsWith("com.fs.utils.")) {
                return ObjectStreamClass.lookup(Class.forName(read.getName().replace("com.fs.utils.", "org.apache.ode.utils.")));
            }
            return read;
        }
    }

    static class CustomObjectOutputStream
    extends ObjectOutputStream {
        public CustomObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof QName) {
                QName q = (QName)obj;
                return new OQName(q.getNamespaceURI(), q.getLocalPart(), q.getPrefix());
            }
            return super.replaceObject(obj);
        }
    }
}

