/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.o;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLValueExpression;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.SerializableElement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OAssign
extends OActivity {
    static final long serialVersionUID = -1L;
    public final List<OAssignOperation> operations = new ArrayList<OAssignOperation>();

    public OAssign(OProcess owner, OActivity parent) {
        super(owner, parent);
    }

    @Override
    public String toString() {
        return "{OAssign : " + this.name + ", joinCondition=" + this.joinCondition + "}";
    }

    @Override
    public void dehydrate() {
        super.dehydrate();
        for (OAssignOperation oao : this.operations) {
            oao.dehydrate();
        }
    }

    public static class PartnerLinkRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OPartnerLink partnerLink;
        public boolean isMyEndpointReference;

        public PartnerLinkRef(OProcess owner) {
            super(owner);
        }

        @Override
        public OScope.Variable getVariable() {
            return null;
        }

        @Override
        public String toString() {
            return "{PLinkRef " + this.partnerLink + "!" + this.isMyEndpointReference + "}";
        }
    }

    public static class PropertyRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OScope.Variable variable;
        public OProcess.OPropertyAlias propertyAlias;

        public PropertyRef(OProcess owner) {
            super(owner);
        }

        @Override
        public OScope.Variable getVariable() {
            return this.variable;
        }

        @Override
        public String toString() {
            return "{PropRef " + this.variable + "!" + this.propertyAlias + "}";
        }
    }

    public static class VariableRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OScope.Variable variable;
        public OMessageVarType.Part part;
        public OMessageVarType.Part headerPart;
        public OExpression location;

        public VariableRef(OProcess owner) {
            super(owner);
        }

        @Override
        public OScope.Variable getVariable() {
            return this.variable;
        }

        public boolean isMessageRef() {
            return this.variable.type instanceof OMessageVarType && this.part == null && this.headerPart == null && this.location == null;
        }

        public boolean isPartRef() {
            return this.variable.type instanceof OMessageVarType && this.part != null && this.location == null;
        }

        public boolean isHeaderRef() {
            return this.variable.type instanceof OMessageVarType && this.headerPart != null && this.location == null;
        }

        @Override
        public String toString() {
            return "{VarRef " + this.variable + (this.part == null ? "" : "." + this.part.name) + (this.location == null ? "" : this.location.toString()) + "}";
        }
    }

    public static class DirectRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OScope.Variable variable;
        public QName elName;

        public DirectRef(OProcess owner) {
            super(owner);
        }

        @Override
        public OScope.Variable getVariable() {
            return this.variable;
        }
    }

    public static class Expression
    extends OBase
    implements RValue {
        private static final long serialVersionUID = 1L;
        public OExpression expression;

        public Expression(OProcess owner, OExpression compiledExpression) {
            super(owner);
            this.expression = compiledExpression;
        }

        @Override
        public String toString() {
            return this.expression.toString();
        }
    }

    public static class LValueExpression
    extends OBase
    implements LValue {
        private static final long serialVersionUID = 1L;
        public OLValueExpression expression;

        public LValueExpression(OProcess owner, OLValueExpression compiledExpression) {
            super(owner);
            this.expression = compiledExpression;
        }

        @Override
        public String toString() {
            return this.expression.toString();
        }

        @Override
        public OScope.Variable getVariable() {
            return this.expression.getVariable();
        }

        public boolean isInsertMissingToData() {
            return this.expression.insertMissingData;
        }

        public void setInsertMissingToData(boolean insertMissingToData) {
            this.expression.insertMissingData = insertMissingToData;
        }
    }

    public static class Literal
    extends OBase
    implements RValue {
        private static final long serialVersionUID = 1L;
        public transient String xmlLiteral;

        public Literal(OProcess owner, Document xmlLiteral) {
            super(owner);
            if (xmlLiteral == null) {
                throw new IllegalArgumentException("null xmlLiteral!");
            }
            this.xmlLiteral = DOMUtils.domToString((Node)xmlLiteral);
        }

        @Override
        public String toString() {
            return "{Literal " + this.xmlLiteral + "}";
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.xmlLiteral);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            String domStr;
            try {
                domStr = (String)in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw (IOException)new IOException("XML de-serialization error.").initCause(e);
            }
            this.xmlLiteral = domStr;
        }

        public String getXmlLiteral() {
            return this.xmlLiteral;
        }
    }

    public static interface RValue {
    }

    public static interface LValue {
        public OScope.Variable getVariable();
    }

    public static class ExtensionAssignOperation
    extends OAssignOperation {
        private static final long serialVersionUID = 1L;
        public SerializableElement nestedElement;
        public QName extensionName;

        public ExtensionAssignOperation(OProcess owner) {
            super(owner);
        }

        @Override
        public String toString() {
            return "{OExtensionAssignOperation; " + this.nestedElement.getElement().getTagName() + "}";
        }

        @Override
        public OAssignOperation.Type getType() {
            return OAssignOperation.Type.ExtensionOperation;
        }

        @Override
        public void dehydrate() {
            super.dehydrate();
            this.nestedElement = null;
            this.extensionName = null;
        }
    }

    public static class Copy
    extends OAssignOperation {
        private static final long serialVersionUID = 1L;
        public LValue to;
        public RValue from;
        public boolean keepSrcElementName;
        public boolean ignoreMissingFromData;
        public boolean ignoreUninitializedFromVariable;
        public boolean insertMissingToData;

        public Copy(OProcess owner) {
            super(owner);
        }

        @Override
        public OAssignOperation.Type getType() {
            return OAssignOperation.Type.Copy;
        }

        @Override
        public String toString() {
            return "{OCopy " + this.to + "=" + this.from + "}";
        }

        @Override
        public void dehydrate() {
            super.dehydrate();
            this.to = null;
            this.from = null;
        }
    }

    public static abstract class OAssignOperation
    extends OBase {
        public OAssignOperation(OProcess owner) {
            super(owner);
        }

        public abstract Type getType();

        public static enum Type {
            Copy,
            ExtensionOperation;

        }
    }
}

