/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.o;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OCompensationHandler;
import org.apache.ode.bpel.o.OEventHandler;
import org.apache.ode.bpel.o.OExtVar;
import org.apache.ode.bpel.o.OFaultHandler;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OTerminationHandler;
import org.apache.ode.bpel.o.OVarType;

public class OScope
extends OActivity {
    static final long serialVersionUID = -1L;
    public String name;
    public OFaultHandler faultHandler;
    public OActivity activity;
    public OCompensationHandler compensationHandler;
    public OTerminationHandler terminationHandler;
    public OEventHandler eventHandler;
    public final HashMap<String, Variable> variables = new HashMap();
    public final Map<String, CorrelationSet> correlationSets = new HashMap<String, CorrelationSet>();
    public final Map<String, OPartnerLink> partnerLinks = new HashMap<String, OPartnerLink>();
    public final Set<OScope> compensatable = new HashSet<OScope>();
    public boolean implicitScope;
    public boolean atomicScope;
    public boolean isolatedScope;

    public OScope(OProcess owner, OActivity parent) {
        super(owner, parent);
    }

    public CorrelationSet getCorrelationSet(String corrName) {
        return this.correlationSets.get(corrName);
    }

    public Variable getLocalVariable(String varName) {
        return this.variables.get(varName);
    }

    public void addLocalVariable(Variable variable) {
        this.variables.put(variable.name, variable);
    }

    public Variable getVisibleVariable(String varName) {
        for (OActivity current = this; current != null; current = current.getParent()) {
            Variable variable;
            if (!(current instanceof OScope) || (variable = current.getLocalVariable(varName)) == null) continue;
            return variable;
        }
        return null;
    }

    public OPartnerLink getLocalPartnerLink(String name) {
        return this.partnerLinks.get(name);
    }

    public OPartnerLink getVisiblePartnerLink(String name) {
        for (OActivity current = this; current != null; current = current.getParent()) {
            OPartnerLink plink;
            if (!(current instanceof OScope) || (plink = current.getLocalPartnerLink(name)) == null) continue;
            return plink;
        }
        return null;
    }

    public void addCorrelationSet(CorrelationSet ocset) {
        this.correlationSets.put(ocset.name, ocset);
    }

    public boolean isInAtomicScope() {
        for (OActivity current = this; current != null; current = current.getParent()) {
            if (!(current instanceof OScope) || !current.atomicScope) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "{OScope '" + this.name + "' id=" + this.getId() + "}";
    }

    @Override
    public void dehydrate() {
        super.dehydrate();
        this.activity = null;
        if (this.compensatable != null) {
            this.compensatable.clear();
        }
        if (this.compensationHandler != null) {
            this.compensationHandler.dehydrate();
            this.compensationHandler = null;
        }
        if (this.terminationHandler != null) {
            this.terminationHandler.dehydrate();
            this.terminationHandler = null;
        }
        if (this.eventHandler != null) {
            this.eventHandler.dehydrate();
            this.eventHandler = null;
        }
        if (this.variables != null) {
            this.variables.clear();
        }
        if (this.correlationSets != null) {
            this.correlationSets.clear();
        }
        if (this.partnerLinks != null) {
            this.partnerLinks.clear();
        }
    }

    public static final class Variable
    extends OBase {
        static final long serialVersionUID = -1L;
        public String name;
        public OScope declaringScope;
        public OVarType type;
        public OExtVar extVar;

        public Variable(OProcess owner, OVarType type) {
            super(owner);
            this.type = type;
        }

        @Override
        public String toString() {
            return "{Variable " + this.getDescription() + ":" + this.type + "}";
        }

        public String getDescription() {
            StringBuffer buf = new StringBuffer(this.declaringScope.name);
            buf.append('.');
            buf.append(this.name);
            return buf.toString();
        }
    }

    public static final class CorrelationSet
    extends OBase {
        static final long serialVersionUID = -1L;
        public String name;
        public OScope declaringScope;
        public final List<OProcess.OProperty> properties = new ArrayList<OProcess.OProperty>();
        public boolean hasJoinUseCases = false;

        public CorrelationSet(OProcess owner) {
            super(owner);
        }

        @Override
        public String toString() {
            return "{CSet " + this.name + " " + this.properties + "}";
        }
    }
}

