/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.o;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OConstants;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OExpressionLanguage;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.o.OXsdTypeVarType;
import org.apache.ode.bpel.o.OXslSheet;
import org.apache.ode.utils.NSContext;

public class OProcess
extends OBase {
    public static int instanceCount = 0;
    static final long serialVersionUID = -1L;
    public String guid;
    public final String version;
    public OConstants constants;
    public String uuid;
    public String targetNamespace;
    public String processName;
    public OScope procesScope;
    public final Set<OPartnerLink> allPartnerLinks = new HashSet<OPartnerLink>();
    public final List<OProperty> properties = new ArrayList<OProperty>();
    public final Set<OExtension> declaredExtensions = new HashSet<OExtension>();
    public final Set<OExtension> mustUnderstandExtensions = new HashSet<OExtension>();
    public Date compileDate;
    int _childIdCounter = 0;
    List<OBase> _children = new ArrayList<OBase>();
    public final HashSet<OExpressionLanguage> expressionLanguages = new HashSet();
    public final HashMap<QName, OMessageVarType> messageTypes = new HashMap();
    public final HashMap<QName, OElementVarType> elementTypes = new HashMap();
    public final HashMap<QName, OXsdTypeVarType> xsdTypes = new HashMap();
    public final HashMap<URI, OXslSheet> xslSheets = new HashMap();
    public NSContext namespaceContext = null;

    public OProcess(String bpelVersion) {
        super(null);
        this.version = bpelVersion;
        ++instanceCount;
    }

    public OBase getChild(int id) {
        for (int i = this._children.size() - 1; i >= 0; --i) {
            OBase child = this._children.get(i);
            if (child.getId() != id) continue;
            return child;
        }
        return null;
    }

    public List<OBase> getChildren() {
        return this._children;
    }

    public OScope getScope(String scopeName) {
        throw new UnsupportedOperationException();
    }

    public Set<OPartnerLink> getAllPartnerLinks() {
        return Collections.unmodifiableSet(this.allPartnerLinks);
    }

    public OPartnerLink getPartnerLink(String name) {
        for (OPartnerLink partnerLink : this.allPartnerLinks) {
            if (!partnerLink.getName().equals(name)) continue;
            return partnerLink;
        }
        return null;
    }

    public String getName() {
        return this.processName;
    }

    public Collection getExpressionLanguages() {
        throw new UnsupportedOperationException();
    }

    public List<String> getCorrelators() {
        ArrayList<String> correlators = new ArrayList<String>();
        for (OPartnerLink plink : this.getAllPartnerLinks()) {
            if (!plink.hasMyRole()) continue;
            for (Object o : plink.myRolePortType.getOperations()) {
                Operation op = (Operation)o;
                correlators.add(plink.getName() + "." + op.getName());
            }
        }
        return correlators;
    }

    public QName getQName() {
        return new QName(this.targetNamespace, this.processName);
    }

    protected void finalize() throws Throwable {
        --instanceCount;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ++instanceCount;
    }

    @Override
    public void dehydrate() {
        super.dehydrate();
        this.procesScope.dehydrate();
        this.allPartnerLinks.clear();
        for (OBase obase : this._children) {
            obase.dehydrate();
        }
        this._children.clear();
        this.messageTypes.clear();
        this.elementTypes.clear();
        this.xsdTypes.clear();
        this.xslSheets.clear();
    }

    @Override
    public String digest() {
        return this.processName + ";" + this.procesScope.digest();
    }

    public static class OExtension
    extends OBase {
        static final long serialVersionUID = -1L;
        public String namespaceURI;
        public boolean mustUnderstand;

        public OExtension(OProcess process) {
            super(process);
        }

        @Override
        public String toString() {
            return "{OExtension " + this.namespaceURI + (this.mustUnderstand ? " mustUnderstand" : "") + "}";
        }
    }

    public static class OPropertyAlias
    extends OBase {
        static final long serialVersionUID = -1L;
        public OVarType varType;
        public OMessageVarType.Part part;
        public String header;
        public OExpression location;

        public OPropertyAlias(OProcess owner) {
            super(owner);
        }

        @Override
        public String toString() {
            return "{OPropertyAlias " + this.getDescription() + "}";
        }

        public String getDescription() {
            StringBuffer buf = new StringBuffer(this.varType.toString());
            buf.append('[');
            buf.append(this.part != null ? this.part.name : "");
            buf.append(this.header != null ? "header: " + this.header : "");
            if (this.location != null) {
                buf.append("][");
                buf.append(this.location.toString());
            }
            buf.append(']');
            return buf.toString();
        }
    }

    public static class OProperty
    extends OBase {
        static final long serialVersionUID = -1L;
        public final List<OPropertyAlias> aliases = new ArrayList<OPropertyAlias>();
        public QName name;

        public OProperty(OProcess process) {
            super(process);
        }

        public OPropertyAlias getAlias(OVarType messageType) {
            for (OPropertyAlias aliase : this.aliases) {
                if (!aliase.varType.equals(messageType)) continue;
                return aliase;
            }
            return null;
        }

        @Override
        public String toString() {
            return "{OProperty " + this.name + "}";
        }
    }
}

