/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store.jpa;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.jpa.JpaTxMgrProvider;
import org.apache.ode.store.ConfStoreConnection;
import org.apache.ode.store.ConfStoreConnectionFactory;
import org.apache.ode.store.jpa.ConfStoreConnectionJpa;

public class DbConfStoreConnectionFactory
implements ConfStoreConnectionFactory {
    private static final Log __log = LogFactory.getLog(DbConfStoreConnectionFactory.class);
    private DataSource _ds;
    private EntityManagerFactory _emf;
    private TransactionManager _txMgr;

    public DbConfStoreConnectionFactory(DataSource ds, boolean createDatamodel, String txFactoryClassName) {
        this._ds = ds;
        this.initTxMgr(txFactoryClassName);
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("openjpa.Log", "commons");
        propMap.put("openjpa.ManagedRuntime", new JpaTxMgrProvider(this._txMgr));
        propMap.put("openjpa.ConnectionFactory", this._ds);
        propMap.put("openjpa.ConnectionFactoryMode", "managed");
        propMap.put("openjpa.FlushBeforeQueries", "true");
        propMap.put("openjpa.jdbc.TransactionIsolation", "read-committed");
        if (createDatamodel) {
            propMap.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=false)");
        }
        this._emf = Persistence.createEntityManagerFactory((String)"ode-store", propMap);
    }

    public ConfStoreConnection getConnection() {
        HashMap<String, String> propMap2 = new HashMap<String, String>();
        propMap2.put("openjpa.TransactionMode", "managed");
        return new ConfStoreConnectionJpa(this._emf.createEntityManager(propMap2));
    }

    public void beginTransaction() {
        try {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("begin transaction on " + this._txMgr));
            }
            this._txMgr.begin();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void commitTransaction() {
        try {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("commit transaction on " + this._txMgr));
            }
            this._txMgr.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void rollbackTransaction() {
        try {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("rollback transaction on " + this._txMgr));
            }
            this._txMgr.rollback();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initTxMgr(String txFactoryClassName) {
        __log.info((Object)("ProcessStore initializing transaction manager using " + txFactoryClassName));
        try {
            Class<?> txFactClass = this.getClass().getClassLoader().loadClass(txFactoryClassName);
            Object txFact = txFactClass.newInstance();
            this._txMgr = (TransactionManager)txFactClass.getMethod("getTransactionManager", null).invoke(txFact, new Object[0]);
        }
        catch (Exception e) {
            __log.fatal((Object)("Couldn't initialize a transaction manager with factory: " + txFactoryClassName), (Throwable)e);
            throw new RuntimeException("Couldn't initialize a transaction manager with factory: " + txFactoryClassName, e);
        }
    }
}

