/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactoryJDBC;
import org.apache.ode.dao.jpa.BPELDAOConnectionImpl;
import org.apache.ode.dao.jpa.JpaTxMgrProvider;
import org.apache.openjpa.persistence.EntityManagerImpl;

public class BPELDAOConnectionFactoryImpl
implements BpelDAOConnectionFactoryJDBC {
    static final Log __log = LogFactory.getLog(BPELDAOConnectionFactoryImpl.class);
    protected EntityManagerFactory _emf;
    private TransactionManager _tm;
    private DataSource _ds;
    private Object _dbdictionary;
    static ThreadLocal<BPELDAOConnectionImpl> _connections = new ThreadLocal();

    public static Connection getExistingJDBCConnection() {
        BPELDAOConnectionImpl bpelConn = _connections.get();
        if (bpelConn != null) {
            __log.debug((Object)"getting existing db connection ");
            Object delegate = bpelConn.getEntityManager().getDelegate();
            if (delegate instanceof EntityManagerImpl) {
                EntityManagerImpl em = (EntityManagerImpl)delegate;
                __log.debug((Object)" getting the delegate from entity manager");
                em.beginStore();
                Object conn = em.getConnection();
                return (Connection)conn;
            }
            __log.debug((Object)" Entity manage is not the delegate");
            return null;
        }
        __log.debug((Object)" existing db connection is null");
        return null;
    }

    private boolean isInTx() throws SystemException {
        return this._tm.getTransaction() != null && this._tm.getTransaction().getStatus() == 0;
    }

    public BpelDAOConnection getConnection() {
        if (_connections.get() != null) {
            return _connections.get();
        }
        try {
            if (this.isInTx()) {
                HashMap propMap2 = new HashMap();
                EntityManager em = this._emf.createEntityManager(propMap2);
                em.getTransaction().begin();
                BPELDAOConnectionImpl conn = this.createBPELDAOConnection(em);
                _connections.set(conn);
                this._tm.getTransaction().registerSynchronization(new Synchronization(){

                    public void afterCompletion(int i) {
                        if (_connections.get() != null) {
                            if (i == 3) {
                                __log.debug((Object)" get connection synchronization: COMMITTED START");
                                _connections.get().getEntityManager().getTransaction().commit();
                                _connections.get().getEntityManager().close();
                                _connections.set(null);
                            } else if (i == 4) {
                                __log.debug((Object)" getConnection synchronization: ROLLBACK START");
                                _connections.get().getEntityManager().getTransaction().rollback();
                                _connections.get().getEntityManager().close();
                                _connections.set(null);
                            }
                        }
                    }

                    public void beforeCompletion() {
                    }
                });
                return conn;
            }
            return null;
        }
        catch (RollbackException e) {
            throw new RuntimeException("Coulnd't register synchronizer!");
        }
        catch (SystemException e) {
            throw new RuntimeException("Coulnd't register synchronizer!");
        }
    }

    protected BPELDAOConnectionImpl createBPELDAOConnection(EntityManager em) {
        return new BPELDAOConnectionImpl(em);
    }

    public void init(Properties properties) {
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("openjpa.Log", "commons");
        propMap.put("openjpa.ManagedRuntime", new JpaTxMgrProvider(this._tm));
        propMap.put("openjpa.ConnectionFactory", this._ds);
        propMap.put("openjpa.ConnectionFactoryMode", "managed");
        propMap.put("openjpa.jdbc.TransactionIsolation", "read-committed");
        if (this._dbdictionary != null) {
            propMap.put("openjpa.jdbc.DBDictionary", this._dbdictionary);
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> me : properties.entrySet()) {
                propMap.put((String)me.getKey(), me.getValue());
            }
        }
        this._emf = Persistence.createEntityManagerFactory((String)"ode-dao", propMap);
    }

    public void setTransactionManager(TransactionManager tm) {
        this._tm = tm;
    }

    public void setDataSource(DataSource datasource) {
        this._ds = datasource;
    }

    public void setDBDictionary(String dbd) {
        this._dbdictionary = dbd;
    }

    public void setTransactionManager(Object tm) {
        this._tm = (TransactionManager)tm;
    }

    public void setUnmanagedDataSource(DataSource ds) {
    }

    public void shutdown() {
        this._emf.close();
    }

    public DataSource getDataSource() {
        return this._ds;
    }
}

