/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.AttachmentDAO;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.FilteredInstanceDeletable;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ProcessManagementDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.dao.jpa.AttachmentDAOImpl;
import org.apache.ode.dao.jpa.CorrelationSetDAOImpl;
import org.apache.ode.dao.jpa.EventDAOImpl;
import org.apache.ode.dao.jpa.MessageExchangeDAOImpl;
import org.apache.ode.dao.jpa.ProcessDAOImpl;
import org.apache.ode.dao.jpa.ProcessInstanceDAOImpl;
import org.apache.ode.dao.jpa.ProcessManagementDAOImpl;
import org.apache.ode.dao.jpa.ScopeDAOImpl;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;

public class BPELDAOConnectionImpl
implements BpelDAOConnection,
FilteredInstanceDeletable {
    static final Log __log = LogFactory.getLog(BPELDAOConnectionImpl.class);
    protected EntityManager _em;

    public BPELDAOConnectionImpl(EntityManager em) {
        this._em = em;
    }

    public List<BpelEvent> bpelEventQuery(InstanceFilter ifilter, BpelEventFilter efilter) {
        throw new UnsupportedOperationException();
    }

    public List<Date> bpelEventTimelineQuery(InstanceFilter ifilter, BpelEventFilter efilter) {
        throw new UnsupportedOperationException();
    }

    public ProcessInstanceDAO getInstance(Long iid) {
        ProcessInstanceDAOImpl instance = (ProcessInstanceDAOImpl)this._em.find(ProcessInstanceDAOImpl.class, (Object)iid);
        return instance;
    }

    public void close() {
        this._em = null;
    }

    public MessageExchangeDAO createMessageExchange(char dir) {
        MessageExchangeDAOImpl ret = new MessageExchangeDAOImpl(dir);
        this._em.persist((Object)ret);
        return ret;
    }

    public ProcessDAO createProcess(QName pid, QName type, String guid, long version) {
        ProcessDAOImpl ret = new ProcessDAOImpl(pid, type, guid, version);
        this._em.persist((Object)ret);
        return ret;
    }

    public ProcessDAO createTransientProcess(Long id) {
        ProcessDAOImpl ret = new ProcessDAOImpl(null, null, null, 0L);
        ret.setId(id);
        return ret;
    }

    public ProcessDAO getProcess(QName processId) {
        List l = this._em.createQuery("select x from ProcessDAOImpl x where x._processId = ?1").setParameter(1, (Object)processId.toString()).getResultList();
        if (l.size() == 0) {
            return null;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("GetProcess#size=" + l.size()));
        }
        return (ProcessDAOImpl)l.get(0);
    }

    public int getNumInstances(QName processId) {
        ProcessDAO process = this.getProcess(processId);
        if (process != null) {
            return process.getNumInstances();
        }
        return -1;
    }

    public ScopeDAO getScope(Long siidl) {
        return (ScopeDAO)this._em.find(ScopeDAOImpl.class, (Object)siidl);
    }

    public void insertBpelEvent(BpelEvent event, ProcessDAO process, ProcessInstanceDAO instance) {
        EventDAOImpl eventDao = new EventDAOImpl();
        eventDao.setTstamp(new Timestamp(System.currentTimeMillis()));
        eventDao.setType(BpelEvent.eventName((BpelEvent)event));
        String evtStr = event.toString();
        eventDao.setDetail(evtStr.substring(0, Math.min(254, evtStr.length())));
        if (process != null) {
            eventDao.setProcess((ProcessDAOImpl)process);
        }
        if (instance != null) {
            eventDao.setInstance((ProcessInstanceDAOImpl)instance);
        }
        if (event instanceof ScopeEvent) {
            eventDao.setScopeId(((ScopeEvent)event).getScopeId());
        }
        eventDao.setEvent(event);
        this._em.persist((Object)eventDao);
    }

    private static String dateFilter(String filter) {
        String date = Filter.getDateWithoutOp((String)filter);
        String op = filter.substring(0, filter.indexOf(date));
        Date dt = null;
        try {
            dt = ISO8601DateParser.parse((String)date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Timestamp ts = new Timestamp(dt.getTime());
        return op + " '" + ts.toString() + "'";
    }

    public Collection<ProcessInstanceDAO> instanceQuery(InstanceFilter criteria) {
        StringBuffer query = this.instanceFilterToJPQLQuery(criteria, false);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)query.toString());
        }
        Query pq = this._em.createQuery(query.toString());
        pq.setMaxResults(criteria.getLimit());
        OpenJPAQuery kq = OpenJPAPersistence.cast((Query)pq);
        kq.getFetchPlan().setFetchBatchSize(criteria.getLimit() + 5);
        List ql = pq.getResultList();
        ArrayList<ProcessInstanceDAO> list = new ArrayList<ProcessInstanceDAO>();
        int num = 0;
        Iterator iterator = ql.iterator();
        while (iterator.hasNext() && num++ <= criteria.getLimit()) {
            ProcessInstanceDAO processInstanceDAO = (ProcessInstanceDAO)iterator.next();
            list.add(processInstanceDAO);
        }
        return list;
    }

    public Collection<ProcessInstanceDAO> instanceQuery(String expression) {
        return this.instanceQuery(new InstanceFilter(expression));
    }

    public Long instanceCount(InstanceFilter criteria) {
        StringBuffer queryString = this.instanceFilterToJPQLQuery(criteria, true);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Instance Count Query: " + queryString.toString()));
        }
        Query query = this._em.createQuery(queryString.toString());
        OpenJPAQuery jpaQuery = OpenJPAPersistence.cast((Query)query);
        Long instanceCount = (Long)jpaQuery.getSingleResult();
        return instanceCount;
    }

    public StringBuffer instanceFilterToJPQLQuery(InstanceFilter criteria, boolean returnCount) {
        StringBuffer query = new StringBuffer();
        if (returnCount) {
            query.append("select count(pi) from ProcessInstanceDAOImpl as pi ");
        } else {
            query.append("select pi from ProcessInstanceDAOImpl as pi left join fetch pi._fault ");
        }
        if (criteria != null) {
            int m;
            StringBuffer filters;
            ArrayList<String> clauses = new ArrayList<String>();
            if (criteria.getIidFilter() != null) {
                filters = new StringBuffer();
                List iids = criteria.getIidFilter();
                for (m = 0; m < iids.size(); ++m) {
                    filters.append(" pi._instanceId = ").append((String)iids.get(m));
                    if (m >= iids.size() - 1) continue;
                    filters.append(" or");
                }
                clauses.add(" (" + filters + ")");
            }
            if (criteria.getPidFilter() != null) {
                filters = new StringBuffer();
                List pids = criteria.getPidFilter();
                for (m = 0; m < pids.size(); ++m) {
                    filters.append(" pi._process._processId = '").append((String)pids.get(m)).append("'");
                    if (m >= pids.size() - 1) continue;
                    filters.append(" or");
                }
                clauses.add(" (" + filters + ")");
            }
            if (criteria.getNameFilter() != null) {
                String val = criteria.getNameFilter();
                if (val.endsWith("*")) {
                    val = val.substring(0, val.length() - 1) + "%";
                }
                clauses.add(" pi._process._processType like '%" + val + "'");
            }
            if (criteria.getNamespaceFilter() != null) {
                clauses.add(" pi._process._processType like '{" + criteria.getNamespaceFilter() + "%'");
            }
            if (criteria.getStartedDateFilter() != null) {
                for (String ds : criteria.getStartedDateFilter()) {
                    clauses.add(" pi._dateCreated " + BPELDAOConnectionImpl.dateFilter(ds));
                }
            }
            if (criteria.getLastActiveDateFilter() != null) {
                for (String ds : criteria.getLastActiveDateFilter()) {
                    clauses.add(" pi._lastActive " + BPELDAOConnectionImpl.dateFilter(ds));
                }
            }
            if (criteria.getStatusFilter() != null) {
                filters = new StringBuffer();
                List states = criteria.convertFilterState();
                for (m = 0; m < states.size(); ++m) {
                    filters.append(" pi._state = ").append(states.get(m));
                    if (m >= states.size() - 1) continue;
                    filters.append(" or");
                }
                clauses.add(" (" + filters.toString() + ")");
            }
            if (criteria.getPropertyValuesFilter() != null) {
                Map props = criteria.getPropertyValuesFilter();
                query.append(" inner join pi._rootScope._correlationSets as cs");
                int i = 0;
                for (String propKey : props.keySet()) {
                    query.append(" inner join cs._props as csp" + ++i);
                    clauses.add(" csp" + i + ".propertyKey = '" + propKey + "' and csp" + i + ".propertyValue = '" + ((String)props.get(propKey)).replaceAll("&#32;", " ") + "'");
                }
            }
            StringBuffer orderby = new StringBuffer("");
            if (criteria.getOrders() != null) {
                orderby.append(" order by");
                List orders = criteria.getOrders();
                for (int m2 = 0; m2 < orders.size(); ++m2) {
                    String field = (String)orders.get(m2);
                    String ord = " asc";
                    if (field.startsWith("-")) {
                        ord = " desc";
                    }
                    String fieldName = " pi._instanceId";
                    if (field.endsWith("name") || field.endsWith("namespace")) {
                        fieldName = " pi._process._processType";
                    }
                    if (field.endsWith("version")) {
                        fieldName = " pi._process._version";
                    }
                    if (field.endsWith("status")) {
                        fieldName = " pi._state";
                    }
                    if (field.endsWith("started")) {
                        fieldName = " pi._dateCreated";
                    }
                    if (field.endsWith("last-active")) {
                        fieldName = " pi._lastActive";
                    }
                    orderby.append(fieldName + ord);
                    if (m2 >= orders.size() - 1) continue;
                    orderby.append(", ");
                }
            }
            if (clauses.size() > 0) {
                query.append(" where");
                for (int m3 = 0; m3 < clauses.size(); ++m3) {
                    query.append((String)clauses.get(m3));
                    if (m3 >= clauses.size() - 1) continue;
                    query.append(" and");
                }
            }
            query.append(orderby);
        }
        return query;
    }

    public void setEntityManger(EntityManager em) {
        this._em = em;
    }

    public MessageExchangeDAO getMessageExchange(String mexid) {
        return (MessageExchangeDAO)this._em.find(MessageExchangeDAOImpl.class, (Object)mexid);
    }

    public void deleteMessageExchange(MessageExchangeDAO mexDao) {
        this._em.remove((Object)mexDao);
    }

    public EntityManager getEntityManager() {
        return this._em;
    }

    public Map<Long, Collection<CorrelationSetDAO>> getCorrelationSets(Collection<ProcessInstanceDAO> instances) {
        if (instances.size() == 0) {
            return new HashMap<Long, Collection<CorrelationSetDAO>>();
        }
        ArrayList<Long> iids = new ArrayList<Long>(instances.size());
        for (ProcessInstanceDAO dao : instances) {
            iids.add(dao.getInstanceId());
        }
        List csets = this._em.createNamedQuery("SELECT_CORRELATION_SETS_BY_INSTANCES").setParameter("instances", iids).getResultList();
        HashMap<Long, Collection<CorrelationSetDAO>> map = new HashMap<Long, Collection<CorrelationSetDAO>>();
        for (CorrelationSetDAOImpl cset : csets) {
            Long id = cset.getScope().getProcessInstance().getInstanceId();
            ArrayList<CorrelationSetDAOImpl> existing = (ArrayList<CorrelationSetDAOImpl>)map.get(id);
            if (existing == null) {
                existing = new ArrayList<CorrelationSetDAOImpl>();
                map.put(id, existing);
            }
            existing.add(cset);
        }
        return map;
    }

    public Collection<CorrelationSetDAO> getActiveCorrelationSets() {
        return this._em.createNamedQuery("SELECT_ACTIVE_SETS").setParameter("state", (Object)20).getResultList();
    }

    public int deleteInstances(InstanceFilter filter, Set<ProcessConf.CLEANUP_CATEGORY> categories) {
        if (filter.getLimit() == 0) {
            return 0;
        }
        Collection<ProcessInstanceDAO> instances = this.instanceQuery(filter);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Collected " + instances.size() + " instances to delete."));
        }
        if (!instances.isEmpty()) {
            for (ProcessInstanceDAO processInstance : instances) {
                processInstance.delete(categories, true);
            }
            return instances.size();
        }
        return 0;
    }

    public ProcessManagementDAO getProcessManagement() {
        return new ProcessManagementDAOImpl(this._em);
    }

    public AttachmentDAO getAttachmentDAO(Long attachmentID, MessageExchangeDAO mex) {
        AttachmentDAOImpl dao = new AttachmentDAOImpl();
        dao.setId(attachmentID);
        dao.setMexDAO(mex);
        return dao;
    }
}

