/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.jpa.BPELDAOConnectionFactoryImpl;
import org.apache.ode.dao.jpa.BPELDAOConnectionImpl;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;

public class OpenJPADAO {
    private static final Log __log = LogFactory.getLog(OpenJPADAO.class);

    protected BPELDAOConnectionImpl getConn() {
        return BPELDAOConnectionFactoryImpl._connections.get();
    }

    protected EntityManager getEM() {
        return OpenJPAPersistence.getEntityManager((Object)this);
    }

    protected <T> T getSingleResult(Query qry) {
        List res = qry.getResultList();
        if (res.size() == 0) {
            return null;
        }
        return (T)res.get(0);
    }

    protected <T> void batchUpdateByIds(Iterator<T> ids, Query query, String parameterName) {
        if (query instanceof OpenJPAQuery) {
            OpenJPAQuery openJpaQuery = (OpenJPAQuery)query;
            int batchSize = openJpaQuery.getFetchPlan().getFetchBatchSize();
            if (batchSize <= 0) {
                batchSize = 50;
                if (__log.isTraceEnabled()) {
                    __log.trace((Object)"JPA Query fetchBatchSize=-1, so defaults to 50.");
                }
            } else if (__log.isTraceEnabled()) {
                __log.trace((Object)("BATCH fetchBatchSize = " + batchSize));
            }
            ArrayList<T> batch = new ArrayList<T>();
            while (ids.hasNext()) {
                for (int i = 0; i < batchSize && ids.hasNext(); ++i) {
                    batch.add(ids.next());
                }
                if (__log.isTraceEnabled()) {
                    __log.trace((Object)("BATCH updating " + batch.size() + " objects."));
                }
                query.setParameter(parameterName, batch);
                query.executeUpdate();
                batch.clear();
            }
        }
    }
}

