/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.dao.jpa.ScopeDAOImpl;
import org.apache.ode.dao.jpa.XmlDataProperty;
import org.apache.ode.utils.DOMUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@Entity
@Table(name="ODE_XML_DATA")
@NamedQueries(value={@NamedQuery(name="SELECT_XMLDATA_IDS_BY_PROCESS", query="select distinct x._id from XmlDataDAOImpl as x where x._scope._processInstance._process = :process"), @NamedQuery(name="SELECT_XMLDATA_IDS_BY_INSTANCE", query="select distinct x._id from XmlDataDAOImpl as x where x._scope._processInstance = :instance"), @NamedQuery(name="DELETE_XMLDATA_BY_SCOPE_IDS", query="delete from XmlDataDAOImpl as x where x._scopeId in(:scopeIds)")})
public class XmlDataDAOImpl
implements XmlDataDAO,
PersistenceCapable {
    public static final String SELECT_XMLDATA_IDS_BY_PROCESS = "SELECT_XMLDATA_IDS_BY_PROCESS";
    public static final String SELECT_XMLDATA_IDS_BY_INSTANCE = "SELECT_XMLDATA_IDS_BY_INSTANCE";
    public static final String DELETE_XMLDATA_BY_SCOPE_IDS = "DELETE_XMLDATA_BY_SCOPE_IDS";
    @Id
    @Column(name="XML_DATA_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _id;
    @Lob
    @Column(name="DATA")
    private String _data;
    @Transient
    private Node _node;
    @Basic
    @Column(name="IS_SIMPLE_TYPE")
    private boolean _isSimpleType;
    @Basic
    @Column(name="NAME")
    private String _name;
    @OneToMany(targetEntity=XmlDataProperty.class, mappedBy="_xmlData", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<XmlDataProperty> _props = new ArrayList<XmlDataProperty>();
    @Basic
    @Column(name="SCOPE_ID", nullable=true, insertable=false, updatable=false)
    private Long _scopeId;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @Column(name="SCOPE_ID")
    private ScopeDAOImpl _scope;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$ScopeDAOImpl;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$XmlDataDAOImpl;
    private transient Object pcDetachedState;

    public XmlDataDAOImpl() {
    }

    public XmlDataDAOImpl(ScopeDAOImpl scope, String name) {
        this._scope = scope;
        this._name = name;
    }

    public Node get() {
        if (this._node == null && XmlDataDAOImpl.pcGet_data(this) != null) {
            if (XmlDataDAOImpl.pcGet_isSimpleType(this)) {
                Document d = DOMUtils.newDocument();
                Element e = d.createElement("text-node-wrapper");
                Text tnode = d.createTextNode(XmlDataDAOImpl.pcGet_data(this));
                d.appendChild(e);
                e.appendChild(tnode);
                this._node = tnode;
            } else {
                try {
                    this._node = DOMUtils.stringToDOM((String)XmlDataDAOImpl.pcGet_data(this));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this._node;
    }

    public String getName() {
        return XmlDataDAOImpl.pcGet_name(this);
    }

    public String getProperty(String propertyName) {
        for (XmlDataProperty prop : XmlDataDAOImpl.pcGet_props(this)) {
            if (!prop.getPropertyKey().equals(propertyName)) continue;
            return prop.getPropertyValue();
        }
        return null;
    }

    private XmlDataProperty getPropertyObject(String propertyName) {
        for (XmlDataProperty prop : XmlDataDAOImpl.pcGet_props(this)) {
            if (!prop.getPropertyKey().equals(propertyName)) continue;
            return prop;
        }
        return null;
    }

    public Collection<XmlDataProperty> getProps() {
        return XmlDataDAOImpl.pcGet_props(this);
    }

    public void setProps(Collection<XmlDataProperty> _props) {
        XmlDataDAOImpl.pcSet_props(this, _props);
    }

    public ScopeDAO getScopeDAO() {
        return XmlDataDAOImpl.pcGet_scope(this);
    }

    public boolean isNull() {
        return XmlDataDAOImpl.pcGet_data(this) == null;
    }

    public void remove() {
    }

    public void set(Node val) {
        this._node = val;
        if (val instanceof Element) {
            XmlDataDAOImpl.pcSet_isSimpleType(this, false);
            XmlDataDAOImpl.pcSet_data(this, DOMUtils.domToString((Node)val));
        } else if (this._node != null) {
            XmlDataDAOImpl.pcSet_isSimpleType(this, true);
            XmlDataDAOImpl.pcSet_data(this, this._node.getNodeValue());
        }
    }

    public void setProperty(String pname, String pvalue) {
        XmlDataProperty prop = this.getPropertyObject(pname);
        if (prop == null) {
            XmlDataDAOImpl.pcGet_props(this).add(new XmlDataProperty(pname, pvalue, this));
        } else {
            prop.setPropertyValue(pvalue);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (XmlDataDAOImpl.pcGet_id(this) == null ? 0 : XmlDataDAOImpl.pcGet_id(this).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XmlDataDAOImpl other = (XmlDataDAOImpl)obj;
        return !(XmlDataDAOImpl.pcGet_id(this) == null ? XmlDataDAOImpl.pcGet_id(other) != null : !XmlDataDAOImpl.pcGet_id(this).equals(XmlDataDAOImpl.pcGet_id(other)));
    }

    public int pcGetEnhancementContractVersion() {
        return 128166;
    }

    static {
        pcFieldNames = new String[]{"_data", "_id", "_isSimpleType", "_name", "_props", "_scope", "_scopeId"};
        Class[] classArray = new Class[7];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = XmlDataDAOImpl.class$("java.lang.String"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = XmlDataDAOImpl.class$("java.lang.Long"));
        classArray[1] = clazz2;
        classArray[2] = Boolean.TYPE;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = XmlDataDAOImpl.class$("java.lang.String"));
        Class clazz3 = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = XmlDataDAOImpl.class$("java.util.Collection"));
        classArray[4] = clazz3;
        Class clazz4 = class$Lorg$apache$ode$dao$jpa$ScopeDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ScopeDAOImpl : (class$Lorg$apache$ode$dao$jpa$ScopeDAOImpl = XmlDataDAOImpl.class$("org.apache.ode.dao.jpa.ScopeDAOImpl"));
        classArray[5] = clazz4;
        classArray[6] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = XmlDataDAOImpl.class$("java.lang.Long"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 5, 10, 26};
        Class clazz5 = class$Lorg$apache$ode$dao$jpa$XmlDataDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$XmlDataDAOImpl : (class$Lorg$apache$ode$dao$jpa$XmlDataDAOImpl = XmlDataDAOImpl.class$("org.apache.ode.dao.jpa.XmlDataDAOImpl"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"XmlDataDAOImpl", (PersistenceCapable)new XmlDataDAOImpl());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this._data = null;
        this._id = null;
        this._isSimpleType = false;
        this._name = null;
        this._props = null;
        this._scope = null;
        this._scopeId = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        XmlDataDAOImpl xmlDataDAOImpl = new XmlDataDAOImpl();
        if (bl) {
            xmlDataDAOImpl.pcClearFields();
        }
        xmlDataDAOImpl.pcStateManager = stateManager;
        xmlDataDAOImpl.pcCopyKeyFieldsFromObjectId(object);
        return xmlDataDAOImpl;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        XmlDataDAOImpl xmlDataDAOImpl = new XmlDataDAOImpl();
        if (bl) {
            xmlDataDAOImpl.pcClearFields();
        }
        xmlDataDAOImpl.pcStateManager = stateManager;
        return xmlDataDAOImpl;
    }

    protected static int pcGetManagedFieldCount() {
        return 7;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._data = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this._id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this._isSimpleType = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this._name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this._props = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this._scope = (ScopeDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this._scopeId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._data);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._id);
                return;
            }
            case 2: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this._isSimpleType);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._name);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._props);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._scope);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._scopeId);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(XmlDataDAOImpl xmlDataDAOImpl, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._data = xmlDataDAOImpl._data;
                return;
            }
            case 1: {
                this._id = xmlDataDAOImpl._id;
                return;
            }
            case 2: {
                this._isSimpleType = xmlDataDAOImpl._isSimpleType;
                return;
            }
            case 3: {
                this._name = xmlDataDAOImpl._name;
                return;
            }
            case 4: {
                this._props = xmlDataDAOImpl._props;
                return;
            }
            case 5: {
                this._scope = xmlDataDAOImpl._scope;
                return;
            }
            case 6: {
                this._scopeId = xmlDataDAOImpl._scopeId;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        XmlDataDAOImpl xmlDataDAOImpl = (XmlDataDAOImpl)object;
        if (xmlDataDAOImpl.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(xmlDataDAOImpl, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(1 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this._id = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$ode$dao$jpa$XmlDataDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$XmlDataDAOImpl : (class$Lorg$apache$ode$dao$jpa$XmlDataDAOImpl = XmlDataDAOImpl.class$("org.apache.ode.dao.jpa.XmlDataDAOImpl"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$ode$dao$jpa$XmlDataDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$XmlDataDAOImpl : (class$Lorg$apache$ode$dao$jpa$XmlDataDAOImpl = XmlDataDAOImpl.class$("org.apache.ode.dao.jpa.XmlDataDAOImpl"));
        return new LongId(clazz, this._id);
    }

    private static final String pcGet_data(XmlDataDAOImpl xmlDataDAOImpl) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            return xmlDataDAOImpl._data;
        }
        int n = pcInheritedFieldCount + 0;
        xmlDataDAOImpl.pcStateManager.accessingField(n);
        return xmlDataDAOImpl._data;
    }

    private static final void pcSet_data(XmlDataDAOImpl xmlDataDAOImpl, String string) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            xmlDataDAOImpl._data = string;
            return;
        }
        xmlDataDAOImpl.pcStateManager.settingStringField((PersistenceCapable)xmlDataDAOImpl, pcInheritedFieldCount + 0, xmlDataDAOImpl._data, string, 0);
    }

    private static final Long pcGet_id(XmlDataDAOImpl xmlDataDAOImpl) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            return xmlDataDAOImpl._id;
        }
        int n = pcInheritedFieldCount + 1;
        xmlDataDAOImpl.pcStateManager.accessingField(n);
        return xmlDataDAOImpl._id;
    }

    private static final void pcSet_id(XmlDataDAOImpl xmlDataDAOImpl, Long l) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            xmlDataDAOImpl._id = l;
            return;
        }
        xmlDataDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)xmlDataDAOImpl, pcInheritedFieldCount + 1, (Object)xmlDataDAOImpl._id, (Object)l, 0);
    }

    private static final boolean pcGet_isSimpleType(XmlDataDAOImpl xmlDataDAOImpl) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            return xmlDataDAOImpl._isSimpleType;
        }
        int n = pcInheritedFieldCount + 2;
        xmlDataDAOImpl.pcStateManager.accessingField(n);
        return xmlDataDAOImpl._isSimpleType;
    }

    private static final void pcSet_isSimpleType(XmlDataDAOImpl xmlDataDAOImpl, boolean bl) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            xmlDataDAOImpl._isSimpleType = bl;
            return;
        }
        xmlDataDAOImpl.pcStateManager.settingBooleanField((PersistenceCapable)xmlDataDAOImpl, pcInheritedFieldCount + 2, xmlDataDAOImpl._isSimpleType, bl, 0);
    }

    private static final String pcGet_name(XmlDataDAOImpl xmlDataDAOImpl) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            return xmlDataDAOImpl._name;
        }
        int n = pcInheritedFieldCount + 3;
        xmlDataDAOImpl.pcStateManager.accessingField(n);
        return xmlDataDAOImpl._name;
    }

    private static final void pcSet_name(XmlDataDAOImpl xmlDataDAOImpl, String string) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            xmlDataDAOImpl._name = string;
            return;
        }
        xmlDataDAOImpl.pcStateManager.settingStringField((PersistenceCapable)xmlDataDAOImpl, pcInheritedFieldCount + 3, xmlDataDAOImpl._name, string, 0);
    }

    private static final Collection pcGet_props(XmlDataDAOImpl xmlDataDAOImpl) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            return xmlDataDAOImpl._props;
        }
        int n = pcInheritedFieldCount + 4;
        xmlDataDAOImpl.pcStateManager.accessingField(n);
        return xmlDataDAOImpl._props;
    }

    private static final void pcSet_props(XmlDataDAOImpl xmlDataDAOImpl, Collection collection) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            xmlDataDAOImpl._props = collection;
            return;
        }
        xmlDataDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)xmlDataDAOImpl, pcInheritedFieldCount + 4, xmlDataDAOImpl._props, (Object)collection, 0);
    }

    private static final ScopeDAOImpl pcGet_scope(XmlDataDAOImpl xmlDataDAOImpl) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            return xmlDataDAOImpl._scope;
        }
        int n = pcInheritedFieldCount + 5;
        xmlDataDAOImpl.pcStateManager.accessingField(n);
        return xmlDataDAOImpl._scope;
    }

    private static final void pcSet_scope(XmlDataDAOImpl xmlDataDAOImpl, ScopeDAOImpl scopeDAOImpl) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            xmlDataDAOImpl._scope = scopeDAOImpl;
            return;
        }
        xmlDataDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)xmlDataDAOImpl, pcInheritedFieldCount + 5, (Object)xmlDataDAOImpl._scope, (Object)scopeDAOImpl, 0);
    }

    private static final Long pcGet_scopeId(XmlDataDAOImpl xmlDataDAOImpl) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            return xmlDataDAOImpl._scopeId;
        }
        int n = pcInheritedFieldCount + 6;
        xmlDataDAOImpl.pcStateManager.accessingField(n);
        return xmlDataDAOImpl._scopeId;
    }

    private static final void pcSet_scopeId(XmlDataDAOImpl xmlDataDAOImpl, Long l) {
        if (xmlDataDAOImpl.pcStateManager == null) {
            xmlDataDAOImpl._scopeId = l;
            return;
        }
        xmlDataDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)xmlDataDAOImpl, pcInheritedFieldCount + 6, (Object)xmlDataDAOImpl._scopeId, (Object)l, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this._id != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

