/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.jbi.JbiEndpointReference;
import org.apache.ode.jbi.OdeContext;

class BindingContextImpl
implements BindingContext {
    private static final Log __log = LogFactory.getLog(BindingContextImpl.class);
    private final OdeContext _ode;

    BindingContextImpl(OdeContext ode) {
        this._ode = ode;
    }

    public EndpointReference activateMyRoleEndpoint(QName processId, Endpoint myRoleEndpoint) {
        try {
            return this._ode.activateEndpoint(processId, myRoleEndpoint);
        }
        catch (Exception ex) {
            throw new ContextException("Could not activate endpoint " + myRoleEndpoint + " for process " + processId, (Throwable)ex);
        }
    }

    public void deactivateMyRoleEndpoint(Endpoint myRoleEndpoint) {
        try {
            this._ode.deactivateEndpoint(myRoleEndpoint);
        }
        catch (Exception ex) {
            String errmsg = "Could not deactivate endpoint: " + myRoleEndpoint;
            __log.error((Object)errmsg, (Throwable)ex);
            throw new ContextException(errmsg, (Throwable)ex);
        }
    }

    public PartnerRoleChannel createPartnerRoleChannel(QName processId, PortType portType, Endpoint initialPartnerEndpoint) {
        if (initialPartnerEndpoint != null) {
            JbiEndpointReference jbiEpr = new JbiEndpointReference(initialPartnerEndpoint, this._ode);
            return new PartnerRoleChannelImpl(jbiEpr);
        }
        return new PartnerRoleChannelImpl();
    }

    public long calculateSizeofService(EndpointReference epr) {
        return this._ode.calculateSizeOfService(epr);
    }

    private class PartnerRoleChannelImpl
    implements PartnerRoleChannel {
        private final JbiEndpointReference _initialEPR;

        PartnerRoleChannelImpl(JbiEndpointReference epr) {
            this._initialEPR = epr;
        }

        PartnerRoleChannelImpl() {
            this._initialEPR = null;
        }

        public EndpointReference getInitialEndpointReference() {
            return this._initialEPR;
        }

        public void close() {
        }
    }
}

