/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMElement;
import org.apache.ode.il.DynamicService;
import org.apache.ode.il.OMUtils;
import org.apache.ode.jbi.BaseMessageExchangeProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicMessageExchangeProcessor<T>
extends BaseMessageExchangeProcessor {
    T _service;

    public DynamicMessageExchangeProcessor(T service, DeliveryChannel channel) {
        super(channel);
        this._service = service;
    }

    @Override
    public void invoke(InOnly mex) throws MessagingException {
        try {
            DynamicService service = new DynamicService(this._service);
            OMElement payload = OMUtils.toOM((Source)mex.getInMessage().getContent());
            service.invoke(mex.getOperation().getLocalPart(), payload);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NormalizedMessage invoke(InOut mex) throws MessagingException {
        try {
            DynamicService service = new DynamicService(this._service);
            OMElement payload = OMUtils.toOM((Source)mex.getInMessage().getContent());
            OMElement response = service.invoke(mex.getOperation().getLocalPart(), payload);
            NormalizedMessage nresponse = null;
            if (response != null) {
                nresponse = mex.createMessage();
                nresponse.setContent((Source)new DOMSource(OMUtils.toDOM((OMElement)response)));
            }
            return nresponse;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

