/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.jbi.JbiEndpointReference;
import org.apache.ode.jbi.OdeContext;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EndpointReferenceContextImpl
implements EndpointReferenceContext {
    private static final Log __log = LogFactory.getLog(EndpointReferenceContextImpl.class);
    private final OdeContext _ode;
    static final QName JBI_EPR = new QName("http://java.sun.com/jbi/end-point-reference", "end-point-reference");

    public EndpointReferenceContextImpl(OdeContext ode) {
        this._ode = ode;
    }

    public EndpointReference resolveEndpointReference(Element epr) {
        QName elname = new QName(epr.getNamespaceURI(), epr.getLocalName());
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("resolveEndpointReference:\n" + this.prettyPrint(epr)));
        }
        if (!elname.equals(EndpointReference.SERVICE_REF_QNAME)) {
            throw new IllegalArgumentException("EPR root element " + elname + " should be " + EndpointReference.SERVICE_REF_QNAME);
        }
        Document doc = DOMUtils.newDocument();
        DocumentFragment fragment = doc.createDocumentFragment();
        NodeList children = epr.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            fragment.appendChild(doc.importNode(children.item(i), true));
        }
        ServiceEndpoint se = this._ode.getContext().resolveEndpointReference(fragment);
        if (se == null) {
            return null;
        }
        return new JbiEndpointReference(se);
    }

    public EndpointReference convertEndpoint(QName eprType, Element epr) {
        Document doc = DOMUtils.newDocument();
        DocumentFragment fragment = doc.createDocumentFragment();
        NodeList children = epr.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            fragment.appendChild(doc.importNode(children.item(i), true));
        }
        ServiceEndpoint se = this._ode.getContext().resolveEndpointReference(fragment);
        if (se == null) {
            return null;
        }
        return new JbiEndpointReference(se, eprType);
    }

    public static QName convertClarkQName(String name) {
        int pos = name.indexOf(125);
        if (name.startsWith("{") && pos > 0) {
            String ns = name.substring(1, pos);
            String lname = name.substring(pos + 1, name.length());
            return new QName(ns, lname);
        }
        return new QName(name);
    }

    private String prettyPrint(Element el) {
        try {
            return DOMUtils.prettyPrint((Element)el);
        }
        catch (IOException ioe) {
            return ioe.getMessage();
        }
    }

    public Map getConfigLookup(EndpointReference epr) {
        HashMap<String, QName> m = new HashMap<String, QName>();
        m.put("service", ((JbiEndpointReference)epr).getServiceEndpoint().getServiceName());
        return m;
    }
}

