/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.jbi.OdeContext;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

class JbiEndpointReference
implements EndpointReference {
    private OdeContext _ode;
    private Endpoint _initialPartnerEndpoint;
    private ServiceEndpoint _se;
    private QName _type;

    JbiEndpointReference(Endpoint initialPartnerEndpoint, OdeContext ode) {
        this._initialPartnerEndpoint = initialPartnerEndpoint;
        this._ode = ode;
    }

    JbiEndpointReference(ServiceEndpoint se) {
        if (se == null) {
            throw new NullPointerException("Null ServiceEndpoint");
        }
        this._se = se;
    }

    public JbiEndpointReference(ServiceEndpoint se, QName eprType) {
        this(se);
        this._type = eprType;
    }

    public Document toXML() {
        Document doc = DOMUtils.newDocument();
        Element root = doc.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        try {
            DocumentFragment fragment = this.getServiceEndpoint().getAsReference(this._type);
            if (fragment != null) {
                root.appendChild(doc.importNode(fragment, true));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        doc.appendChild(root);
        return doc;
    }

    public boolean equals(Object other) {
        if (other instanceof JbiEndpointReference) {
            return this.getServiceEndpoint().getServiceName().equals(((JbiEndpointReference)other).getServiceEndpoint().getServiceName());
        }
        return false;
    }

    public int hashCode() {
        return this.getServiceEndpoint().getServiceName().hashCode();
    }

    public String toString() {
        if (this._se != null) {
            return "JbiEndpointReference[" + this._se.getServiceName() + ":" + this._se.getEndpointName() + "]";
        }
        if (this._initialPartnerEndpoint != null) {
            return "JbiEndpointReference[" + this._initialPartnerEndpoint.serviceName + ":" + this._initialPartnerEndpoint.portName + "]";
        }
        return "JbiEndpointReference[unknown]";
    }

    ServiceEndpoint getServiceEndpoint() {
        if (this._se == null && this._initialPartnerEndpoint != null) {
            this._se = this._ode.getContext().getEndpoint(this._initialPartnerEndpoint.serviceName, this._initialPartnerEndpoint.portName);
            if (this._se == null) {
                throw new ContextException("Unknown endpoint: " + this._initialPartnerEndpoint, null);
            }
        }
        return this._se;
    }
}

