/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jbi;

import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.jbi.OdeConsumer;
import org.apache.ode.jbi.OdeContext;

class OdeConsumerSync
extends OdeConsumer {
    private static final Log __log = LogFactory.getLog(OdeConsumerSync.class);

    OdeConsumerSync(OdeContext ode) {
        super(ode);
    }

    protected void doSendTwoWay(final PartnerRoleMessageExchange odeMex, final InOut inout) {
        this._ode._executorService.submit(new Runnable(){

            public void run() {
                try {
                    OdeConsumerSync.this._outstandingExchanges.put(inout.getExchangeId(), odeMex);
                    boolean sendOk = OdeConsumerSync.this._ode.getChannel().sendSync((MessageExchange)inout, OdeConsumerSync.this._responseTimeout);
                    if (!sendOk) {
                        __log.warn((Object)("Timeout while sending message for JBI message exchange: " + inout.getExchangeId()));
                    }
                    OdeConsumerSync.this.onJbiMessageExchange((MessageExchange)inout);
                }
                catch (MessagingException e) {
                    String errmsg = "Error sending request-response message to JBI for ODE mex " + odeMex;
                    __log.error((Object)errmsg, (Throwable)e);
                }
            }
        });
    }

    protected void doSendOneWay(final PartnerRoleMessageExchange odeMex, final InOnly inonly) {
        this._ode._executorService.submit(new Runnable(){

            public void run() {
                try {
                    boolean sendOk = OdeConsumerSync.this._ode.getChannel().sendSync((MessageExchange)inonly, OdeConsumerSync.this._responseTimeout);
                    if (!sendOk) {
                        __log.warn((Object)("Timeout while sending message for JBI message exchange: " + inonly.getExchangeId()));
                    }
                    OdeConsumerSync.this.onJbiMessageExchange((MessageExchange)inonly);
                }
                catch (MessagingException e) {
                    String errmsg = "Error sending request-only message to JBI for ODE mex " + odeMex;
                    __log.error((Object)errmsg, (Throwable)e);
                }
            }
        });
    }

    protected void inOutDone(InOut inout) {
    }
}

